<?php
// Load the event plan
$planId = isset($_GET['plan_id']) ? $_GET['plan_id'] : '';
$plan = getEntityById(EVENT_PLANS_FILE, $planId);

if (!$plan) {
    echo '<div class="alert alert-danger">Rencana event tidak ditemukan.</div>';
    echo '<a href="index.php?page=event_plans" class="btn btn-primary">Kembali ke Rencana Event</a>';
    return;
}

if ($plan['converted_to_event']) {
    echo '<div class="alert alert-info">Rencana event ini sudah dikonversi menjadi event.</div>';
    echo '<a href="index.php?page=events" class="btn btn-primary">Lihat Daftar Event</a>';
    return;
}

$organizer = getEntityById(ORGANIZERS_FILE, $plan['organizer_id']);
?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Konversi Rencana Event ke Event</h5>
    </div>
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Nama Event:</h6>
                <p class="lead"><?= htmlspecialchars($plan['name']) ?></p>
            </div>
            <div class="col-md-6">
                <h6>Penyelenggara:</h6>
                <p class="lead"><?= htmlspecialchars($organizer['name']) ?></p>
            </div>
        </div>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Waktu Pendaftaran:</h6>
                <p><?= date('d/m/Y', strtotime($plan['registration_start'])) ?> - <?= date('d/m/Y', strtotime($plan['registration_end'])) ?></p>
            </div>
            <div class="col-md-6">
                <h6>Waktu Pelaksanaan:</h6>
                <p><?= date('d/m/Y', strtotime($plan['event_start'])) ?> - <?= date('d/m/Y', strtotime($plan['event_end'])) ?></p>
            </div>
        </div>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Akses Penghargaan:</h6>
                <p><?= date('d/m/Y', strtotime($plan['award_access'])) ?></p>
            </div>
            <div class="col-md-6">
                <h6>Tanggal Sapu Bersih:</h6>
                <p><?= date('d/m/Y', strtotime($plan['cleanup_date'])) ?></p>
            </div>
        </div>
        

        
        <form method="post">
            <input type="hidden" name="action" value="convert_to_event">
            <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>">
            
            <div class="mb-4">
                <h5 class="mb-3">Informasi Tambahan Event</h5>
                
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Event</label>
                    <textarea class="form-control" id="description" name="description" rows="6" required placeholder="Masukkan deskripsi lengkap tentang event ini"></textarea>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Link Gambar/Poster (dapat lebih dari satu)</label>
                    <div id="image-links-container">
                        <div class="mb-2 row">
                            <div class="col-md-9">
                                <input type="url" class="form-control" name="image_links[]" placeholder="https://example.com/image.jpg" required>
                            </div>
                            <div class="col-md-3">
                                <button type="button" class="btn btn-sm btn-outline-secondary add-image">+ Tambah Gambar</button>
                            </div>
                        </div>
                    </div>
                    <small class="text-muted">Masukkan link gambar yang sudah di-host sebelumnya</small>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="index.php?page=event_plans" class="btn btn-secondary">Kembali</a>
                <button type="submit" class="btn btn-primary">Konversi ke Event</button>
            </div>
        </form>
    </div>
</div>