<?php
/**
 * File utama aplikasi Tugasin
 * 
 * Menangani routing dan tampilan utama aplikasi
 */

// Include file konfigurasi dan fungsi
require_once 'config.php';
require_once 'db_functions.php';
require_once 'functions.php';

// Cek status login
$logged_in = isLoggedIn();
$is_super_admin = isSuperAdmin();
$username = $logged_in ? $_SESSION['username'] : '';

// Jika user sudah login, dapatkan tema
$theme = [];
if ($logged_in) {
    $theme = getUserTheme($db, $username);
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    redirect('index.php');
}

// Handle login
if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    $user = getUserByUsername($db, $username);
    
    if ($user && verifyPassword($password, $user['password'])) {
        // Cek apakah akun sudah kadaluarsa
        if ($user['expires'] !== null && strtotime($user['expires']) < time()) {
            $error = "Akun Anda telah kadaluarsa!";
        } else {
            $_SESSION['logged_in'] = true;
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $user['role'] ?? 'user';
            $_SESSION['nama'] = $user['nama'];
            $_SESSION['nim'] = $user['nim'];
            
            redirect('index.php');
        }
    } else {
        $error = "Username atau password salah!";
    }
}

// Dapatkan tab aktif
$current_tab = getCurrentTab();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tugasin - Aplikasi Manajemen Tugas</title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- CSS Utama -->
    <link rel="stylesheet" href="css/style.css">
    
    <!-- CSS Kustom Tema -->
    <style>
        <?php 
        if ($logged_in && $theme) {
            echo generateThemeColors($theme);
        }
        ?>
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$logged_in): ?>
            <!-- Form Login -->
            <div class="login-container">
                <h2 style="text-align: center; margin-bottom: 20px;">Tugasin - Login</h2>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" id="username" name="username" required autofocus>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    
                    <button type="submit" name="login" class="btn btn-block">Login</button>
                </form>
                
                <div style="margin-top: 15px; text-align: center; font-size: 0.9rem; color: #666;">
                    <p>Untuk informasi login, silahkan hubungi admin.</p>
                </div>
            </div>
        <?php else: ?>
            <!-- Aplikasi Utama -->
            <header>
                <h1>Tugasin</h1>
                <div>
                    <span style="margin-right: 10px; font-size: 0.9rem;">
                        <i class="fas fa-user"></i> <?php echo isset($_SESSION['nama']) ? $_SESSION['nama'] : $username; ?>
                    </span>
                    <a href="?logout=1" class="logout-btn"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
            </header>
            
            <!-- Desktop Navigation Tabs -->
            <div class="desktop-tabs">
                <div class="desktop-tab <?php echo isActiveTab('diskusi'); ?>" data-tab="diskusi">Diskusi</div>
                <div class="desktop-tab <?php echo isActiveTab('tugas'); ?>" data-tab="tugas">Tugas</div>
                <div class="desktop-tab <?php echo isActiveTab('baca'); ?>" data-tab="baca">Baca</div>
                <div class="desktop-tab <?php echo isActiveTab('statistik'); ?>" data-tab="statistik">Statistik</div>
                <div class="desktop-tab <?php echo isActiveTab('pengaturan'); ?>" data-tab="pengaturan">Pengaturan</div>
            </div>
            
            <!-- Mobile Navigation -->
            <nav class="mobile-nav">
                <div class="mobile-tabs">
                    <div class="mobile-tab <?php echo isActiveTab('diskusi'); ?>" data-tab="diskusi">
                        <i class="fas fa-comments"></i>
                        <span>Diskusi</span>
                    </div>
                    <div class="mobile-tab <?php echo isActiveTab('tugas'); ?>" data-tab="tugas">
                        <i class="fas fa-tasks"></i>
                        <span>Tugas</span>
                    </div>
                    <div class="mobile-tab <?php echo isActiveTab('baca'); ?>" data-tab="baca">
                        <i class="fas fa-book"></i>
                        <span>Baca</span>
                    </div>
                    <div class="mobile-tab <?php echo isActiveTab('statistik'); ?>" data-tab="statistik">
                        <i class="fas fa-chart-bar"></i>
                        <span>Statistik</span>
                    </div>
                    <div class="mobile-tab <?php echo isActiveTab('pengaturan'); ?>" data-tab="pengaturan">
                        <i class="fas fa-cog"></i>
                        <span>Pengaturan</span>
                    </div>
                </div>
            </nav>
            
            <!-- Statistik Awal untuk Semua Tab -->
            <div class="stats-card" id="stats-card">
                <?php
                // Ambil statistik pengguna
                $stats = getUserStats($db, $username);
                ?>
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <div class="stat-value"><?php echo $stats['diskusi_aktif']; ?></div>
                    <div class="stat-label">Diskusi Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-tasks"></i>
                    </div>
                    <div class="stat-value"><?php echo $stats['tugas_aktif']; ?></div>
                    <div class="stat-label">Tugas Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-book"></i>
                    </div>
                    <div class="stat-value"><?php echo $stats['baca_aktif']; ?></div>
                    <div class="stat-label">Baca Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="stat-value"><?php echo $stats['total_selesai']; ?></div>
                    <div class="stat-label">Total Selesai</div>
                </div>
            </div>
            
            <!-- Content Container -->
            <div id="page-content">
                <?php
                // Include konten berdasarkan tab
                $tab_file = $current_tab . '.php';
                if (file_exists($tab_file)) {
                    require_once $tab_file;
                } else {
                    // Tab tidak ditemukan, tampilkan halaman 404
                    echo '<div class="card">
                        <div class="card-body">
                            <h3>Halaman Tidak Ditemukan</h3>
                            <p>Halaman yang Anda cari tidak tersedia. Silakan kembali ke halaman utama.</p>
                            <a href="index.php" class="btn">Kembali ke Beranda</a>
                        </div>
                    </div>';
                }
                ?>
            </div>
            
            <!-- Floating Action Button -->
            <div class="fab-button" id="fab-button">
                <i class="fas fa-plus"></i>
            </div>
        <?php endif; ?>
    </div>

    <!-- Toast Container -->
    <div class="toast-container"></div>
    
    <!-- JavaScript -->
    <script src="js/script.js"></script>
    
    <?php if ($logged_in): ?>
    <script>
        // Update visibility stats di mobile
        function checkStatsVisibility() {
            const statsCard = document.getElementById('stats-card');
            if (statsCard) {
                if (window.innerWidth <= 768) {
                    // Di mobile, tampilkan stats hanya di tab statistik
                    if ('<?php echo $current_tab; ?>' === 'statistik') {
                        statsCard.style.display = 'flex';
                    } else {
                        statsCard.style.display = 'none';
                    }
                } else {
                    // Di desktop, selalu tampilkan
                    statsCard.style.display = 'flex';
                }
            }
        }

        // Check stats visibility on load and resize
        document.addEventListener('DOMContentLoaded', checkStatsVisibility);
        window.addEventListener('resize', checkStatsVisibility);
        
        // Update FAB visibility
        function updateFabVisibility() {
            const fab = document.getElementById('fab-button');
            if (fab) {
                // Tampilkan hanya di diskusi, tugas, dan baca
                const currentTab = '<?php echo $current_tab; ?>';
                if (currentTab === 'diskusi' || currentTab === 'tugas' || currentTab === 'baca') {
                    fab.style.display = 'flex';
                } else {
                    fab.style.display = 'none';
                }
            }
        }
        
        // Update FAB visibility on load
        document.addEventListener('DOMContentLoaded', updateFabVisibility);
    </script>
    <?php endif; ?>
</body>
</html>