<?php
/**
 * Halaman diskusi
 * 
 * Menampilkan dan mengelola diskusi pengguna
 */

// Cek jika user belum login
if (!isLoggedIn()) {
    redirect('index.php');
}

// Username pengguna saat ini
$username = $_SESSION['username'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tambah diskusi baru
    if (isset($_POST['add_diskusi'])) {
        $nomor = sanitize($_POST['nomor_diskusi']);
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_diskusi']) ? $_POST['tanggal_dibuat_diskusi'] : date('Y-m-d');
        $deadline = !empty($_POST['deadline_diskusi']) ? $_POST['deadline_diskusi'] : null;
        
        if (addDiskusi($db, $username, $nomor, $tanggalDibuat, $deadline)) {
            echo '<script>showToast("Diskusi berhasil ditambahkan", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menambahkan diskusi", "error");</script>';
        }
    }
    
    // Update diskusi
    else if (isset($_POST['update_diskusi'])) {
        $diskusiId = intval($_POST['diskusi_id']);
        $nomor = sanitize($_POST['nomor_diskusi']);
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_diskusi']) ? $_POST['tanggal_dibuat_diskusi'] : date('Y-m-d');
        $deadline = !empty($_POST['deadline_diskusi']) ? $_POST['deadline_diskusi'] : null;
        
        if (updateDiskusi($db, $diskusiId, $nomor, $tanggalDibuat, $deadline)) {
            echo '<script>showToast("Diskusi berhasil diupdate", "success");</script>';
        } else {
            echo '<script>showToast("Gagal mengupdate diskusi", "error");</script>';
        }
    }
    
    // Tandai selesai
    else if (isset($_POST['complete_diskusi'])) {
        $diskusiId = intval($_POST['diskusi_id']);
        $mapelId = intval($_POST['mapel_id']);
        
        if (completeDiskusiMapel($db, $diskusiId, $mapelId)) {
            echo '<script>showToast("Mata pelajaran ditandai selesai", "success");</script>';
            
            // Cek apakah semua mata pelajaran sudah selesai
            if (isDiskusiComplete($db, $diskusiId)) {
                if (archiveDiskusi($db, $diskusiId)) {
                    echo '<script>showToast("Semua mata pelajaran selesai! Diskusi dipindahkan ke arsip.", "success");</script>';
                }
            }
        } else {
            echo '<script>showToast("Gagal menandai mata pelajaran", "error");</script>';
        }
    }
}

// Handle actions
if (isset($_GET['action'])) {
    // Hapus diskusi
    if ($_GET['action'] === 'delete_diskusi' && isset($_GET['id'])) {
        $diskusiId = intval($_GET['id']);
        
        if (deleteDiskusi($db, $diskusiId)) {
            echo '<script>showToast("Diskusi berhasil dihapus", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menghapus diskusi", "error");</script>';
        }
    }
}

// Ambil data diskusi pengguna
$diskusi_list = getUserDiskusi($db, $username);

// Ambil data mata pelajaran
$mapel_list = getUserMapelNames($db, $username);
?>

<!-- Diskusi Tab -->
<div class="tab-content active" id="diskusi-content">
    <!-- Search box -->
    <div class="search-box">
        <input type="text" id="search-diskusi" data-target="diskusi-list" placeholder="Cari diskusi...">
    </div>
    
    <div id="diskusi-list">
        <?php if (empty($diskusi_list)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada diskusi yang aktif.</p>
                    <button class="btn" onclick="openModal('add-diskusi-modal')">
                        <i class="fas fa-plus"></i> Tambah Diskusi Baru
                    </button>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($diskusi_list as $diskusi): ?>
                <div class="card diskusi-card">
                    <div class="card-header">
                        <h3><?php echo $diskusi['nomor']; ?></h3>
                        <div class="card-actions">
                            <button class="btn btn-sm" onclick="openModal('edit-diskusi-modal-<?php echo $diskusi['id']; ?>')">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm" onclick="openModal('diskusi-modal-<?php echo $diskusi['id']; ?>')">
                                <i class="fas fa-check"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" data-delete="diskusi" data-id="<?php echo $diskusi['id']; ?>">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="date-info">
                            <p><strong>Tanggal Dibuat:</strong> <?php echo isset($diskusi['tanggal_dibuat']) ? formatDate($diskusi['tanggal_dibuat']) : 'Tidak diatur'; ?></p>
                            <?php if (!empty($diskusi['deadline'])): ?>
                                <p>
                                    <strong>Deadline:</strong> <?php echo formatDate($diskusi['deadline']); ?>
                                    <?php
                                        if (!empty($diskusi['deadline'])) {
                                            $days_left = hitungSisaHari($diskusi['deadline']);
                                            $status = getDeadlineStatus($diskusi['deadline']);
                                            echo '<span class="badge ' . $status['badge_class'] . '">' . $status['badge_text'] . '</span>';
                                        }
                                    ?>
                                </p>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Progress bar -->
                        <div class="progress-container">
                            <small class="progress-count">Progres: <?php echo count($diskusi['selesai']); ?> dari <?php echo $diskusi['total_mapel']; ?> mata pelajaran</small>
                            <div class="progress-bar">
                                <div class="progress" style="width: <?php echo $diskusi['total_mapel'] > 0 ? (count($diskusi['selesai']) / $diskusi['total_mapel'] * 100) : 0; ?>%"></div>
                            </div>
                        </div>
                        
                        <div>
                            <strong>Mata Pelajaran yang sudah selesai:</strong>
                            <div style="margin-top: 5px;">
                                <?php if (empty($diskusi['selesai'])): ?>
                                    <p>Belum ada mata pelajaran yang selesai.</p>
                                <?php else: ?>
                                    <?php foreach ($diskusi['selesai'] as $mapel): ?>
                                        <span class="badge badge-success"><?php echo $mapel['nama_mapel']; ?></span>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Diskusi Completion Modal -->
                <div class="modal" id="diskusi-modal-<?php echo $diskusi['id']; ?>">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Selesaikan <?php echo $diskusi['nomor']; ?></h2>
                            <span class="close" onclick="closeModal('diskusi-modal-<?php echo $diskusi['id']; ?>')">&times;</span>
                        </div>
                        <div>
                            <p>Pilih mata pelajaran yang sudah selesai:</p>
                            <form method="post" action="">
                                <input type="hidden" name="diskusi_id" value="<?php echo $diskusi['id']; ?>">
                                
                                <div class="mapel-list">
                                    <?php 
                                    // Kumpulkan id mapel yang sudah selesai
                                    $selesai_ids = array_map(function($m) { return $m['id']; }, $diskusi['selesai']);
                                    
                                    foreach ($mapel_list as $id => $nama_mapel): 
                                        $is_completed = in_array($id, $selesai_ids);
                                    ?>
                                        <div class="mapel-item">
                                            <label>
                                                <input type="radio" name="mapel_id" value="<?php echo $id; ?>" class="mapel-checkbox" required 
                                                    <?php echo $is_completed ? 'disabled checked' : ''; ?>>
                                                <?php echo $nama_mapel; ?>
                                                <?php if ($is_completed): ?>
                                                    <span class="badge badge-success">Selesai</span>
                                                <?php endif; ?>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('diskusi-modal-<?php echo $diskusi['id']; ?>')" class="btn-danger">Batal</button>
                                    <button type="submit" name="complete_diskusi">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Edit Diskusi Modal -->
                <div class="modal" id="edit-diskusi-modal-<?php echo $diskusi['id']; ?>">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Edit Diskusi</h2>
                            <span class="close" onclick="closeModal('edit-diskusi-modal-<?php echo $diskusi['id']; ?>')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <input type="hidden" name="diskusi_id" value="<?php echo $diskusi['id']; ?>">
                                
                                <div class="form-group">
                                    <label for="nomor_diskusi_<?php echo $diskusi['id']; ?>">Nomor Diskusi</label>
                                    <input type="text" id="nomor_diskusi_<?php echo $diskusi['id']; ?>" name="nomor_diskusi" value="<?php echo $diskusi['nomor']; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="tanggal_dibuat_diskusi_<?php echo $diskusi['id']; ?>">Tanggal Dibuat</label>
                                    <input type="date" id="tanggal_dibuat_diskusi_<?php echo $diskusi['id']; ?>" name="tanggal_dibuat_diskusi" value="<?php echo $diskusi['tanggal_dibuat']; ?>">
                                </div>
                                
                                <div class="form-group">
                                    <label for="deadline_diskusi_<?php echo $diskusi['id']; ?>">Deadline</label>
                                    <input type="date" id="deadline_diskusi_<?php echo $diskusi['id']; ?>" name="deadline_diskusi" value="<?php echo $diskusi['deadline']; ?>">
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('edit-diskusi-modal-<?php echo $diskusi['id']; ?>')" class="btn-danger">Batal</button>
                                    <button type="submit" name="update_diskusi">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Add Diskusi Modal -->
<div class="modal" id="add-diskusi-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Tambah Diskusi Baru</h2>
            <span class="close" onclick="closeModal('add-diskusi-modal')">&times;</span>
        </div>
        <div>
            <form method="post" action="">
                <div class="form-group">
                    <label for="nomor_diskusi">Nomor Diskusi</label>
                    <input type="text" id="nomor_diskusi" name="nomor_diskusi" required placeholder="contoh: Diskusi 1">
                </div>
                
                <div class="form-group">
                    <label for="tanggal_dibuat_diskusi">Tanggal Dibuat</label>
                    <input type="date" id="tanggal_dibuat_diskusi" name="tanggal_dibuat_diskusi" value="<?php echo date('Y-m-d'); ?>">
                </div>
                
                <div class="form-group">
                    <label for="deadline_diskusi">Deadline</label>
                    <input type="date" id="deadline_diskusi" name="deadline_diskusi">
                </div>
                
                <div class="action-buttons">
                    <button type="button" onclick="closeModal('add-diskusi-modal')" class="btn-danger">Batal</button>
                    <button type="submit" name="add_diskusi">Tambah</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inisialisasi dialog konfirmasi hapus
    document.querySelectorAll('[data-delete="diskusi"]').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            confirmDelete('diskusi', id);
        });
    });
});
</script>