<?php
/**
 * Halaman baca
 * 
 * Menampilkan dan mengelola progres membaca buku
 */

// Cek jika user belum login
if (!isLoggedIn()) {
    redirect('index.php');
}

// Username pengguna saat ini
$username = $_SESSION['username'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tambah data baca baru
    if (isset($_POST['add_baca'])) {
        $mapelId = intval($_POST['mapel_id']);
        $jumlahBab = intval($_POST['jumlah_bab']);
        
        if ($jumlahBab < 1) {
            $jumlahBab = 1;
        }
        
        if (addBaca($db, $username, $mapelId, $jumlahBab)) {
            echo '<script>showToast("Data baca berhasil ditambahkan", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menambahkan data baca", "error");</script>';
        }
    }
    
    // Update data baca
    else if (isset($_POST['update_baca'])) {
        $bacaId = intval($_POST['baca_id']);
        $jumlahBab = intval($_POST['jumlah_bab']);
        
        if ($jumlahBab < 1) {
            $jumlahBab = 1;
        }
        
        if (updateBaca($db, $bacaId, $jumlahBab)) {
            echo '<script>showToast("Data baca berhasil diupdate", "success");</script>';
        } else {
            echo '<script>showToast("Gagal mengupdate data baca", "error");</script>';
        }
    }
    
    // Tandai bab selesai
    else if (isset($_POST['complete_bab'])) {
        $bacaId = intval($_POST['baca_id']);
        $babNomor = intval($_POST['bab_nomor']);
        
        if (completeBacaBab($db, $bacaId, $babNomor)) {
            echo '<script>showToast("Bab ' . $babNomor . ' ditandai selesai", "success");</script>';
            
            // Cek apakah semua bab sudah selesai
            if (isBacaComplete($db, $bacaId)) {
                if (archiveBaca($db, $bacaId)) {
                    echo '<script>showToast("Semua bab selesai! Data baca dipindahkan ke arsip.", "success");</script>';
                }
            }
        } else {
            echo '<script>showToast("Gagal menandai bab", "error");</script>';
        }
    }
}

// Handle actions
if (isset($_GET['action'])) {
    // Hapus data baca
    if ($_GET['action'] === 'delete_baca' && isset($_GET['id'])) {
        $bacaId = intval($_GET['id']);
        
        if (deleteBaca($db, $bacaId)) {
            echo '<script>showToast("Data baca berhasil dihapus", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menghapus data baca", "error");</script>';
        }
    }
}

// Ambil data baca pengguna
$baca_list = getUserBaca($db, $username);

// Ambil data mata pelajaran (untuk dropdown tambah baru)
$mapel_list = getUserMapelNames($db, $username);

// Daftar mata pelajaran yang sudah ada di baca
$existing_mapel_ids = [];
foreach ($baca_list as $baca) {
    $existing_mapel_ids[] = $baca['mapel_id'];
}

// Filter mata pelajaran yang belum ada di baca
$available_mapel = [];
foreach ($mapel_list as $id => $nama) {
    if (!in_array($id, $existing_mapel_ids)) {
        $available_mapel[$id] = $nama;
    }
}
?>

<!-- Baca Tab -->
<div class="tab-content active" id="baca-content">
    <!-- Search box -->
    <div class="search-box">
        <input type="text" id="search-baca" data-target="baca-list" placeholder="Cari mata pelajaran...">
    </div>
    
    <div id="baca-list">
        <?php if (empty($baca_list)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada data membaca yang aktif.</p>
                    <?php if (!empty($available_mapel)): ?>
                        <button class="btn" onclick="openModal('add-baca-modal')">
                            <i class="fas fa-plus"></i> Tambah Data Baca
                        </button>
                    <?php else: ?>
                        <p class="alert alert-info">Semua mata pelajaran sudah memiliki data baca atau belum ada mata pelajaran yang tersedia.</p>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($baca_list as $baca): ?>
                <div class="card baca-card" data-id="<?php echo $baca['id']; ?>">
                    <div class="card-header">
                        <h3><?php echo $baca['nama_mapel']; ?></h3>
                        <div class="card-actions">
                            <button class="btn btn-sm" onclick="openModal('edit-baca-modal-<?php echo $baca['id']; ?>')">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" data-delete="baca" data-id="<?php echo $baca['id']; ?>">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Progress bar -->
                        <div class="progress-container">
                            <small class="progress-count">Progres: <?php echo count($baca['bab_selesai']); ?> dari <?php echo $baca['jumlah_bab']; ?> bab</small>
                            <div class="progress-bar">
                                <div class="progress" style="width: <?php echo $baca['jumlah_bab'] > 0 ? (count($baca['bab_selesai']) / $baca['jumlah_bab'] * 100) : 0; ?>%"></div>
                            </div>
                        </div>
                        
                        <div>
                            <strong>Bab yang sudah dibaca:</strong>
                            <div class="chapter-list">
                                <?php for ($i = 1; $i <= $baca['jumlah_bab']; $i++): ?>
                                    <?php $isCompleted = in_array($i, $baca['bab_selesai']); ?>
                                    <div class="chapter-item <?php echo $isCompleted ? 'completed' : ''; ?>" data-baca="<?php echo $baca['id']; ?>" data-bab="<?php echo $i; ?>">
                                        <?php echo $i; ?>
                                    </div>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Edit Baca Modal -->
                <div class="modal" id="edit-baca-modal-<?php echo $baca['id']; ?>">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Edit Data Baca</h2>
                            <span class="close" onclick="closeModal('edit-baca-modal-<?php echo $baca['id']; ?>')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <input type="hidden" name="baca_id" value="<?php echo $baca['id']; ?>">
                                
                                <div class="form-group">
                                    <label>Mata Pelajaran</label>
                                    <input type="text" value="<?php echo $baca['nama_mapel']; ?>" readonly disabled>
                                </div>
                                
                                <div class="form-group">
                                    <label for="jumlah_bab_<?php echo $baca['id']; ?>">Jumlah Bab</label>
                                    <input type="number" id="jumlah_bab_<?php echo $baca['id']; ?>" name="jumlah_bab" value="<?php echo $baca['jumlah_bab']; ?>" min="1" required>
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('edit-baca-modal-<?php echo $baca['id']; ?>')" class="btn-danger">Batal</button>
                                    <button type="submit" name="update_baca">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <?php if (!empty($available_mapel)): ?>
                <div class="card">
                    <div class="card-body">
                        <button class="btn" onclick="openModal('add-baca-modal')">
                            <i class="fas fa-plus"></i> Tambah Data Baca Lainnya
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Add Baca Modal -->
<?php if (!empty($available_mapel)): ?>
<div class="modal" id="add-baca-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Tambah Data Baca</h2>
            <span class="close" onclick="closeModal('add-baca-modal')">&times;</span>
        </div>
        <div>
            <form method="post" action="">
                <div class="form-group">
                    <label for="mapel_id">Mata Pelajaran</label>
                    <select id="mapel_id" name="mapel_id" required>
                        <option value="">- Pilih Mata Pelajaran -</option>
                        <?php foreach ($available_mapel as $id => $nama_mapel): ?>
                            <option value="<?php echo $id; ?>"><?php echo $nama_mapel; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="jumlah_bab">Jumlah Bab</label>
                    <input type="number" id="jumlah_bab" name="jumlah_bab" min="1" value="1" required>
                </div>
                
                <div class="action-buttons">
                    <button type="button" onclick="closeModal('add-baca-modal')" class="btn-danger">Batal</button>
                    <button type="submit" name="add_baca">Tambah</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inisialisasi dialog konfirmasi hapus
    document.querySelectorAll('[data-delete="baca"]').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            confirmDelete('baca', id);
        });
    });
    
    // Inisialisasi chapter items
    document.querySelectorAll('.chapter-item').forEach(function(item) {
        item.addEventListener('click', function() {
            const bacaId = this.getAttribute('data-baca');
            const babNomor = this.getAttribute('data-bab');
            
            // Jika belum selesai, tandai selesai
            if (!this.classList.contains('completed')) {
                markChapterAsRead(bacaId, babNomor);
            }
        });
    });
});
</script>