<?php
/**
 * File untuk menangani permintaan AJAX
 */

// Include file konfigurasi
require_once 'config.php';
require_once 'db_functions.php';
require_once 'functions.php';

// Default response JSON
$response = [
    'success' => false,
    'message' => 'Permintaan tidak valid'
];

// Cek jika user sudah login
if (!isLoggedIn()) {
    $response['message'] = 'Anda harus login terlebih dahulu';
    echo json_encode($response);
    exit();
}

// Username pengguna saat ini
$username = $_SESSION['username'];

// Handle permintaan AJAX berdasarkan action
if (isset($_POST['action'])) {
    $action = $_POST['action'];
    
    // Tandai bab sebagai selesai
    if ($action === 'complete_bab') {
        if (isset($_POST['baca_id']) && isset($_POST['bab_nomor'])) {
            $bacaId = intval($_POST['baca_id']);
            $babNomor = intval($_POST['bab_nomor']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT b.*, m.nama_mapel FROM baca b JOIN mapel m ON b.mapel_id = m.id WHERE b.id = ? AND b.username = ?");
            $stmt->bind_param("is", $bacaId, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $baca = $result->fetch_assoc();
                
                // Cek apakah bab sudah selesai
                $stmt = $db->prepare("SELECT * FROM baca_selesai WHERE baca_id = ? AND bab_nomor = ?");
                $stmt->bind_param("ii", $bacaId, $babNomor);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows === 0 && $babNomor <= $baca['jumlah_bab']) {
                    // Tandai bab sebagai selesai
                    if (completeBacaBab($db, $bacaId, $babNomor)) {
                        // Hitung progres baru
                        $stmt = $db->prepare("SELECT COUNT(*) as count FROM baca_selesai WHERE baca_id = ?");
                        $stmt->bind_param("i", $bacaId);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        $selesaiCount = $result->fetch_assoc()['count'];
                        
                        // Hitung persentase progres
                        $progress = ($selesaiCount / $baca['jumlah_bab']) * 100;
                        
                        $response = [
                            'success' => true,
                            'message' => 'Bab ' . $babNomor . ' dari ' . $baca['nama_mapel'] . ' telah ditandai sebagai selesai',
                            'progress' => $progress,
                            'selesai_count' => $selesaiCount,
                            'total_count' => $baca['jumlah_bab'],
                            'is_complete' => ($selesaiCount >= $baca['jumlah_bab'])
                        ];
                        
                        // Jika semua bab sudah selesai, pindahkan ke arsip
                        if ($selesaiCount >= $baca['jumlah_bab']) {
                            archiveBaca($db, $bacaId);
                        }
                    } else {
                        $response['message'] = 'Gagal menandai bab sebagai selesai';
                    }
                } else {
                    $response['success'] = true;
                    $response['message'] = 'Bab ini sudah ditandai selesai sebelumnya';
                }
            } else {
                $response['message'] = 'Data tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Tandai mata pelajaran sebagai selesai diskusi
    else if ($action === 'complete_diskusi_mapel') {
        if (isset($_POST['diskusi_id']) && isset($_POST['mapel_id'])) {
            $diskusiId = intval($_POST['diskusi_id']);
            $mapelId = intval($_POST['mapel_id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT d.* FROM diskusi d WHERE d.id = ? AND d.username = ?");
            $stmt->bind_param("is", $diskusiId, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $diskusi = $result->fetch_assoc();
                
                // Verifikasi mata pelajaran
                $stmt = $db->prepare("SELECT m.* FROM mapel m WHERE m.id = ? AND m.username = ?");
                $stmt->bind_param("is", $mapelId, $username);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    $mapel = $result->fetch_assoc();
                    
                    // Cek apakah sudah selesai
                    $stmt = $db->prepare("SELECT * FROM diskusi_selesai WHERE diskusi_id = ? AND mapel_id = ?");
                    $stmt->bind_param("ii", $diskusiId, $mapelId);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    
                    if ($result->num_rows === 0) {
                        // Tandai sebagai selesai
                        if (completeDiskusiMapel($db, $diskusiId, $mapelId)) {
                            // Hitung progres baru
                            $stmt = $db->prepare("
                                SELECT 
                                (SELECT COUNT(*) FROM diskusi_selesai WHERE diskusi_id = ?) as selesai_count,
                                (SELECT COUNT(*) FROM mapel WHERE username = ?) as total_mapel
                            ");
                            $stmt->bind_param("is", $diskusiId, $username);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            $row = $result->fetch_assoc();
                            $selesaiCount = $row['selesai_count'];
                            $totalMapel = $row['total_mapel'];
                            
                            // Hitung persentase progres
                            $progress = ($selesaiCount / $totalMapel) * 100;
                            
                            $response = [
                                'success' => true,
                                'message' => 'Mata pelajaran ' . $mapel['nama_mapel'] . ' untuk diskusi ' . $diskusi['nomor'] . ' telah ditandai sebagai selesai',
                                'progress' => $progress,
                                'selesai_count' => $selesaiCount,
                                'total_count' => $totalMapel,
                                'is_complete' => ($selesaiCount >= $totalMapel)
                            ];
                            
                            // Jika semua mata pelajaran sudah selesai, pindahkan ke arsip
                            if ($selesaiCount >= $totalMapel) {
                                archiveDiskusi($db, $diskusiId);
                            }
                        } else {
                            $response['message'] = 'Gagal menandai mata pelajaran sebagai selesai';
                        }
                    } else {
                        $response['success'] = true;
                        $response['message'] = 'Mata pelajaran ini sudah ditandai selesai sebelumnya';
                    }
                } else {
                    $response['message'] = 'Mata pelajaran tidak ditemukan atau Anda tidak memiliki akses';
                }
            } else {
                $response['message'] = 'Diskusi tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Tandai mata pelajaran sebagai selesai tugas
    else if ($action === 'complete_tugas_mapel') {
        if (isset($_POST['tugas_id']) && isset($_POST['mapel_id'])) {
            $tugasId = intval($_POST['tugas_id']);
            $mapelId = intval($_POST['mapel_id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT t.* FROM tugas t WHERE t.id = ? AND t.username = ?");
            $stmt->bind_param("is", $tugasId, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $tugas = $result->fetch_assoc();
                
                // Verifikasi mata pelajaran
                $stmt = $db->prepare("SELECT m.* FROM mapel m WHERE m.id = ? AND m.username = ?");
                $stmt->bind_param("is", $mapelId, $username);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    $mapel = $result->fetch_assoc();
                    
                    // Cek apakah sudah selesai
                    $stmt = $db->prepare("SELECT * FROM tugas_selesai WHERE tugas_id = ? AND mapel_id = ?");
                    $stmt->bind_param("ii", $tugasId, $mapelId);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    
                    if ($result->num_rows === 0) {
                        // Tandai sebagai selesai
                        if (completeTugasMapel($db, $tugasId, $mapelId)) {
                            // Hitung progres baru
                            $stmt = $db->prepare("
                                SELECT 
                                (SELECT COUNT(*) FROM tugas_selesai WHERE tugas_id = ?) as selesai_count,
                                (SELECT COUNT(*) FROM mapel WHERE username = ?) as total_mapel
                            ");
                            $stmt->bind_param("is", $tugasId, $username);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            $row = $result->fetch_assoc();
                            $selesaiCount = $row['selesai_count'];
                            $totalMapel = $row['total_mapel'];
                            
                            // Hitung persentase progres
                            $progress = ($selesaiCount / $totalMapel) * 100;
                            
                            $response = [
                                'success' => true,
                                'message' => 'Mata pelajaran ' . $mapel['nama_mapel'] . ' untuk tugas ' . $tugas['nomor'] . ' telah ditandai sebagai selesai',
                                'progress' => $progress,
                                'selesai_count' => $selesaiCount,
                                'total_count' => $totalMapel,
                                'is_complete' => ($selesaiCount >= $totalMapel)
                            ];
                            
                            // Jika semua mata pelajaran sudah selesai, pindahkan ke arsip
                            if ($selesaiCount >= $totalMapel) {
                                archiveTugas($db, $tugasId);
                            }
                        } else {
                            $response['message'] = 'Gagal menandai mata pelajaran sebagai selesai';
                        }
                    } else {
                        $response['success'] = true;
                        $response['message'] = 'Mata pelajaran ini sudah ditandai selesai sebelumnya';
                    }
                } else {
                    $response['message'] = 'Mata pelajaran tidak ditemukan atau Anda tidak memiliki akses';
                }
            } else {
                $response['message'] = 'Tugas tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Hapus diskusi
    else if ($action === 'delete_diskusi') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT * FROM diskusi WHERE id = ? AND username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $diskusi = $result->fetch_assoc();
                
                if (deleteDiskusi($db, $id)) {
                    $response = [
                        'success' => true,
                        'message' => 'Diskusi ' . $diskusi['nomor'] . ' berhasil dihapus'
                    ];
                } else {
                    $response['message'] = 'Gagal menghapus diskusi';
                }
            } else {
                $response['message'] = 'Diskusi tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Hapus tugas
    else if ($action === 'delete_tugas') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT * FROM tugas WHERE id = ? AND username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $tugas = $result->fetch_assoc();
                
                if (deleteTugas($db, $id)) {
                    $response = [
                        'success' => true,
                        'message' => 'Tugas ' . $tugas['nomor'] . ' berhasil dihapus'
                    ];
                } else {
                    $response['message'] = 'Gagal menghapus tugas';
                }
            } else {
                $response['message'] = 'Tugas tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Hapus baca
    else if ($action === 'delete_baca') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT b.*, m.nama_mapel FROM baca b JOIN mapel m ON b.mapel_id = m.id WHERE b.id = ? AND b.username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $baca = $result->fetch_assoc();
                
                if (deleteBaca($db, $id)) {
                    $response = [
                        'success' => true,
                        'message' => 'Data baca ' . $baca['nama_mapel'] . ' berhasil dihapus'
                    ];
                } else {
                    $response['message'] = 'Gagal menghapus data baca';
                }
            } else {
                $response['message'] = 'Data baca tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Update tema pengguna
    else if ($action === 'update_theme') {
        if (isset($_POST['theme'])) {
            $theme = $_POST['theme'];
            
            // Validasi tema
            $stmt = $db->prepare("SELECT * FROM themes WHERE id = ?");
            $stmt->bind_param("s", $theme);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0 || $theme === 'custom') {
                if (updateUserTheme($db, $username, $theme)) {
                    $response = [
                        'success' => true,
                        'message' => 'Tema berhasil diubah',
                        'reload' => true
                    ];
                } else {
                    $response['message'] = 'Gagal mengubah tema';
                }
            } else {
                $response['message'] = 'Tema tidak valid';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Tambah tema kustom
    else if ($action === 'add_custom_theme') {
        if (isset($_POST['name']) && isset($_POST['colors'])) {
            $themeName = $_POST['name'];
            $colors = json_decode($_POST['colors'], true);
            
            if ($colors) {
                // Buat ID unik
                $themeId = 'custom_' . strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $themeName)) . '_' . substr(md5(uniqid()), 0, 6);
                
                if (addCustomTheme($db, $themeId, $themeName, $colors)) {
                    // Set tema pengguna ke tema baru
                    updateUserTheme($db, $username, $themeId);
                    
                    $response = [
                        'success' => true,
                        'message' => 'Tema kustom berhasil ditambahkan',
                        'theme_id' => $themeId,
                        'reload' => true
                    ];
                } else {
                    $response['message'] = 'Gagal menambahkan tema kustom';
                }
            } else {
                $response['message'] = 'Format warna tidak valid';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Mendapatkan data diskusi
    else if ($action === 'get_diskusi') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT * FROM diskusi WHERE id = ? AND username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $diskusi = $result->fetch_assoc();
                $diskusi['selesai'] = getDiskusiSelesai($db, $id);
                
                $response = [
                    'success' => true,
                    'data' => $diskusi
                ];
            } else {
                $response['message'] = 'Diskusi tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Mendapatkan data tugas
    else if ($action === 'get_tugas') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT * FROM tugas WHERE id = ? AND username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $tugas = $result->fetch_assoc();
                $tugas['selesai'] = getTugasSelesai($db, $id);
                
                $response = [
                    'success' => true,
                    'data' => $tugas
                ];
            } else {
                $response['message'] = 'Tugas tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Mendapatkan data baca
    else if ($action === 'get_baca') {
        if (isset($_POST['id'])) {
            $id = intval($_POST['id']);
            
            // Verifikasi kepemilikan data
            $stmt = $db->prepare("SELECT b.*, m.nama_mapel FROM baca b JOIN mapel m ON b.mapel_id = m.id WHERE b.id = ? AND b.username = ?");
            $stmt->bind_param("is", $id, $username);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $baca = $result->fetch_assoc();
                $baca['bab_selesai'] = getBacaSelesai($db, $id);
                
                $response = [
                    'success' => true,
                    'data' => $baca
                ];
            } else {
                $response['message'] = 'Data baca tidak ditemukan atau Anda tidak memiliki akses';
            }
        } else {
            $response['message'] = 'Parameter tidak lengkap';
        }
    }
    
    // Mendapatkan statistik pengguna
    else if ($action === 'get_stats') {
        $stats = getUserStats($db, $username);
        
        $response = [
            'success' => true,
            'data' => $stats
        ];
    }
}

// Kembalikan response dalam format JSON
header('Content-Type: application/json');
echo json_encode($response);