// Subject Completion Popup
function createSubjectCompletionPopup() {
    // Create the popup container
    const popupContainer = document.createElement('div');
    popupContainer.id = 'subjectCompletionPopup';
    popupContainer.className = 'modal-container';
    
    // Create the popup content
    const popupContent = document.createElement('div');
    popupContent.className = 'modal-content subject-completion-modal';
    
    // Create the header
    const header = document.createElement('div');
    header.className = 'modal-header';
    
    const title = document.createElement('h3');
    title.textContent = 'Pilih Mapel yang Sudah Selesai';
    
    const closeBtn = document.createElement('span');
    closeBtn.className = 'close-modal';
    closeBtn.innerHTML = '&times;';
    closeBtn.onclick = function() {
        popupContainer.style.display = 'none';
    };
    
    header.appendChild(title);
    header.appendChild(closeBtn);
    
    // Create the body
    const body = document.createElement('div');
    body.className = 'modal-body';
    body.id = 'subjectCompletionBody';
    
    // Create the footer
    const footer = document.createElement('div');
    footer.className = 'modal-footer';
    
    const saveBtn = document.createElement('button');
    saveBtn.className = 'btn btn-primary';
    saveBtn.textContent = 'Simpan';
    saveBtn.id = 'saveSubjectCompletion';
    
    const cancelBtn = document.createElement('button');
    cancelBtn.className = 'btn btn-outline';
    cancelBtn.textContent = 'Batal';
    cancelBtn.onclick = function() {
        popupContainer.style.display = 'none';
    };
    
    footer.appendChild(cancelBtn);
    footer.appendChild(saveBtn);
    
    // Assemble the popup
    popupContent.appendChild(header);
    popupContent.appendChild(body);
    popupContent.appendChild(footer);
    popupContainer.appendChild(popupContent);
    
    // Add the popup to the document
    document.body.appendChild(popupContainer);
    
    // Add styles for the popup
    const style = document.createElement('style');
    style.textContent = `
        .subject-completion-modal {
            max-width: 500px;
        }
        
        .subject-checkbox-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 15px;
        }
        
        .subject-checkbox-item {
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 6px;
            background-color: rgba(67, 97, 238, 0.05);
            transition: all 0.2s;
        }
        
        .subject-checkbox-item:hover {
            background-color: rgba(67, 97, 238, 0.1);
        }
        
        .subject-checkbox-item input[type="checkbox"] {
            margin-right: 10px;
            width: 18px;
            height: 18px;
            cursor: pointer;
        }
        
        .subject-checkbox-item label {
            flex: 1;
            cursor: pointer;
            font-size: 14px;
            color: var(--text-color);
        }
        
        .subject-completion-note {
            margin-top: 15px;
            padding: 10px;
            border-radius: 6px;
            background-color: rgba(255, 193, 7, 0.1);
            color: var(--warning-color);
            font-size: 13px;
            display: flex;
            align-items: center;
        }
        
        .subject-completion-note i {
            margin-right: 8px;
            font-size: 14px;
        }
    `;
    document.head.appendChild(style);
    
    return popupContainer;
}

// Show the subject completion popup for a specific task
function showSubjectCompletionPopup(taskId, category) {
    // Get or create the popup
    let popup = document.getElementById('subjectCompletionPopup');
    if (!popup) {
        popup = createSubjectCompletionPopup();
    }
    
    // Get the task data
    fetch(`index.php?get_task_data=true&task_id=${taskId}&category=${category}`)
        .then(response => response.json())
        .then(task => {
            const popupBody = document.getElementById('subjectCompletionBody');
            popupBody.innerHTML = '';
            
            if (task && task.subjects) {
                // Create checkbox list container
                const checkboxList = document.createElement('div');
                checkboxList.className = 'subject-checkbox-list';
                
                // Add checkboxes for each subject
                Object.entries(task.subjects).forEach(([subjectKey, subject]) => {
                    const checkboxItem = document.createElement('div');
                    checkboxItem.className = 'subject-checkbox-item';
                    
                    const checkbox = document.createElement('input');
                    checkbox.type = 'checkbox';
                    checkbox.id = `subject_${subjectKey}`;
                    checkbox.name = `subjects[${subjectKey}]`;
                    checkbox.checked = subject.completed;
                    checkbox.value = '1';
                    
                    const label = document.createElement('label');
                    label.htmlFor = `subject_${subjectKey}`;
                    label.textContent = subject.name;
                    
                    checkboxItem.appendChild(checkbox);
                    checkboxItem.appendChild(label);
                    checkboxList.appendChild(checkboxItem);
                });
                
                popupBody.appendChild(checkboxList);
                
                // Add note about task completion
                const note = document.createElement('div');
                note.className = 'subject-completion-note';
                note.innerHTML = '<i class="fas fa-info-circle"></i> Tugas akan dianggap selesai jika semua mapel telah ditandai selesai.';
                popupBody.appendChild(note);
                
                // Set up the save button
                const saveBtn = document.getElementById('saveSubjectCompletion');
                saveBtn.onclick = function() {
                    // Collect the checked subjects
                    const checkedSubjects = {};
                    Object.keys(task.subjects).forEach(subjectKey => {
                        const checkbox = document.getElementById(`subject_${subjectKey}`);
                        checkedSubjects[subjectKey] = checkbox.checked;
                    });
                    
                    // Send the data to the server
                    const formData = new FormData();
                    formData.append('update_subjects', 'true');
                    formData.append('task_id', taskId);
                    formData.append('category', category);
                    formData.append('subjects', JSON.stringify(checkedSubjects));
                    
                    fetch('index.php', {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.text())
                    .then(html => {
                        // Hide the popup
                        popup.style.display = 'none';
                        
                        // Reload the current page content
                        loadContent(window.location.href);
                    })
                    .catch(error => {
                        console.error('Error updating subjects:', error);
                        alert('Terjadi kesalahan saat menyimpan perubahan.');
                    });
                };
            }
            
            // Show the popup
            popup.style.display = 'flex';
        })
        .catch(error => {
            console.error('Error fetching task data:', error);
            alert('Terjadi kesalahan saat memuat data tugas.');
        });
}
