// Personalized Greeting Popup
function createGreetingPopup() {
    // Create the popup container
    const popupContainer = document.createElement('div');
    popupContainer.id = 'greetingPopup';
    popupContainer.className = 'modal-container';
    
    // Create the popup content
    const popupContent = document.createElement('div');
    popupContent.className = 'modal-content greeting-popup';
    
    // Create the header
    const header = document.createElement('div');
    header.className = 'modal-header';
    
    const title = document.createElement('h3');
    title.id = 'greetingTitle';
    title.innerHTML = '<i class="fas fa-smile"></i> Selamat Datang Kembali!';
    
    const closeBtn = document.createElement('span');
    closeBtn.className = 'close-modal';
    closeBtn.innerHTML = '&times;';
    closeBtn.onclick = function() {
        popupContainer.style.display = 'none';
    };
    
    header.appendChild(title);
    header.appendChild(closeBtn);
    
    // Create the body
    const body = document.createElement('div');
    body.className = 'modal-body';
    body.id = 'greetingBody';
    
    // Create the footer
    const footer = document.createElement('div');
    footer.className = 'modal-footer';
    
    const okBtn = document.createElement('button');
    okBtn.className = 'btn btn-primary';
    okBtn.textContent = 'Mulai Bekerja';
    okBtn.onclick = function() {
        popupContainer.style.display = 'none';
    };
    
    footer.appendChild(okBtn);
    
    // Assemble the popup
    popupContent.appendChild(header);
    popupContent.appendChild(body);
    popupContent.appendChild(footer);
    popupContainer.appendChild(popupContent);
    
    // Add the popup to the document
    document.body.appendChild(popupContainer);
    
    // Add styles for the popup
    const style = document.createElement('style');
    style.textContent = `
        .greeting-popup {
            max-width: 500px;
        }
        
        .greeting-user {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        
        .greeting-date {
            font-size: 14px;
            color: #666;
            margin-bottom: 20px;
        }
        
        .greeting-tasks {
            margin-top: 15px;
        }
        
        .greeting-task-category {
            margin-bottom: 15px;
        }
        
        .greeting-task-category h4 {
            display: flex;
            align-items: center;
            font-size: 15px;
            margin-bottom: 8px;
            color: var(--dark-color);
        }
        
        .greeting-task-category h4 i {
            margin-right: 8px;
            color: var(--primary-color);
        }
        
        .greeting-task-count {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background-color: var(--primary-color);
            color: white;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            font-size: 12px;
            margin-left: 8px;
        }
        
        .greeting-task-count.warning {
            background-color: var(--warning-color);
        }
        
        .greeting-task-count.danger {
            background-color: var(--danger-color);
        }
        
        .greeting-no-tasks {
            color: #888;
            font-style: italic;
            margin-top: 10px;
        }
    `;
    document.head.appendChild(style);
    
    return popupContainer;
}

// Show the greeting popup with task information
function showGreetingPopup(username, taskCounts) {
    // Check if we should show the popup (max 2 times per day)
    if (!shouldShowGreeting()) {
        return;
    }
    
    // Get or create the popup
    let popup = document.getElementById('greetingPopup');
    if (!popup) {
        popup = createGreetingPopup();
    }
    
    // Get the current time
    const now = new Date();
    const hours = now.getHours();
    
    // Set greeting based on time of day
    let greeting = 'Selamat Datang';
    if (hours >= 5 && hours < 12) {
        greeting = 'Selamat Pagi';
    } else if (hours >= 12 && hours < 17) {
        greeting = 'Selamat Siang';
    } else if (hours >= 17 && hours < 20) {
        greeting = 'Selamat Sore';
    } else {
        greeting = 'Selamat Malam';
    }
    
    // Format the date
    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const dateStr = now.toLocaleDateString('id-ID', options);
    
    // Update the popup content
    const greetingBody = document.getElementById('greetingBody');
    
    // Create user greeting
    const userGreeting = document.createElement('div');
    userGreeting.className = 'greeting-user';
    userGreeting.textContent = `${greeting}, ${username}!`;
    
    // Create date display
    const dateDisplay = document.createElement('div');
    dateDisplay.className = 'greeting-date';
    dateDisplay.textContent = dateStr;
    
    // Create tasks summary
    const tasksSummary = document.createElement('div');
    tasksSummary.className = 'greeting-tasks';
    
    // Add task counts by category
    let hasTasks = false;
    
    // Work tasks
    if (taskCounts.work > 0) {
        hasTasks = true;
        const workCategory = document.createElement('div');
        workCategory.className = 'greeting-task-category';
        
        const workTitle = document.createElement('h4');
        workTitle.innerHTML = '<i class="fas fa-briefcase"></i> Tugas Pekerjaan';
        
        const workCount = document.createElement('span');
        workCount.className = 'greeting-task-count';
        workCount.textContent = taskCounts.work;
        
        if (taskCounts.work > 5) {
            workCount.classList.add('warning');
        }
        
        workTitle.appendChild(workCount);
        workCategory.appendChild(workTitle);
        tasksSummary.appendChild(workCategory);
    }
    
    // College tasks
    if (taskCounts.college > 0) {
        hasTasks = true;
        const collegeCategory = document.createElement('div');
        collegeCategory.className = 'greeting-task-category';
        
        const collegeTitle = document.createElement('h4');
        collegeTitle.innerHTML = '<i class="fas fa-graduation-cap"></i> Tugas Kuliah';
        
        const collegeCount = document.createElement('span');
        collegeCount.className = 'greeting-task-count';
        collegeCount.textContent = taskCounts.college;
        
        if (taskCounts.college > 5) {
            collegeCount.classList.add('warning');
        }
        
        collegeTitle.appendChild(collegeCount);
        collegeCategory.appendChild(collegeTitle);
        tasksSummary.appendChild(collegeCategory);
    }
    
    // Personal tasks
    if (taskCounts.personal > 0) {
        hasTasks = true;
        const personalCategory = document.createElement('div');
        personalCategory.className = 'greeting-task-category';
        
        const personalTitle = document.createElement('h4');
        personalTitle.innerHTML = '<i class="fas fa-user"></i> Tugas Pribadi';
        
        const personalCount = document.createElement('span');
        personalCount.className = 'greeting-task-count';
        personalCount.textContent = taskCounts.personal;
        
        if (taskCounts.personal > 5) {
            personalCount.classList.add('warning');
        }
        
        personalTitle.appendChild(personalCount);
        personalCategory.appendChild(personalTitle);
        tasksSummary.appendChild(personalCategory);
    }
    
    // If no tasks, show a message
    if (!hasTasks) {
        const noTasks = document.createElement('div');
        noTasks.className = 'greeting-no-tasks';
        noTasks.textContent = 'Tidak ada tugas untuk hari ini. Selamat beristirahat!';
        tasksSummary.appendChild(noTasks);
    }
    
    // Clear previous content and add new content
    greetingBody.innerHTML = '';
    greetingBody.appendChild(userGreeting);
    greetingBody.appendChild(dateDisplay);
    greetingBody.appendChild(document.createElement('hr'));
    greetingBody.appendChild(tasksSummary);
    
    // Show the popup
    popup.style.display = 'flex';
    
    // Update the greeting count in cookie
    updateGreetingCount();
}

// Check if we should show the greeting (max 2 times per day)
function shouldShowGreeting() {
    const today = new Date().toLocaleDateString();
    const greetingCookie = getCookie('greeting_shown');
    
    if (!greetingCookie) {
        return true;
    }
    
    try {
        const greetingData = JSON.parse(greetingCookie);
        if (greetingData.date !== today) {
            return true;
        }
        
        return greetingData.count < 2;
    } catch (e) {
        return true;
    }
}

// Update the greeting count in cookie
function updateGreetingCount() {
    const today = new Date().toLocaleDateString();
    const greetingCookie = getCookie('greeting_shown');
    
    let count = 1;
    if (greetingCookie) {
        try {
            const greetingData = JSON.parse(greetingCookie);
            if (greetingData.date === today) {
                count = greetingData.count + 1;
            }
        } catch (e) {
            count = 1;
        }
    }
    
    const greetingData = {
        date: today,
        count: count
    };
    
    setCookie('greeting_shown', JSON.stringify(greetingData), 1);
}

// Get cookie by name
function getCookie(name) {
    const cookies = document.cookie.split(';');
    for (let i = 0; i < cookies.length; i++) {
        const cookie = cookies[i].trim();
        if (cookie.startsWith(name + '=')) {
            return cookie.substring(name.length + 1);
        }
    }
    return null;
}

// Set cookie
function setCookie(name, value, days) {
    const date = new Date();
    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
    const expires = "expires=" + date.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}
