<?php
session_start();

// Pengaturan login
$validUsername = "rizaldi";
$validPassword = "admin123";

// Cek login
$isLoggedIn = false;
$loginError = "";

if (isset($_POST['login'])) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === $validUsername && $password === $validPassword) {
        $_SESSION['user'] = $username;
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $loginError = "Username atau password salah!";
    }
}

if (isset($_SESSION['user'])) {
    $isLoggedIn = true;
}

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Inisialisasi file JSON jika belum ada
$jsonFile = 'templates.json';
if (!file_exists($jsonFile)) {
    $defaultTemplates = [
        [
            'id' => 1,
            'name' => 'Salam Pembuka',
            'template' => 'Halo {nama}, selamat {waktu}! Bagaimana kabar Anda hari ini?',
            'tags' => ['nama', 'waktu']
        ],
        [
            'id' => 2,
            'name' => 'Undangan',
            'template' => 'Kepada {nama} yang terhormat, Anda diundang ke acara {acara} pada tanggal {tanggal} di {tempat}.',
            'tags' => ['nama', 'acara', 'tanggal', 'tempat']
        ]
    ];
    file_put_contents($jsonFile, json_encode($defaultTemplates, JSON_PRETTY_PRINT));
}

// Inisialisasi variabel
$templates = json_decode(file_contents($jsonFile), true);
$message = '';
$messageType = 'success';
$activeTemplate = null;
$generatedText = '';
$searchQuery = '';

// Handle pencarian
if (isset($_GET['search'])) {
    $searchQuery = $_GET['search'];
}

// Handle penyimpanan template baru
if ($isLoggedIn && isset($_POST['save_template'])) {
    $templateName = $_POST['template_name'];
    $templateText = $_POST['template_text'];
    
    // Ekstrak tag dari template
    preg_match_all('/\{([^{}]+)\}/', $templateText, $matches);
    $tags = $matches[1];
    
    // Jika ID sudah ada, edit template tersebut
    if (isset($_POST['template_id']) && !empty($_POST['template_id'])) {
        $editId = $_POST['template_id'];
        foreach ($templates as $key => $template) {
            if ($template['id'] == $editId) {
                $templates[$key]['name'] = $templateName;
                $templates[$key]['template'] = $templateText;
                $templates[$key]['tags'] = $tags;
                break;
            }
        }
        $message = "Template berhasil diperbarui!";
    } else {
        // Buat ID baru
        $newId = 1;
        if (!empty($templates)) {
            $ids = array_column($templates, 'id');
            $newId = max($ids) + 1;
        }
        
        // Buat template baru
        $newTemplate = [
            'id' => $newId,
            'name' => $templateName,
            'template' => $templateText,
            'tags' => $tags
        ];
        
        $templates[] = $newTemplate;
        $message = "Template berhasil disimpan!";
    }
    
    file_put_contents($jsonFile, json_encode($templates, JSON_PRETTY_PRINT));
}

// Handle penghapusan template
if ($isLoggedIn && isset($_GET['delete'])) {
    $idToDelete = $_GET['delete'];
    foreach ($templates as $key => $template) {
        if ($template['id'] == $idToDelete) {
            unset($templates[$key]);
            break;
        }
    }
    $templates = array_values($templates); // Reindex array
    file_put_contents($jsonFile, json_encode($templates, JSON_PRETTY_PRINT));
    $message = "Template berhasil dihapus!";
    header("Location: " . $_SERVER['PHP_SELF'] . "?tab=manage");
    exit;
}

// Handle edit template
if ($isLoggedIn && isset($_GET['edit'])) {
    $editId = $_GET['edit'];
    foreach ($templates as $template) {
        if ($template['id'] == $editId) {
            $editTemplate = $template;
            break;
        }
    }
}

// Handle pemilihan template
if (isset($_GET['template_id'])) {
    $templateId = $_GET['template_id'];
    foreach ($templates as $template) {
        if ($template['id'] == $templateId) {
            $activeTemplate = $template;
            break;
        }
    }
}

// Handle generasi teks
if (isset($_POST['generate'])) {
    $templateId = $_POST['template_id'];
    $text = '';
    
    foreach ($templates as $template) {
        if ($template['id'] == $templateId) {
            $text = $template['template'];
            break;
        }
    }
    
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'tag_') === 0) {
            $tagName = substr($key, 4);
            $text = str_replace("{{$tagName}}", $value, $text);
        }
    }
    
    $generatedText = $text;
    
    // Tidak mengosongkan activeTemplate agar form tetap ditampilkan dengan nilai yang sama
    if (isset($_GET['template_id'])) {
        $templateId = $_GET['template_id'];
        foreach ($templates as $template) {
            if ($template['id'] == $templateId) {
                $activeTemplate = $template;
                break;
            }
        }
    }
}

// Filter template berdasarkan pencarian
$filteredTemplates = $templates;
if (!empty($searchQuery)) {
    $filteredTemplates = array_filter($templates, function($template) use ($searchQuery) {
        return (stripos($template['name'], $searchQuery) !== false || 
                stripos($template['template'], $searchQuery) !== false);
    });
}

// Tentukan tab aktif
$activeTab = $_GET['tab'] ?? 'manage';

function file_contents($filename) {
    if (file_exists($filename)) {
        return file_get_contents($filename);
    }
    return '[]';
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TextCraft - Pembuat Teks Custom</title>
    <link rel="icon" type="image/png" href="https://app.dezki.biz.id/linkpic/assets/uploads/680253e1b676c.png" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4caf50;
            --danger-color: #f44336;
            --warning-color: #ff9800;
            --info-color: #2196f3;
            --dark-color: #333;
            --light-color: #f4f4f4;
            --grey-color: #ddd;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f8fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }
        
        .logo {
            display: flex;
            align-items: center;
            font-weight: bold;
            font-size: 24px;
            color: var(--primary-color);
        }
        
        .logo i {
            margin-right: 10px;
            font-size: 28px;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 15px 0;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .user-info {
            display: flex;
            align-items: center;
        }
        
        .user-info i {
            margin-right: 8px;
            color: var(--primary-color);
        }
        
        .logout-btn {
            margin-left: 15px;
            color: var(--danger-color);
            text-decoration: none;
            display: flex;
            align-items: center;
        }
        
        .logout-btn i {
            margin-right: 5px;
        }
        
        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 20px;
            overflow: hidden;
        }
        
        .card-header {
            padding: 15px 20px;
            background: var(--primary-color);
            color: white;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h2 {
            font-size: 18px;
            margin: 0;
        }
        
        .card-body {
            padding: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: var(--dark-color);
        }
        
        input[type="text"], 
        input[type="password"], 
        input[type="search"], 
        textarea, 
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            transition: border 0.3s;
        }
        
        input[type="text"]:focus, 
        input[type="password"]:focus, 
        input[type="search"]:focus, 
        textarea:focus, 
        select:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.3);
        }
        
        textarea {
            height: 150px;
            resize: vertical;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 15px;
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s;
            text-decoration: none;
            margin-right: 10px;
        }
        
        .btn i {
            margin-right: 8px;
        }
        
        .btn:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: var(--success-color);
        }
        
        .btn-danger {
            background: var(--danger-color);
        }
        
        .btn-warning {
            background: var(--warning-color);
        }
        
        .btn-info {
            background: var(--info-color);
        }
        
        .tab-navigation {
            display: flex;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 20px;
        }
        
        .tab-link {
            flex: 1;
            padding: 15px;
            text-align: center;
            text-decoration: none;
            color: var(--dark-color);
            border-bottom: 3px solid transparent;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .tab-link i {
            margin-right: 8px;
        }
        
        .tab-link.active {
            border-bottom-color: var(--primary-color);
            color: var(--primary-color);
            font-weight: bold;
        }
        
        .tab-link:hover {
            background: #f9f9f9;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .search-container {
            position: relative;
            margin-bottom: 20px;
        }
        
        .search-container input {
            padding-left: 40px;
        }
        
        .search-container i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th, table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid var(--grey-color);
        }
        
        table th {
            background: #f4f4f4;
            font-weight: bold;
        }
        
        table tr:hover {
            background: #f9f9f9;
        }
        
        .action-buttons {
            display: flex;
        }
        
        .action-buttons .btn {
            padding: 8px 10px;
            font-size: 14px;
            margin-right: 5px;
        }
        
        .preview-box {
            padding: 15px;
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .result-box {
            padding: 20px;
            background: #f0f7ff;
            border: 1px solid #cce5ff;
            border-radius: 5px;
            margin-top: 20px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .login-form {
            max-width: 400px;
            margin: 80px auto;
        }
        
        @media (max-width: 768px) {
            .header-container {
                flex-direction: column;
                text-align: center;
            }
            
            .logo {
                margin-bottom: 10px;
                justify-content: center;
            }
            
            .user-info {
                margin-top: 10px;
                justify-content: center;
            }
            
            .tab-navigation {
                flex-direction: column;
            }
            
            .tab-link {
                border-left: 3px solid transparent;
                border-bottom: none;
                text-align: left;
            }
            
            .tab-link.active {
                border-left-color: var(--primary-color);
                border-bottom: none;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .action-buttons .btn {
                margin-bottom: 5px;
                width: 100%;
                margin-right: 0;
            }
            
            table {
                display: block;
                overflow-x: auto;
            }
        }
        
        /* Animasi Loading */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            visibility: hidden;
            opacity: 0;
            transition: opacity 0.3s, visibility 0.3s;
        }
        
        .loading-overlay.show {
            visibility: visible;
            opacity: 1;
        }
        
        .loader {
            border: 5px solid #f3f3f3;
            border-top: 5px solid var(--primary-color);
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Tag style */
        .tag {
            display: inline-block;
            background: #e9f5ff;
            border: 1px solid #b0d7ff;
            border-radius: 15px;
            padding: 5px 10px;
            margin-right: 5px;
            margin-bottom: 5px;
            font-size: 14px;
            color: var(--primary-color);
        }
    </style>
</head>
<body>
    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="loader"></div>
    </div>

    <?php if (!$isLoggedIn): ?>
        <!-- Login Form -->
        <div class="container">
            <div class="login-form">
                <div class="card">
                    <div class="card-header">
                        <h2><i class="fas fa-text-height"></i> TextCraft - Login</h2>
                    </div>
                    <div class="card-body">
                        <?php if (!empty($loginError)): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-circle"></i> <?php echo $loginError; ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="form-group">
                                <label for="username"><i class="fas fa-user"></i> Username</label>
                                <input type="text" name="username" id="username" required placeholder="Masukkan username">
                            </div>
                            
                            <div class="form-group">
                                <label for="password"><i class="fas fa-lock"></i> Password</label>
                                <input type="password" name="password" id="password" required placeholder="Masukkan password">
                            </div>
                            
                            <button type="submit" name="login" class="btn"><i class="fas fa-sign-in-alt"></i> Login</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Main Application -->
        <header>
            <div class="container header-container">
                <div class="logo">
                    <i class="fas fa-text-height"></i> TextCraft
                </div>
                <div class="user-info">
                    <i class="fas fa-user-circle"></i> <?php echo $_SESSION['user']; ?>
                    <a href="?logout=1" class="logout-btn"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
            </div>
        </header>
        
        <div class="container" style="padding-top: 20px;">
            <?php if (!empty($message)): ?>
                <div class="alert alert-<?php echo $messageType; ?>">
                    <i class="fas fa-info-circle"></i> <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <div class="tab-navigation">
                <a href="?tab=manage" class="tab-link <?php echo $activeTab === 'manage' ? 'active' : ''; ?>">
                    <i class="fas fa-list"></i> Kelola Template
                </a>
                <a href="?tab=create" class="tab-link <?php echo $activeTab === 'create' ? 'active' : ''; ?>">
                    <i class="fas fa-plus"></i> Tambah Template
                </a>
                <a href="?tab=generate" class="tab-link <?php echo $activeTab === 'generate' ? 'active' : ''; ?>">
                    <i class="fas fa-magic"></i> Buat Teks
                </a>
            </div>
            
            <!-- Tab Kelola Template -->
            <div class="tab-content <?php echo $activeTab === 'manage' ? 'active' : ''; ?>">
                <div class="card">
                    <div class="card-header">
                        <h2><i class="fas fa-list"></i> Kelola Template</h2>
                    </div>
                    <div class="card-body">
                        <div class="search-container">
                            <i class="fas fa-search"></i>
                            <form method="GET" action="">
                                <input type="hidden" name="tab" value="manage">
                                <input type="search" name="search" id="search" placeholder="Cari template..." value="<?php echo htmlspecialchars($searchQuery); ?>">
                            </form>
                        </div>
                        
                        <?php if (empty($filteredTemplates)): ?>
                            <p>Belum ada template tersimpan<?php echo !empty($searchQuery) ? ' yang sesuai dengan pencarian' : ''; ?>.</p>
                        <?php else: ?>
                            <div style="overflow-x: auto;">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Nama Template</th>
                                            <th>Teks Template</th>
                                            <th>Tag</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($filteredTemplates as $template): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($template['name']); ?></td>
                                                <td><?php echo htmlspecialchars(substr($template['template'], 0, 50) . (strlen($template['template']) > 50 ? '...' : '')); ?></td>
                                                <td>
                                                    <?php foreach ($template['tags'] as $tag): ?>
                                                        <span class="tag"><?php echo htmlspecialchars($tag); ?></span>
                                                    <?php endforeach; ?>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <a href="?tab=generate&template_id=<?php echo $template['id']; ?>" class="btn btn-info">
                                                            <i class="fas fa-magic"></i> Gunakan
                                                        </a>
                                                        <a href="?tab=create&edit=<?php echo $template['id']; ?>" class="btn btn-warning">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </a>
                                                        <a href="?delete=<?php echo $template['id']; ?>" class="btn btn-danger" onclick="showLoading(); return confirm('Yakin ingin menghapus template ini?')">
                                                            <i class="fas fa-trash"></i> Hapus
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Tab Tambah/Edit Template -->
            <div class="tab-content <?php echo $activeTab === 'create' ? 'active' : ''; ?>">
                <div class="card">
                    <div class="card-header">
                        <h2>
                            <i class="fas fa-<?php echo isset($editTemplate) ? 'edit' : 'plus'; ?>"></i>
                            <?php echo isset($editTemplate) ? 'Edit Template' : 'Tambah Template Baru'; ?>
                        </h2>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="?tab=manage" onsubmit="showLoading()">
                            <?php if (isset($editTemplate)): ?>
                                <input type="hidden" name="template_id" value="<?php echo $editTemplate['id']; ?>">
                            <?php endif; ?>
                            
                            <div class="form-group">
                                <label for="template_name"><i class="fas fa-tag"></i> Nama Template</label>
                                <input type="text" name="template_name" id="template_name" required placeholder="Masukkan nama template" 
                                       value="<?php echo isset($editTemplate) ? htmlspecialchars($editTemplate['name']) : ''; ?>">
                            </div>
                            
                            <div class="form-group">
                                <label for="template_text"><i class="fas fa-file-alt"></i> Teks Template</label>
                                <textarea name="template_text" id="template_text" required 
                                          placeholder="Masukkan teks template dengan tag dalam format {namaTag}. Contoh: Halo {nama}, selamat {waktu}!"><?php echo isset($editTemplate) ? htmlspecialchars($editTemplate['template']) : ''; ?></textarea>
                            </div>
                            
                            <?php if (isset($editTemplate)): ?>
                                <div class="form-group">
                                    <label><i class="fas fa-tags"></i> Tag Terdeteksi</label>
                                    <div class="preview-box">
                                        <?php if (empty($editTemplate['tags'])): ?>
                                            <p>Tidak ada tag yang terdeteksi.</p>
                                        <?php else: ?>
                                            <?php foreach ($editTemplate['tags'] as $tag): ?>
                                                <span class="tag"><?php echo htmlspecialchars($tag); ?></span>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <button type="submit" name="save_template" class="btn btn-success">
                                <i class="fas fa-save"></i> <?php echo isset($editTemplate) ? 'Perbarui Template' : 'Simpan Template'; ?>
                            </button>
                            
                            <a href="?tab=manage" class="btn">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </form>
                    </div>
                </div>
            </div>
            
            <!-- Tab Buat Teks -->
            <div class="tab-content <?php echo $activeTab === 'generate' ? 'active' : ''; ?>">
                <div class="card">
                    <div class="card-header">
                        <h2><i class="fas fa-magic"></i> Buat Teks</h2>
                    </div>
                    <div class="card-body">
                        <form method="GET" onsubmit="showLoading()">
                            <input type="hidden" name="tab" value="generate">
                            
                            <div class="form-group">
                                <label for="template_id"><i class="fas fa-list-alt"></i> Pilih Template</label>
                                <select name="template_id" id="template_id" onchange="this.form.submit()">
                                    <option value="">-- Pilih Template --</option>
                                    <?php foreach ($templates as $template): ?>
                                        <option value="<?php echo $template['id']; ?>" <?php echo isset($_GET['template_id']) && $_GET['template_id'] == $template['id'] ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($template['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </form>
                        
                        <?php if ($activeTemplate): ?>
                            <form method="POST" action="?tab=generate&template_id=<?php echo $activeTemplate['id']; ?>" onsubmit="showLoading()">
                                <input type="hidden" name="template_id" value="<?php echo $activeTemplate['id']; ?>">
                                
                                <div class="form-group">
                                    <label><i class="fas fa-file-alt"></i> Template</label>
                                    <div class="preview-box">
                                        <?php echo nl2br(htmlspecialchars($activeTemplate['template'])); ?>
                                    </div>
                                </div>
                                
                                <?php foreach ($activeTemplate['tags'] as $tag): ?>
                                    <div class="form-group">
                                        <label for="tag_<?php echo $tag; ?>"><i class="fas fa-tag"></i> <?php echo ucfirst($tag); ?></label>
                                        <input type="text" name="tag_<?php echo $tag; ?>" id="tag_<?php echo $tag; ?>" 
                                               placeholder="Masukkan <?php echo $tag; ?>"
                                               value="<?php echo isset($_POST['tag_'.$tag]) ? htmlspecialchars($_POST['tag_'.$tag]) : ''; ?>">
                                    </div>
                                <?php endforeach; ?>
                                
                                <button type="submit" name="generate" class="btn btn-success">
                                    <i class="fas fa-magic"></i> Hasilkan Teks
                                </button>
                            </form>
                        <?php elseif (isset($_GET['template_id'])): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-circle"></i> Template tidak ditemukan.
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($generatedText)): ?>
                            <div class="result-box">
                                <h3><i class="fas fa-clipboard-check"></i> Hasil Teks:</h3>
                                <div id="result-text" style="margin: 15px 0;"><?php echo nl2br(htmlspecialchars($generatedText)); ?></div>
                                <button type="button" class="btn btn-info" onclick="copyToClipboard()">
                                    <i class="fas fa-copy"></i> Salin Teks
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <script>
        // Fungsi untuk menampilkan loading overlay
        function showLoading() {
            document.getElementById('loadingOverlay').classList.add('show');
        }
        
        // Fungsi untuk menyembunyikan loading overlay
        function hideLoading() {
            document.getElementById('loadingOverlay').classList.remove('show');
        }
        
        // Sembunyikan loading saat halaman dimuat
        window.addEventListener('load', function() {
            hideLoading();
        });
        
        // Tampilkan loading saat navigasi halaman
        document.querySelectorAll('a[href]:not([href^="#"])').forEach(function(link) {
            link.addEventListener('click', function() {
                // Jangan tampilkan loading jika link meminta konfirmasi dan dibatalkan
                if (!this.hasAttribute('onclick') || (this.hasAttribute('onclick') && confirm('Yakin ingin menghapus template ini?'))) {
                    showLoading();
                }
            });
        });
        
        // Fungsi untuk menyalin teks ke clipboard
        function copyToClipboard() {
            var resultText = document.getElementById("result-text").innerText;
            
            // Buat elemen textarea sementara
            var tempTextArea = document.createElement("textarea");
            tempTextArea.value = resultText;
            tempTextArea.style.position = "fixed";
            tempTextArea.style.left = "-999999px";
            tempTextArea.style.top = "-999999px";
            document.body.appendChild(tempTextArea);
            
            // Pilih dan salin teks
            tempTextArea.focus();
            tempTextArea.select();
            
            try {
                var successful = document.execCommand('copy');
                
                // Tampilkan pesan berhasil disalin
                if (successful) {
                    showToast("Teks berhasil disalin!");
                } else {
                    showToast("Gagal menyalin teks", true);
                }
            } catch (err) {
                showToast("Error: " + err, true);
            }
            
            // Hapus elemen sementara
            document.body.removeChild(tempTextArea);
        }
        
        // Fungsi untuk menampilkan pesan toast
        function showToast(message, isError = false) {
            // Hapus toast sebelumnya jika ada
            var existingToast = document.querySelector('.toast-notification');
            if (existingToast) {
                existingToast.remove();
            }
            
            // Buat elemen toast
            var toast = document.createElement('div');
            toast.className = 'toast-notification ' + (isError ? 'toast-error' : 'toast-success');
            toast.style.position = 'fixed';
            toast.style.bottom = '20px';
            toast.style.right = '20px';
            toast.style.padding = '12px 20px';
            toast.style.background = isError ? '#f44336' : '#4CAF50';
            toast.style.color = 'white';
            toast.style.borderRadius = '5px';
            toast.style.boxShadow = '0 2px 10px rgba(0,0,0,0.2)';
            toast.style.zIndex = '9999';
            toast.style.transition = 'opacity 0.3s';
            toast.style.opacity = '0';
            toast.style.display = 'flex';
            toast.style.alignItems = 'center';
            
            // Ikon
            var icon = document.createElement('i');
            icon.className = 'fas ' + (isError ? 'fa-exclamation-circle' : 'fa-check-circle');
            icon.style.marginRight = '10px';
            toast.appendChild(icon);
            
            // Teks pesan
            var text = document.createElement('span');
            text.textContent = message;
            toast.appendChild(text);
            
            // Tambahkan ke dokumen
            document.body.appendChild(toast);
            
            // Animasi tampil
            setTimeout(function() {
                toast.style.opacity = '1';
            }, 10);
            
            // Hilangkan setelah 3 detik
            setTimeout(function() {
                toast.style.opacity = '0';
                setTimeout(function() {
                    if (toast.parentNode) {
                        toast.parentNode.removeChild(toast);
                    }
                }, 300);
            }, 3000);
        }
        
        // Validasi input form
        document.addEventListener('DOMContentLoaded', function() {
            // Form validasi untuk template
            var templateForm = document.querySelector('form[name="save_template"]');
            if (templateForm) {
                templateForm.addEventListener('submit', function(e) {
                    var templateName = document.getElementById('template_name').value.trim();
                    var templateText = document.getElementById('template_text').value.trim();
                    
                    if (templateName === '') {
                        e.preventDefault();
                        showToast('Nama template tidak boleh kosong!', true);
                        return false;
                    }
                    
                    if (templateText === '') {
                        e.preventDefault();
                        showToast('Teks template tidak boleh kosong!', true);
                        return false;
                    }
                    
                    // Cek apakah ada tag dalam template
                    var tagRegex = /\{([^{}]+)\}/g;
                    if (!tagRegex.test(templateText)) {
                        if (!confirm('Template tidak mengandung tag. Lanjutkan menyimpan?')) {
                            e.preventDefault();
                            return false;
                        }
                    }
                    
                    return true;
                });
            }
        });
    </script>
</body>
</html>