# Reminder App - PHP Version

Aplikasi pengingat tugas yang telah dikonversi dari HTML ke PHP dengan integrasi data.json dan verifikasi login PIN.

## Fitur

- **Login dengan PIN**: Verifikasi akses menggunakan PIN 051205
- **Manajemen Tugas**: Tambah, edit, hapus, dan tandai tugas sebagai selesai
- **Kategori**: Organisasi tugas berdasarkan kategori (Personal, Pekerjaan, Belanja)
- **Sub Tugas**: Dukungan untuk sub tugas dalam setiap tugas utama
- **Prioritas**: Tingkat prioritas (Tinggi, Sedang, Rendah)
- **Pencarian**: Fitur pencarian tugas berdasarkan judul dan deskripsi
- **Filter & Sort**: Filter berdasarkan prioritas dan sorting berdasarkan tanggal/prioritas
- **Responsive Design**: Tampilan yang responsif untuk desktop dan mobile

## Struktur File

```
reminder-app-php/
├── index.php          # Halaman utama aplikasi
├── login.php          # Halaman login dengan verifikasi PIN
├── logout.php         # Script logout
├── api.php            # API endpoints untuk operasi data
├── data.json          # File penyimpanan data (kategori dan tugas)
└── README.md          # Dokumentasi ini
```

## Instalasi & Menjalankan

1. **Persyaratan**:
   - PHP 7.4 atau lebih tinggi
   - Web server (Apache/Nginx) atau PHP built-in server

2. **Menjalankan dengan PHP built-in server**:
   ```bash
   cd reminder-app-php
   php -S localhost:8000
   ```

3. **Akses aplikasi**:
   - Buka browser dan kunjungi `http://localhost:8000`
   - Masukkan PIN: `051205`

## Penggunaan

### Login
- Masukkan PIN `051205` untuk mengakses aplikasi
- Sistem akan menggunakan PHP session untuk menjaga status login

### Manajemen Tugas
- **Tambah Tugas**: Klik tombol "+" di pojok kanan bawah
- **Edit Tugas**: Klik ikon edit pada tugas yang ingin diubah
- **Hapus Tugas**: Klik ikon hapus (konfirmasi diperlukan)
- **Tandai Selesai**: Klik checkbox di sebelah kiri tugas

### Kategori
- **Tambah Kategori**: Klik tombol "+" di header
- **Filter by Kategori**: Klik kategori di sidebar kiri

### Fitur Lainnya
- **Pencarian**: Klik ikon search atau tekan Ctrl+K
- **Filter Prioritas**: Gunakan dropdown filter prioritas
- **Sorting**: Klik tombol "Tanggal" atau "Prioritas"

## API Endpoints

### GET /api.php?action=data
Mengambil semua data (kategori dan tugas)

### POST /api.php?action=add_task
Menambah tugas baru
```json
{
  "title": "Judul tugas",
  "description": "Deskripsi opsional",
  "category": "cat_personal",
  "priority": "medium",
  "due_date": "2025-01-27T15:00:00",
  "subtasks": [
    {
      "id": "subtask_1",
      "title": "Sub tugas 1",
      "completed": false
    }
  ]
}
```

### POST /api.php?action=update_task
Mengupdate tugas yang ada

### POST /api.php?action=toggle_task
Mengubah status selesai/belum selesai tugas

### POST /api.php?action=toggle_subtask
Mengubah status selesai/belum selesai sub tugas

### DELETE /api.php?action=delete_task&id={task_id}
Menghapus tugas

### POST /api.php?action=add_category
Menambah kategori baru

### DELETE /api.php?action=delete_category&id={category_id}
Menghapus kategori

## Keamanan

- **Session Management**: Menggunakan PHP session untuk autentikasi
- **Input Validation**: Validasi input di sisi client dan server
- **CSRF Protection**: Semua operasi memerlukan session yang valid
- **Data Sanitization**: Escape HTML untuk mencegah XSS

## Penyimpanan Data

Data disimpan dalam file `data.json` dengan struktur:

```json
{
  "categories": [
    {
      "id": "cat_personal",
      "name": "Personal",
      "icon": "👤",
      "color": "#3b82f6"
    }
  ],
  "tasks": [
    {
      "id": "task_1",
      "title": "Contoh tugas",
      "description": "Deskripsi tugas",
      "category": "cat_personal",
      "priority": "medium",
      "completed": false,
      "created_at": "2025-01-27T10:00:00",
      "due_date": null,
      "subtasks": []
    }
  ]
}
```

## Troubleshooting

### Error "Permission denied" saat menyimpan data
Pastikan file `data.json` memiliki permission write:
```bash
chmod 666 data.json
```

### Session tidak tersimpan
Pastikan direktori session PHP dapat ditulis:
```bash
# Cek lokasi session
php -i | grep session.save_path
```

### Port sudah digunakan
Gunakan port lain:
```bash
php -S localhost:8001
```

## Konversi dari HTML

Aplikasi ini telah dikonversi dari versi HTML murni dengan perubahan berikut:

1. **Backend Logic**: Ditambahkan PHP untuk handling server-side operations
2. **Data Persistence**: Data sekarang disimpan dalam file JSON di server
3. **Authentication**: Sistem login dengan PIN menggunakan PHP session
4. **API Integration**: Frontend berkomunikasi dengan backend melalui API endpoints
5. **Security**: Ditambahkan validasi dan sanitasi data di server

## Lisensi

Aplikasi ini dibuat untuk keperluan demonstrasi dan pembelajaran.

