<?php
// index.php - Aplikasi Pengelolaan Keuangan Cita Cerdas (Versi Satu File)

session_start();

// Konfigurasi
define('DATA_FILE', 'data/finance.json');
define('PIN_CODE', '051205');

// Fungsi bantu
function load_data() {
    if (!file_exists(DATA_FILE)) {
        $initial_data = [
            'transactions' => [],
            'budgets' => [
                'yearly' => ['income_target' => 0, 'expense_limit' => 0],
                'monthly' => []
            ],
            'planned_purchases' => []
        ];
        file_put_contents(DATA_FILE, json_encode($initial_data));
    }
    return json_decode(file_get_contents(DATA_FILE), true);
}

function save_data($data) {
    file_put_contents(DATA_FILE, json_encode($data, JSON_PRETTY_PRINT));
}

function check_pin() {
    if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
        header('Location: ?page=login');
        exit;
    }
}

function generate_chart_data($transactions) {
    $months = [];
    $income_data = [];
    $expense_data = [];

    for ($i = 1; $i <= 12; $i++) {
        $month_name = date('F', mktime(0, 0, 0, $i, 10));
        $months[] = substr($month_name, 0, 3);
        
        $month_income = 0;
        $month_expense = 0;
        
        foreach ($transactions as $transaction) {
            $date = new DateTime($transaction['date']);
            if ($date->format('n') == $i && $transaction['type'] == 'income') {
                $month_income += $transaction['amount'];
            } elseif ($date->format('n') == $i && $transaction['type'] == 'expense') {
                $month_expense += $transaction['amount'];
            }
        }
        
        $income_data[] = $month_income;
        $expense_data[] = $month_expense;
    }

    return [
        'labels' => $months,
        'income' => $income_data,
        'expense' => $expense_data
    ];
}

// Routing
$page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';

// Proses login
if ($page === 'login') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $pin = $_POST['pin'] ?? '';
        if ($pin === PIN_CODE) {
            $_SESSION['authenticated'] = true;
            header('Location: ?page=dashboard');
            exit;
        } else {
            $error = "PIN salah!";
        }
    }
    
    echo '<!DOCTYPE html><html lang="id"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Login</title><style>body{font-family:Arial,sans-serif;background:#fff;color:#333;margin:0;padding:20px;}form{max-width:300px;margin:50px auto;text-align:center;}input{padding:8px;width:80%;margin:10px 0;border:1px solid #ddd;border-radius:4px;}button{background:#006064;color:white;padding:10px 20px;border:none;border-radius:4px;cursor:pointer;}</style></head><body>';
    echo '<div class="login-container">';
    echo '<h2>Masukkan PIN</h2>';
    if (isset($error)) echo "<p style='color:red;'>{$error}</p>";
    echo '<form method="post"><input type="password" name="pin" placeholder="PIN" required><br><button type="submit">Login</button></form>';
    echo '</div></body></html>';
    exit;
}

// Cek autentikasi
check_pin();

// Load data
$data = load_data();
$transactions = $data['transactions'];
$current_year = date('Y');
$current_month = date('m');

// Proses transaksi
if ($page === 'add_transaction' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $type = $_POST['type'];
    $category = $_POST['category'];
    $amount = floatval($_POST['amount']);
    $description = $_POST['description'];
    $date = $_POST['date'];
    
    $new_transaction = [
        'id' => count($transactions) + 1,
        'type' => $type,
        'category' => $category,
        'amount' => $amount,
        'description' => $description,
        'date' => $date
    ];
    
    $transactions[] = $new_transaction;
    $data['transactions'] = $transactions;
    save_data($data);
    
    header('Location: ?page=transactions');
    exit;
}

// Proses anggaran
if ($page === 'update_budget' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $budget_type = $_POST['budget_type'];
    $year = $_POST['year'];
    $month = $_POST['month'];
    $income_target = floatval($_POST['income_target']);
    $expense_limit = floatval($_POST['expense_limit']);
    
    if ($budget_type === 'yearly') {
        $data['budgets']['yearly'] = ['income_target' => $income_target, 'expense_limit' => $expense_limit];
    } else {
        $data['budgets']['monthly'][$month] = ['income_target' => $income_target, 'expense_limit' => $expense_limit];
    }
    
    save_data($data);
    header('Location: ?page=budget');
    exit;
}

// Proses pembelian terencana
if ($page === 'add_planned_purchase' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $item = $_POST['item'];
    $estimated_cost = floatval($_POST['estimated_cost']);
    $plan_date = $_POST['plan_date'];
    $status = $_POST['status'];
    
    $new_purchase = [
        'id' => count($data['planned_purchases']) + 1,
        'item' => $item,
        'estimated_cost' => $estimated_cost,
        'plan_date' => $plan_date,
        'status' => $status
    ];
    
    $data['planned_purchases'][] = $new_purchase;
    save_data($data);
    
    header('Location: ?page=planned_purchases');
    exit;
}

// Generate chart data
$chart_data = generate_chart_data($transactions);

// Output HTML
echo '<!DOCTYPE html><html lang="id"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Pengelolaan Keuangan Cita Cerdas</title><style>.container{max-width:1200px;margin:0 auto;padding:20px;}.header{display:flex;justify-content:space-between;align-items:center;padding-bottom:20px;border-bottom:1px solid #e0e0e0;}.nav ul{list-style:none;padding:0;display:flex;gap:15px;}.nav a{text-decoration:none;color:#006064;font-weight:bold;}.card{background:#fff;border-radius:8px;box-shadow:0 2px 4px rgba(0,0,0,0.1);padding:20px;margin-bottom:20px;}.summary-cards{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;}.form-group{margin-bottom:15px;}.form-group label{display:block;margin-bottom:5px;font-weight:bold;}.form-group input,.form-group select,.form-group textarea{width:100%;padding:8px;border:1px solid #e0e0e0;border-radius:4px;}.btn{background:#006064;color:#fff;border:none;padding:10px 20px;border-radius:4px;cursor:pointer;}.table{width:100%;border-collapse:collapse;margin-top:20px;}.table th,.table td{border:1px solid #e0e0e0;padding:10px;text-align:left;}.table th{background:#006064;color:#fff;}</style></head><body>';

echo '<div class="container"><div class="header"><h1>Cita Cerdas</h1><nav class="nav"><ul>';
echo '<li><a href="?page=dashboard">Dashboard</a></li>';
echo '<li><a href="?page=budget">Anggaran</a></li>';
echo '<li><a href="?page=transactions">Transaksi</a></li>';
echo '<li><a href="?page=planned_purchases">Pembelian Terencana</a></li>';
echo '<li><a href="?page=reports">Laporan</a></li>';
echo '<li><a href="?page=logout">Logout</a></li>';
echo '</ul></nav></div>';

switch ($page) {
    case 'dashboard':
        echo '<section class="summary-cards">';
        echo '<div class="card"><h3>Total Pemasukan</h3><p>Rp '.number_format(array_sum(array_filter($transactions, fn($t) => $t['type'] === 'income')), 2).'</p></div>';
        echo '<div class="card"><h3>Total Pengeluaran</h3><p>Rp '.number_format(array_sum(array_filter($transactions, fn($t) => $t['type'] === 'expense')), 2).'</p></div>';
        echo '<div class="card"><h3>Saldo Akhir</h3><p>Rp '.number_format(
            array_sum(array_filter($transactions, fn($t) => $t['type'] === 'income')) -
            array_sum(array_filter($transactions, fn($t) => $t['type'] === 'expense')),
            2
        ).'</p></div>';
        echo '</section>';
        
        echo '<section class="chart-section"><h2>Grafik Bulanan</h2><canvas id="financialChart"></canvas>';
        echo '<script>document.addEventListener("DOMContentLoaded",function(){const ctx=document.getElementById("financialChart").getContext("2d");const chart=new Chart(ctx,{type:"bar",data:{labels:'.json_encode($chart_data['labels']).',datasets:[{label:"Pemasukan",data:'.json_encode($chart_data['income']).',backgroundColor:"#f9c74f"},{label:"Pengeluaran",data:'.json_encode($chart_data['expense']).',backgroundColor:"#e76f51"}]},options:{responsive:!0,scales:{y:{beginAtZero:!0,ticks:{callback:function(value){return"Rp "+value.toLocaleString();}}}}}});});</script>';
        break;

    case 'budget':
        echo '<h2>Manajemen Anggaran</h2>';
        
        echo '<form method="post" action="?page=update_budget">';
        echo '<h3>Tahunan</h3>';
        echo '<div class="form-group"><label>Target Pemasukan:</label><input type="number" name="income_target" step="0.01" value="'.$data['budgets']['yearly']['income_target'].'"></div>';
        echo '<div class="form-group"><label>Batas Pengeluaran:</label><input type="number" name="expense_limit" step="0.01" value="'.$data['budgets']['yearly']['expense_limit'].'"></div>';
        echo '<input type="hidden" name="budget_type" value="yearly"><button class="btn" type="submit">Simpan Tahunan</button></form>';
        
        echo '<h3>Bulanan</h3>';
        echo '<table class="table"><thead><tr><th>Bulan</th><th>Target Pemasukan</th><th>Batas Pengeluaran</th><th>Aksi</th></tr></thead><tbody>';
        for ($i = 1; $i <= 12; $i++) {
            $month_name = date('F', mktime(0, 0, 0, $i, 10));
            echo '<tr><td>'.substr($month_name, 0, 3).'</td>';
            echo '<td><input type="number" name="income_target_'.$i.'" step="0.01" value="'.($data['budgets']['monthly'][$i]['income_target'] ?? 0).'"></td>';
            echo '<td><input type="number" name="expense_limit_'.$i.'" step="0.01" value="'.($data['budgets']['monthly'][$i]['expense_limit'] ?? 0).'"></td>';
            echo '<td><button class="btn" type="submit" formaction="?page=update_budget">Update</button></td></tr>';
        }
        echo '</tbody></table>';
        break;

    case 'transactions':
        echo '<h2>Pencatatan Transaksi</h2>';
        
        echo '<form method="post" action="?page=add_transaction">';
        echo '<div class="form-group"><label>Jenis:</label><select name="type" required><option value="income">Pemasukan</option><option value="expense">Pengeluaran</option></select></div>';
        echo '<div class="form-group"><label>Kategori:</label><select name="category" required>';
        if ($_POST['type'] ?? '' === 'income') {
            echo '<option value="registration">Pendaftaran Lomba</option>';
            echo '<option value="ebook_sales">Penjualan E-book</option>';
            echo '<option value="award_claim">Klaim Paket Penghargaan</option>';
            echo '<option value="pulsa_business">Bisnis Pulsa</option>';
        } else {
            echo '<option value="operational_event">Operasional Event</option>';
            echo '<option value="team_salary">Gaji Tim & Honor</option>';
            echo '<option value="routine_needs">Kebutuhan Rutin</option>';
            echo '<option value="asset_purchase">Belanja Barang/Asset</option>';
        }
        echo '</select></div>';
        echo '<div class="form-group"><label>Jumlah:</label><input type="number" name="amount" step="0.01" required></div>';
        echo '<div class="form-group"><label>Keterangan:</label><textarea name="description"></textarea></div>';
        echo '<div class="form-group"><label>Tanggal:</label><input type="date" name="date" required></div>';
        echo '<button class="btn" type="submit">Tambah Transaksi</button></form>';
        
        echo '<h3>Daftar Transaksi</h3>';
        echo '<table class="table"><thead><tr><th>Tanggal</th><th>Jenis</th><th>Kategori</th><th>Jumlah</th><th>Keterangan</th></tr></thead><tbody>';
        foreach ($transactions as $transaction) {
            echo '<tr><td>'.$transaction['date'].'</td><td>'.ucfirst($transaction['type']).'</td><td>'.ucfirst(str_replace('_',' ',$transaction['category'])).'</td><td>Rp '.number_format($transaction['amount'],2).'</td><td>'.$transaction['description'].'</td></tr>';
        }
        echo '</tbody></table>';
        break;

    case 'planned_purchases':
        echo '<h2>Pembelian Terencana</h2>';
        
        echo '<form method="post" action="?page=add_planned_purchase">';
        echo '<div class="form-group"><label>Nama Barang:</label><input type="text" name="item" required></div>';
        echo '<div class="form-group"><label>Estimasi Biaya:</label><input type="number" name="estimated_cost" step="0.01" required></div>';
        echo '<div class="form-group"><label>Tanggal Rencana Pembelian:</label><input type="date" name="plan_date" required></div>';
        echo '<div class="form-group"><label>Status:</label><select name="status" required><option value="planned">Direncanakan</option><option value="purchased">Dibeli</option><option value="delayed">Ditunda</option></select></div>';
        echo '<button class="btn" type="submit">Tambah Pembelian</button></form>';
        
        echo '<h3>Daftar Pembelian Terencana</h3>';
        echo '<table class="table"><thead><tr><th>Nama Barang</th><th>Estimasi Biaya</th><th>Tanggal Rencana</th><th>Status</th></tr></thead><tbody>';
        foreach ($data['planned_purchases'] as $purchase) {
            echo '<tr><td>'.$purchase['item'].'</td><td>Rp '.number_format($purchase['estimated_cost'],2).'</td><td>'.$purchase['plan_date'].'</td><td>'.ucfirst($purchase['status']).'</td></tr>';
        }
        echo '</tbody></table>';
        break;

    case 'reports':
        echo '<h2>Laporan Keuangan</h2>';
        
        echo '<form method="get"><div class="form-group"><label>Tipe Laporan:</label><select name="report_type"><option value="monthly">Bulanan</option><option value="yearly">Tahunan</option></select></div>';
        echo '<div class="form-group"><label>Tahun:</label><input type="number" name="year" value="'.$current_year.'"></div>';
        echo '<div class="form-group"><label>Bulan:</label><input type="number" name="month" min="1" max="12" value="'.$current_month.'"></div>';
        echo '<button class="btn" type="submit">Generate Laporan</button></form>';
        
        if (isset($_GET['report_type'])) {
            echo '<h3>Ringkasan Laporan</h3>';
            echo '<p>Pemasukan Total: Rp '.number_format(array_sum(array_filter($transactions, fn($t) => $t['type'] === 'income')), 2).'</p>';
            echo '<p>Pengeluaran Total: Rp '.number_format(array_sum(array_filter($transactions, fn($t) => $t['type'] === 'expense')), 2).'</p>';
            echo '<p>Keuntungan Bersih: Rp '.number_format(
                array_sum(array_filter($transactions, fn($t) => $t['type'] === 'income')) -
                array_sum(array_filter($transactions, fn($t) => $t['type'] === 'expense')),
                2
            ).'</p>';
            
            echo '<a href="#" class="btn">Unduh sebagai PDF</a>';
            echo '<a href="#" class="btn">Unduh sebagai Excel</a>';
        }
        break;

    case 'logout':
        session_destroy();
        header('Location: ?page=login');
        exit;
}

echo '</div></body></html>';
?>