<?php
// upload.php - Script untuk menangani upload file
session_start();

// Check if logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

// Check if it's a POST request with a file
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    // Get the file details
    $file = $_FILES['image'];
    
    // Check for errors
    if ($file['error'] !== UPLOAD_ERR_OK) {
        $error = 'Upload gagal. Silakan coba lagi.';
        header('Location: dashboard.php?error=' . urlencode($error));
        exit;
    }
    
    // Check if it's an image
    $fileType = exif_imagetype($file['tmp_name']);
    if (!$fileType) {
        $error = 'File yang diupload bukan gambar.';
        header('Location: dashboard.php?error=' . urlencode($error));
        exit;
    }
    
    // Create uploads directory if it doesn't exist
    $uploadsDir = 'assets/uploads/';
    if (!is_dir($uploadsDir)) {
        mkdir($uploadsDir, 0755, true);
    }
    
    // Generate a unique filename
    $filename = $file['name'];
    $extension = pathinfo($filename, PATHINFO_EXTENSION);
    $uniqueName = uniqid() . '.' . $extension;
    $filePath = $uploadsDir . $uniqueName;
    
    // Move the uploaded file
    if (move_uploaded_file($file['tmp_name'], $filePath)) {
        // Create image URL (using current URL structure)
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://';
        $host = $_SERVER['HTTP_HOST'];
        $basePath = rtrim(dirname($_SERVER['PHP_SELF']), '/');
        $url = $protocol . $host . $basePath . '/' . $filePath;
        
        // Load existing images data
        $images = [];
        if (file_exists('images.json')) {
            $images = json_decode(file_get_contents('images.json'), true);
        }
        
        // Add new image data
        $images[] = [
            'filename' => $filename,
            'path' => $filePath,
            'url' => $url,
            'upload_date' => date('Y-m-d H:i:s')
        ];
        
        // Save to JSON file
        file_put_contents('images.json', json_encode($images, JSON_PRETTY_PRINT));
        
        // Redirect with success message
        header('Location: dashboard.php?success=1');
        exit;
    } else {
        $error = 'Gagal menyimpan gambar. Silakan coba lagi.';
        header('Location: dashboard.php?error=' . urlencode($error));
        exit;
    }
} else {
    // Invalid request
    header('Location: dashboard.php');
    exit;
}