// assets/js/script.js
document.addEventListener('DOMContentLoaded', function() {
    // Copy link button functionality
    const copyButtons = document.querySelectorAll('.copy-btn');
    
    copyButtons.forEach(button => {
        button.addEventListener('click', function() {
            const link = this.getAttribute('data-link');
            const tempInput = document.createElement('input');
            
            tempInput.value = link;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            // Change button text temporarily
            const originalText = this.textContent;
            this.textContent = 'Tersalin!';
            
            setTimeout(() => {
                this.textContent = originalText;
            }, 2000);
        });
    });
    
    // Show error or success messages
    const urlParams = new URLSearchParams(window.location.search);
    
    if (urlParams.has('error')) {
        const errorMessage = urlParams.get('error');
        showNotification(errorMessage, 'error');
    }
    
    if (urlParams.has('success')) {
        showNotification('Gambar berhasil diupload!', 'success');
    }
    
    function showNotification(message, type) {
        const notification = document.createElement('div');
        notification.className = `notification ${type}`;
        notification.textContent = message;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.classList.add('show');
        }, 100);
        
        setTimeout(() => {
            notification.classList.remove('show');
            setTimeout(() => {
                document.body.removeChild(notification);
            }, 300);
        }, 3000);
    }
    
    // File input styling
    const fileInput = document.getElementById('image');
    if (fileInput) {
        const fileNameElement = document.querySelector('.file-name');
        
        fileInput.addEventListener('change', function() {
            const fileName = this.value.split('\\').pop();
            if (fileName) {
                fileNameElement.textContent = fileName;
                fileNameElement.classList.add('show');
            } else {
                fileNameElement.classList.remove('show');
            }
        });
    }
});