<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($linkData['title']); ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        .container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin-top: 50px;
        }
        h1 {
            color: #2c3e50;
            margin-bottom: 20px;
            word-wrap: break-word;
        }
        .description {
            font-size: 18px;
            margin-bottom: 20px;
            word-wrap: break-word;
            line-height: 1.8;
        }
        .timestamp {
            color: #7f8c8d;
            font-size: 14px;
            margin-top: 20px;
        }
        @media (max-width: 768px) {
            .container {
                padding: 20px;
                margin-top: 30px;
            }
            h1 {
                font-size: 24px;
            }
            .description {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><?php echo htmlspecialchars($linkData['title']); ?></h1>
        <div class="description"><?php echo nl2br(htmlspecialchars($linkData['description'])); ?></div>
        <div class="timestamp">Dibuat pada: <?php echo htmlspecialchars($linkData['created_at']); ?></div>
    </div>
</body>
</html>