<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Halaman Tidak Ditemukan</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            justify-content: center;
            align-items: center;
            text-align: center;
        }
        .container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 30px;
            max-width: 600px;
            width: 100%;
        }
        h1 {
            font-size: 48px;
            color: #e74c3c;
            margin-bottom: 20px;
        }
        p {
            font-size: 18px;
            margin-bottom: 20px;
        }
        .countdown {
            font-size: 22px;
            font-weight: bold;
            margin: 20px 0;
            color: #2c3e50;
        }
        @media (max-width: 768px) {
            h1 {
                font-size: 36px;
            }
            p {
                font-size: 16px;
            }
            .countdown {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>404</h1>
        <p>Website ini telah ditutup.</p>
        <p>Website dapat dibuka kembali dalam:</p>
        <div class="countdown">10 hari lagi</div>
    </div>
</body>
</html>