<?php
require_once 'config.php';
require_once 'functions.php';

// Mendapatkan pengaturan aplikasi
$settings = getSettings();

// Mengatur tema
$theme = $settings['theme'];
if ($theme === 'auto') {
    $theme = isset($_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME']) && 
             $_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME'] === 'dark' ? 'dark' : 'light';
}

// Proses form
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tambah transaksi baru
    if (isset($_POST['action']) && $_POST['action'] === 'add') {
        $type = $_POST['type'];
        $amount = (float)$_POST['amount'];
        $description = trim($_POST['description']);
        
        $fromType = $_POST['from_type'];
        $fromId = $fromType === 'personal' ? null : $_POST['from_id'];
        if ($fromType === 'external') {
            $fromId = trim($_POST['from_external_name']);
        }
        
        $toType = $_POST['to_type'];
        $toId = $toType === 'personal' ? null : $_POST['to_id'];
        if ($toType === 'external') {
            $toId = trim($_POST['to_external_name']);
        }
        
        $dueDate = $_POST['due_date'];
        
        if (empty($description) || $amount <= 0) {
            $message = 'Mohon isi semua field dengan benar';
            $messageType = 'error';
        } else {
            $from = ['type' => $fromType, 'id' => $fromId];
            $to = ['type' => $toType, 'id' => $toId];
            
            $newTransaction = addTransaction($type, $amount, $description, $from, $to, $dueDate);
            
            if ($newTransaction) {
                $message = 'Transaksi berhasil ditambahkan';
                $messageType = 'success';
                // Redirect ke halaman detail
                header('Location: transactions.php?action=view&id=' . $newTransaction['id']);
                exit;
            } else {
                $message = 'Gagal menambahkan transaksi';
                $messageType = 'error';
            }
        }
    }
    // Tambah pembayaran
    else if (isset($_POST['action']) && $_POST['action'] === 'add_payment') {
        $id = $_POST['id'];
        $amount = (float)$_POST['payment_amount'];
        $note = trim($_POST['payment_note']);
        
        if ($amount <= 0) {
            $message = 'Jumlah pembayaran harus lebih dari 0';
            $messageType = 'error';
        } else {
            $added = addPaymentToTransaction($id, $amount, $note);
            
            if ($added) {
                $message = 'Pembayaran berhasil ditambahkan';
                $messageType = 'success';
            } else {
                $message = 'Gagal menambahkan pembayaran';
                $messageType = 'error';
            }
        }
    }
    // Update status transaksi
    else if (isset($_POST['action']) && $_POST['action'] === 'update_status') {
        $id = $_POST['id'];
        $status = $_POST['status'];
        
        $updated = updateTransactionStatus($id, $status);
        
        if ($updated) {
            $message = 'Status transaksi berhasil diperbarui';
            $messageType = 'success';
        } else {
            $message = 'Gagal memperbarui status transaksi';
            $messageType = 'error';
        }
    }
}

// Filter transaksi
$filterStatus = isset($_GET['filter_status']) ? $_GET['filter_status'] : '';
$filterType = isset($_GET['filter_type']) ? $_GET['filter_type'] : '';
$filterEntity = isset($_GET['filter_entity']) ? $_GET['filter_entity'] : '';
$filterEntityId = isset($_GET['filter_entity_id']) ? $_GET['filter_entity_id'] : null;

$transactions = getAllTransactions();

if (!empty($filterStatus)) {
    $transactions = array_filter($transactions, function($t) use ($filterStatus) {
        return $t['status'] === $filterStatus;
    });
}

if (!empty($filterType)) {
    $transactions = array_filter($transactions, function($t) use ($filterType) {
        return $t['type'] === $filterType;
    });
}

if (!empty($filterEntity)) {
    $transactions = filterTransactionsByEntity($filterEntity, $filterEntityId);
}

// Urutkan transaksi berdasarkan tanggal (terbaru duluan)
usort($transactions, function($a, $b) {
    return strtotime($b['date']) - strtotime($a['date']);
});

// Mendapatkan daftar bisnis untuk form
$businesses = getAllBusinesses();

// Menentukan mode tampilan
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$transactionId = isset($_GET['id']) ? $_GET['id'] : null;
$transaction = $transactionId ? getTransactionById($transactionId) : null;
?>
<!DOCTYPE html>
<html lang="id" data-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Meta tags untuk mencegah pengindeksan oleh mesin pencari -->
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">
    <meta name="yandex" content="none">
    <link rel="icon" href="https://app.dezki.biz.id/linkpic/assets/uploads/67dc5f2646a8d.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelolaan Transaksi - <?php echo $settings['app_name']; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/app.js" defer></script>
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1><?php echo $settings['app_name']; ?></h1>
            </div>
            <nav class="sidebar-nav">
                <ul>
                    <li><a href="index.php"><i class="icon icon-dashboard"></i> Dashboard</a></li>
                    <li><a href="businesses.php"><i class="icon icon-business"></i> Bisnis</a></li>
                    <li class="active"><a href="transactions.php"><i class="icon icon-transaction"></i> Transaksi</a></li>
                    <li><a href="reports.php"><i class="icon icon-report"></i> Laporan</a></li>
                    <li><a href="settings.php"><i class="icon icon-settings"></i> Pengaturan</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <header class="content-header">
                <h2>Pengelolaan Transaksi</h2>
                <div class="header-actions">
                    <?php if ($action === 'list'): ?>
                    <a href="transactions.php?action=add" class="btn btn-primary">
                        <i class="icon icon-plus"></i> Tambah Transaksi Baru
                    </a>
                    <?php else: ?>
                    <a href="transactions.php" class="btn btn-secondary">
                        <i class="icon icon-back"></i> Kembali ke Daftar
                    </a>
                    <?php endif; ?>
                </div>
            </header>

            <?php if (!empty($message)): ?>
            <div class="alert alert-<?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
            <?php endif; ?>

            <?php if ($action === 'list'): ?>
            <!-- Filter Transaksi -->
            <div class="card filter-card">
                <div class="card-body">
                    <form method="get" class="filter-form">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="filter_status">Status</label>
                                <select id="filter_status" name="filter_status" class="form-control">
                                    <option value="">Semua Status</option>
                                    <option value="active" <?php echo $filterStatus === 'active' ? 'selected' : ''; ?>>Aktif</option>
                                    <option value="paid" <?php echo $filterStatus === 'paid' ? 'selected' : ''; ?>>Lunas</option>
                                    <option value="canceled" <?php echo $filterStatus === 'canceled' ? 'selected' : ''; ?>>Dibatalkan</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="filter_type">Tipe</label>
                                <select id="filter_type" name="filter_type" class="form-control">
                                    <option value="">Semua Tipe</option>
                                    <option value="debt" <?php echo $filterType === 'debt' ? 'selected' : ''; ?>>Utang</option>
                                    <option value="receivable" <?php echo $filterType === 'receivable' ? 'selected' : ''; ?>>Piutang</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="filter_entity">Entitas</label>
                                <select id="filter_entity" name="filter_entity" class="form-control">
                                    <option value="">Semua Entitas</option>
                                    <option value="personal" <?php echo $filterEntity === 'personal' ? 'selected' : ''; ?>>Pribadi</option>
                                    <option value="business" <?php echo $filterEntity === 'business' ? 'selected' : ''; ?>>Bisnis</option>
                                    <option value="external" <?php echo $filterEntity === 'external' ? 'selected' : ''; ?>>Eksternal</option>
                                </select>
                            </div>
                            
                            <div class="form-group" id="business_filter_group" style="<?php echo $filterEntity === 'business' ? '' : 'display: none;'; ?>">
                                <label for="filter_entity_id">Bisnis</label>
                                <select id="filter_entity_id" name="filter_entity_id" class="form-control">
                                    <option value="">Semua Bisnis</option>
                                    <?php foreach ($businesses as $b): ?>
                                    <option value="<?php echo $b['id']; ?>" <?php echo $filterEntityId === $b['id'] ? 'selected' : ''; ?>>
                                        <?php echo htmlspecialchars($b['name']); ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Filter</button>
                            <a href="transactions.php" class="btn btn-secondary">Reset</a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Daftar Transaksi -->
            <div class="card">
                <div class="card-body">
                    <?php if (empty($transactions)): ?>
                    <div class="empty-state">
                        <p>Belum ada transaksi yang tersedia.</p>
                        <a href="transactions.php?action=add" class="btn btn-primary">
                            Tambah Transaksi Baru
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Deskripsi</th>
                                    <th>Dari</th>
                                    <th>Ke</th>
                                    <th>Jumlah</th>
                                    <th>Tipe</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($transactions as $t): ?>
                                <tr>
                                    <td><?php echo formatDate($t['date']); ?></td>
                                    <td><?php echo htmlspecialchars($t['description']); ?></td>
                                    <td>
                                        <?php 
                                        if ($t['from']['type'] === 'personal') {
                                            echo 'Pribadi';
                                        } else if ($t['from']['type'] === 'business') {
                                            $b = getBusinessById($t['from']['id']);
                                            echo $b ? htmlspecialchars($b['name']) : 'Bisnis #' . $t['from']['id'];
                                        } else {
                                            echo htmlspecialchars($t['from']['id']); // External name
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        if ($t['to']['type'] === 'personal') {
                                            echo 'Pribadi';
                                        } else if ($t['to']['type'] === 'business') {
                                            $b = getBusinessById($t['to']['id']);
                                            echo $b ? htmlspecialchars($b['name']) : 'Bisnis #' . $t['to']['id'];
                                        } else {
                                            echo htmlspecialchars($t['to']['id']); // External name
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo formatCurrency($t['amount']); ?></td>
                                    <td>
                                        <?php if ($t['type'] === 'debt'): ?>
                                        <span class="badge badge-danger">Utang</span>
                                        <?php else: ?>
                                        <span class="badge badge-success">Piutang</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($t['status'] === 'active'): ?>
                                        <span class="badge badge-warning">Aktif</span>
                                        <?php elseif ($t['status'] === 'paid'): ?>
                                        <span class="badge badge-success">Lunas</span>
                                        <?php else: ?>
                                        <span class="badge badge-secondary">Dibatalkan</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="transactions.php?action=view&id=<?php echo $t['id']; ?>" class="btn btn-sm btn-info">
                                            Detail
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <script>
                // Script untuk menampilkan/menyembunyikan filter bisnis
                document.getElementById('filter_entity').addEventListener('change', function() {
                    var businessFilterGroup = document.getElementById('business_filter_group');
                    if (this.value === 'business') {
                        businessFilterGroup.style.display = '';
                    } else {
                        businessFilterGroup.style.display = 'none';
                    }
                });
            </script>
            
            <?php elseif ($action === 'add'): ?>
            <!-- Form Tambah Transaksi -->
            <div class="card">
                <div class="card-header">
                    <h3>Tambah Transaksi Baru</h3>
                </div>
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="action" value="add">
                        
                        <div class="form-group">
                            <label for="type">Tipe Transaksi</label>
                            <select id="type" name="type" class="form-control" required>
                                <option value="debt">Utang</option>
                                <option value="receivable">Piutang</option>
                            </select>
                            <small class="form-text text-muted">
                                Utang: Anda meminjam uang dari seseorang/bisnis<br>
                                Piutang: Anda meminjamkan uang kepada seseorang/bisnis
                            </small>
                        </div>
                        
                        <div class="form-group">
                            <label for="amount">Jumlah</label>
                            <input type="number" id="amount" name="amount" class="form-control" min="1" step="1" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Deskripsi</label>
                            <textarea id="description" name="description" class="form-control" rows="2" required></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="due_date">Tanggal Jatuh Tempo</label>
                            <input type="date" id="due_date" name="due_date" class="form-control" required>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="from_type">Dari</label>
                                <select id="from_type" name="from_type" class="form-control entity-type-select" required>
                                    <option value="personal">Pribadi</option>
                                    <option value="business">Bisnis</option>
                                    <option value="external">Pihak Eksternal</option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-6 entity-select" id="from_business_group" style="display: none;">
                                <label for="from_id">Pilih Bisnis</label>
                                <select id="from_id" name="from_id" class="form-control">
                                    <?php foreach ($businesses as $b): ?>
                                    <option value="<?php echo $b['id']; ?>"><?php echo htmlspecialchars($b['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-6 entity-select" id="from_external_group" style="display: none;">
                                <label for="from_external_name">Nama Pihak Eksternal</label>
                                <input type="text" id="from_external_name" name="from_external_name" class="form-control">
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="to_type">Ke</label>
                                <select id="to_type" name="to_type" class="form-control entity-type-select" required>
                                    <option value="personal">Pribadi</option>
                                    <option value="business">Bisnis</option>
                                    <option value="external">Pihak Eksternal</option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-6 entity-select" id="to_business_group" style="display: none;">
                                <label for="to_id">Pilih Bisnis</label>
                                <select id="to_id" name="to_id" class="form-control">
                                    <?php foreach ($businesses as $b): ?>
                                    <option value="<?php echo $b['id']; ?>"><?php echo htmlspecialchars($b['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-6 entity-select" id="to_external_group" style="display: none;">
                                <label for="to_external_name">Nama Pihak Eksternal</label>
                                <input type="text" id="to_external_name" name="to_external_name" class="form-control">
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                            <a href="transactions.php" class="btn btn-secondary">Batal</a>
                        </div>
                    </form>
                </div>
            </div>

            <script>
                // Script untuk handling form entity selection
                document.addEventListener('DOMContentLoaded', function() {
                    const entitySelects = document.querySelectorAll('.entity-type-select');
                    
                    entitySelects.forEach(select => {
                        select.addEventListener('change', function() {
                            const prefix = this.id.split('_')[0]; // from or to
                            
                            // Hide all entity select groups for this prefix
                            document.querySelectorAll(`.entity-select[id^="${prefix}_"]`).forEach(el => {
                                el.style.display = 'none';
                            });
                            
                            // Show the appropriate one
                            if (this.value === 'business') {
                                document.getElementById(`${prefix}_business_group`).style.display = '';
                            } else if (this.value === 'external') {
                                document.getElementById(`${prefix}_external_group`).style.display = '';
                            }
                        });
                    });
                    
                    // Set due date default to 30 days from now
                    const today = new Date();
                    const thirtyDaysLater = new Date(today);
                    thirtyDaysLater.setDate(today.getDate() + 30);
                    
                    const dueDateInput = document.getElementById('due_date');
                    dueDateInput.valueAsDate = thirtyDaysLater;
                });
            </script>
            
            <?php elseif ($action === 'view' && $transaction): ?>
            <!-- Detail Transaksi -->
            <div class="card">
                <div class="card-header">
                    <h3>Detail Transaksi</h3>
                </div>
                <div class="card-body">
                    <div class="transaction-info">
                        <div class="transaction-badge">
                            <?php if ($transaction['type'] === 'debt'): ?>
                            <span class="badge badge-danger">Utang</span>
                            <?php else: ?>
                            <span class="badge badge-success">Piutang</span>
                            <?php endif; ?>
                            
                            <?php if ($transaction['status'] === 'active'): ?>
                            <span class="badge badge-warning">Aktif</span>
                            <?php elseif ($transaction['status'] === 'paid'): ?>
                            <span class="badge badge-success">Lunas</span>
                            <?php else: ?>
                            <span class="badge badge-secondary">Dibatalkan</span>
                            <?php endif; ?>
                        </div>
                        
                        <div class="transaction-detail">
                            <table class="detail-table">
                                <tr>
                                    <th>ID Transaksi:</th>
                                    <td><?php echo $transaction['id']; ?></td>
                                </tr>
                                <tr>
                                    <th>Tanggal:</th>
                                    <td><?php echo formatDateTime($transaction['date']); ?></td>
                                </tr>
                                <tr>
                                    <th>Deskripsi:</th>
                                    <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                                </tr>
                                <tr>
                                    <th>Dari:</th>
                                    <td>
                                        <?php 
                                        if ($transaction['from']['type'] === 'personal') {
                                            echo 'Pribadi';
                                        } else if ($transaction['from']['type'] === 'business') {
                                            $b = getBusinessById($transaction['from']['id']);
                                            echo $b ? htmlspecialchars($b['name']) : 'Bisnis #' . $transaction['from']['id'];
                                        } else {
                                            echo htmlspecialchars($transaction['from']['id']); // External name
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Ke:</th>
                                    <td>
                                        <?php 
                                        if ($transaction['to']['type'] === 'personal') {
                                            echo 'Pribadi';
                                        } else if ($transaction['to']['type'] === 'business') {
                                            $b = getBusinessById($transaction['to']['id']);
                                            echo $b ? htmlspecialchars($b['name']) : 'Bisnis #' . $transaction['to']['id'];
                                        } else {
                                            echo htmlspecialchars($transaction['to']['id']); // External name
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Jumlah:</th>
                                    <td><strong><?php echo formatCurrency($transaction['amount']); ?></strong></td>
                                </tr>
                                <tr>
                                    <th>Jatuh Tempo:</th>
                                    <td>
                                        <?php echo formatDate($transaction['due_date']); ?>
                                        <?php
                                        $dueDate = new DateTime($transaction['due_date']);
                                        $now = new DateTime();
                                        $interval = $now->diff($dueDate);
                                        
                                        if ($transaction['status'] === 'active') {
                                            if ($dueDate < $now) {
                                                echo ' <span class="badge badge-danger">Terlambat ' . $interval->days . ' hari</span>';
                                            } else if ($interval->days <= $settings['reminder_days']) {
                                                echo ' <span class="badge badge-warning">Segera jatuh tempo</span>';
                                            }
                                        }
                                        ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <!-- Riwayat Pembayaran -->
                    <div class="payment-history">
                        <h4>Riwayat Pembayaran</h4>
                        <?php if (empty($transaction['payment_history'])): ?>
                        <p>Belum ada pembayaran yang tercatat.</p>
                        <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Jumlah</th>
                                        <th>Catatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $totalPaid = 0;
                                    foreach ($transaction['payment_history'] as $payment): 
                                        $totalPaid += $payment['amount'];
                                    ?>
                                    <tr>
                                        <td><?php echo formatDateTime($payment['date']); ?></td>
                                        <td><?php echo formatCurrency($payment['amount']); ?></td>
                                        <td><?php echo htmlspecialchars($payment['note']); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total Dibayar:</th>
                                        <th><?php echo formatCurrency($totalPaid); ?></th>
                                        <th></th>
                                    </tr>
                                    <tr>
                                        <th>Sisa:</th>
                                        <th><?php echo formatCurrency(max(0, $transaction['amount'] - $totalPaid)); ?></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($transaction['status'] === 'active'): ?>
                    <!-- Form Tambah Pembayaran -->
                    <div class="payment-form">
                        <h4>Tambah Pembayaran</h4>
                        <form method="post">
                            <input type="hidden" name="action" value="add_payment">
                            <input type="hidden" name="id" value="<?php echo $transaction['id']; ?>">
                            
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="payment_amount">Jumlah Pembayaran</label>
                                    <input type="number" id="payment_amount" name="payment_amount" class="form-control" 
                                           min="1" max="<?php echo $transaction['amount']; ?>" step="1" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="payment_note">Catatan</label>
                                    <input type="text" id="payment_note" name="payment_note" class="form-control">
                                </div>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="btn btn-success">Tambah Pembayaran</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Form Update Status -->
                    <div class="status-form">
                        <h4>Update Status</h4>
                        <form method="post">
                            <input type="hidden" name="action" value="update_status">
                            <input type="hidden" name="id" value="<?php echo $transaction['id']; ?>">
                            
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="status">Status Baru</label>
                                    <select id="status" name="status" class="form-control" required>
                                        <option value="active" <?php echo $transaction['status'] === 'active' ? 'selected' : ''; ?>>Aktif</option>
                                        <option value="paid" <?php echo $transaction['status'] === 'paid' ? 'selected' : ''; ?>>Lunas</option>
                                        <option value="canceled" <?php echo $transaction['status'] === 'canceled' ? 'selected' : ''; ?>>Dibatalkan</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary">Update Status</button>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </main>
    </div>
</body>
</html>