<?php
// config.php - File konfigurasi utama

// Konfigurasi dasar
define('APP_NAME', 'Aplikasi Pengelola Utang Piutang');
define('BASE_PATH', __DIR__);
define('DATA_PATH', BASE_PATH . '/data');
define('TIMEZONE', 'Asia/Jakarta');

// Mengatur timezone
date_default_timezone_set(TIMEZONE);

// Memastikan folder data ada
if (!file_exists(DATA_PATH)) {
    mkdir(DATA_PATH, 0755, true);
}

// File JSON
define('BUSINESSES_FILE', DATA_PATH . '/businesses.json');
define('PERSONAL_FILE', DATA_PATH . '/personal.json');
define('TRANSACTIONS_FILE', DATA_PATH . '/transactions.json');
define('SETTINGS_FILE', DATA_PATH . '/settings.json');

// Inisialisasi file JSON jika belum ada
function initializeJsonFiles() {
    // Struktur default businesses.json
    if (!file_exists(BUSINESSES_FILE)) {
        $businessesData = [
            'businesses' => []
        ];
        file_put_contents(BUSINESSES_FILE, json_encode($businessesData, JSON_PRETTY_PRINT));
    }

    // Struktur default personal.json
    if (!file_exists(PERSONAL_FILE)) {
        $personalData = [
            'balance' => 0,
            'updated_at' => date('c')
        ];
        file_put_contents(PERSONAL_FILE, json_encode($personalData, JSON_PRETTY_PRINT));
    }

    // Struktur default transactions.json
    if (!file_exists(TRANSACTIONS_FILE)) {
        $transactionsData = [
            'transactions' => []
        ];
        file_put_contents(TRANSACTIONS_FILE, json_encode($transactionsData, JSON_PRETTY_PRINT));
    }

    // Struktur default settings.json
    if (!file_exists(SETTINGS_FILE)) {
        $settingsData = [
            'app_name' => APP_NAME,
            'theme' => 'auto',
            'currency' => 'Rp',
            'date_format' => 'd/m/Y',
            'time_format' => 'H:i',
            'reminder_days' => 3
        ];
        file_put_contents(SETTINGS_FILE, json_encode($settingsData, JSON_PRETTY_PRINT));
    }
}

// Fungsi untuk membaca data JSON
function readJsonFile($filePath) {
    if (!file_exists($filePath)) {
        return null;
    }
    
    $jsonData = file_get_contents($filePath);
    return json_decode($jsonData, true);
}

// Fungsi untuk menulis data JSON
function writeJsonFile($filePath, $data) {
    file_put_contents($filePath, json_encode($data, JSON_PRETTY_PRINT));
    return true;
}

// Fungsi untuk mendapatkan pengaturan
function getSettings() {
    return readJsonFile(SETTINGS_FILE);
}

// Fungsi untuk memperbarui pengaturan
function updateSettings($newSettings) {
    $currentSettings = getSettings();
    $updatedSettings = array_merge($currentSettings, $newSettings);
    return writeJsonFile(SETTINGS_FILE, $updatedSettings);
}

// Fungsi untuk format mata uang
function formatCurrency($amount) {
    $settings = getSettings();
    return $settings['currency'] . ' ' . number_format($amount, 0, ',', '.');
}

// Fungsi untuk format tanggal
function formatDate($dateString) {
    $settings = getSettings();
    $date = new DateTime($dateString);
    return $date->format($settings['date_format']);
}

// Fungsi untuk format waktu
function formatDateTime($dateString) {
    $settings = getSettings();
    $date = new DateTime($dateString);
    return $date->format($settings['date_format'] . ' ' . $settings['time_format']);
}

// Fungsi untuk generate ID unik
function generateId($prefix) {
    return $prefix . '-' . strtolower(substr(md5(uniqid(mt_rand(), true)), 0, 8));
}

// Inisialisasi aplikasi
initializeJsonFiles();