<?php
session_start();

// File penyimpanan tugas
$tasksFile = 'tasks.json';

// Fungsi untuk memuat tugas
function loadTasks() {
    global $tasksFile;
    if (file_exists($tasksFile)) {
        $tasksJson = file_get_contents($tasksFile);
        $tasks = json_decode($tasksJson, true);
        if (!$tasks || !is_array($tasks)) {
            $tasks = ['work' => [], 'college' => [], 'personal' => []];
        }
        return $tasks;
    }
    return ['work' => [], 'college' => [], 'personal' => []];
}

// Fungsi untuk menyimpan tugas
function saveTasks($tasks) {
    global $tasksFile;
    file_put_contents($tasksFile, json_encode($tasks, JSON_PRETTY_PRINT));
}

// Daftar mapel untuk kategori kuliah
$collegeSubjects = [
    'matematika' => 'Matematika',
    'fisika' => 'Fisika',
    'kimia' => 'Kimia',
    'biologi' => 'Biologi',
    'komputer' => 'Ilmu Komputer',
    'bahasa' => 'Bahasa',
    'sosial' => 'Ilmu Sosial'
];

// Memproses logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: index.php");
    exit();
}

// Proses login
$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['login'])) {
        // Cek login sederhana
        if ($_POST['username'] == 'rizaldi' && $_POST['password'] == 'admin123') {
            $_SESSION['logged_in'] = true;
            header("Location: index.php");
            exit();
        } else {
            $error = 'Username atau password salah!';
        }
    }

    // Tambah tugas
    if (isset($_POST['add_task']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
        $tasks = loadTasks();
        
        // Siapkan struktur dasar tugas
        $newTask = [
            'id' => uniqid(),
            'title' => $_POST['title'],
            'category' => $_POST['category'],
            'start_date' => $_POST['start_date'],
            'deadline' => $_POST['deadline'],
            'description' => $_POST['description'],
            'link' => $_POST['link'] ?? '',
            'completed' => false,
            'created_at' => date('Y-m-d H:i:s')
        ];
        
        // Jika kategori adalah kuliah, tambahkan data mapel
        if ($_POST['category'] === 'college') {
            $newTask['subjects'] = [];
            
            // Cek mapel yang dipilih
            foreach ($collegeSubjects as $subjectKey => $subjectName) {
                if (isset($_POST['subjects']) && in_array($subjectKey, $_POST['subjects'])) {
                    $newTask['subjects'][$subjectKey] = [
                        'name' => $subjectName,
                        'completed' => false
                    ];
                }
            }
        }
        
        $tasks[$_POST['category']][] = $newTask;
        saveTasks($tasks);
        header("Location: index.php?category={$_POST['category']}");
        exit();
    }

    // Edit tugas
    if (isset($_POST['edit_task']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
        $tasks = loadTasks();
        $taskId = $_POST['task_id'];
        $category = $_POST['original_category'];
        $newCategory = $_POST['category'];
        
        // Temukan tugas yang akan diedit
        $taskIndex = -1;
        $taskData = null;
        
        foreach ($tasks[$category] as $index => $task) {
            if ($task['id'] == $taskId) {
                $taskIndex = $index;
                $taskData = $task;
                break;
            }
        }
        
        if ($taskIndex !== -1) {
            // Hapus tugas dari kategori lama
            array_splice($tasks[$category], $taskIndex, 1);
            
            // Buat tugas dengan data yang diperbarui
            $updatedTask = [
                'id' => $taskId,
                'title' => $_POST['title'],
                'category' => $newCategory,
                'start_date' => $_POST['start_date'],
                'deadline' => $_POST['deadline'],
                'description' => $_POST['description'],
                'link' => $_POST['link'] ?? '',
                'completed' => isset($taskData['completed']) ? $taskData['completed'] : false,
                'created_at' => isset($taskData['created_at']) ? $taskData['created_at'] : date('Y-m-d H:i:s')
            ];
            
            // Update data mapel jika kategori kuliah
            if ($newCategory === 'college') {
                $updatedTask['subjects'] = [];
                
                // Jika sebelumnya sudah ada data mapel, pertahankan status completed
                $existingSubjects = isset($taskData['subjects']) ? $taskData['subjects'] : [];
                
                // Cek mapel yang dipilih
                foreach ($collegeSubjects as $subjectKey => $subjectName) {
                    if (isset($_POST['subjects']) && in_array($subjectKey, $_POST['subjects'])) {
                        $completed = false;
                        // Jika mapel sebelumnya sudah ada dan status selesai, pertahankan
                        if (isset($existingSubjects[$subjectKey]) && $existingSubjects[$subjectKey]['completed']) {
                            $completed = true;
                        }
                        
                        $updatedTask['subjects'][$subjectKey] = [
                            'name' => $subjectName,
                            'completed' => $completed
                        ];
                    }
                }
            }
            
            // Tambahkan ke kategori baru
            $tasks[$newCategory][] = $updatedTask;
            saveTasks($tasks);
            
            header("Location: index.php?category=$newCategory");
            exit();
        }
    }
}

// Tandai tugas selesai/batalkan
if (isset($_GET['toggle']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    $tasks = loadTasks();
    $category = $_GET['category'];
    $taskId = $_GET['toggle'];
    
    foreach ($tasks[$category] as &$task) {
        if ($task['id'] == $taskId) {
            $task['completed'] = !$task['completed'];
            break;
        }
    }
    
    saveTasks($tasks);
    
    // Redirect kembali ke halaman dengan parameter status yang sama
    $status = isset($_GET['status']) ? $_GET['status'] : 'current';
    header("Location: index.php?category=$category&status=$status");
    exit();
}

// Tandai mapel selesai/batalkan
if (isset($_GET['toggle_subject']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    $tasks = loadTasks();
    $category = $_GET['category'];
    $taskId = $_GET['task_id'];
    $subjectKey = $_GET['toggle_subject'];
    
    foreach ($tasks[$category] as &$task) {
        if ($task['id'] == $taskId && isset($task['subjects'][$subjectKey])) {
            $task['subjects'][$subjectKey]['completed'] = !$task['subjects'][$subjectKey]['completed'];
            
            // Periksa jika semua mapel sudah selesai
            $allCompleted = true;
            foreach ($task['subjects'] as $subject) {
                if (!$subject['completed']) {
                    $allCompleted = false;
                    break;
                }
            }
            
            // Update status tugas keseluruhan
            $task['completed'] = $allCompleted;
            
            break;
        }
    }
    
    saveTasks($tasks);
    
    // Redirect kembali ke halaman dengan parameter status yang sama
    $status = isset($_GET['status']) ? $_GET['status'] : 'current';
    header("Location: index.php?category=$category&status=$status");
    exit();
}

// Hapus tugas
if (isset($_GET['delete']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    $tasks = loadTasks();
    $category = $_GET['category'];
    $taskId = $_GET['delete'];
    
    $tasks[$category] = array_filter($tasks[$category], function($task) use ($taskId) {
        return $task['id'] != $taskId;
    });
    
    saveTasks($tasks);
    
    // Redirect kembali ke halaman dengan parameter status yang sama
    $status = isset($_GET['status']) ? $_GET['status'] : 'current';
    header("Location: index.php?category=$category&status=$status");
    exit();
}

// Ambil detail tugas untuk edit
$editTask = null;
if (isset($_GET['edit']) && isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    $tasks = loadTasks();
    $category = $_GET['category'];
    $taskId = $_GET['edit'];
    
    foreach ($tasks[$category] as $task) {
        if ($task['id'] == $taskId) {
            $editTask = $task;
            break;
        }
    }
}

// Tentukan kategori dan status yang ditampilkan
$currentCategory = $_GET['category'] ?? 'work';
$currentStatus = $_GET['status'] ?? 'current';

// Tentukan bulan dan tahun untuk kalender
$calendarMonth = isset($_GET['month']) ? intval($_GET['month']) : intval(date('m'));
$calendarYear = isset($_GET['year']) ? intval($_GET['year']) : intval(date('Y'));

// Validasi bulan dan tahun
if ($calendarMonth < 1) {
    $calendarMonth = 12;
    $calendarYear--;
} elseif ($calendarMonth > 12) {
    $calendarMonth = 1;
    $calendarYear++;
}

// Cek apakah sudah login
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Kerjain</title>
    <link rel="icon" type="image/png" href="https://app.dezki.biz.id/linkpic/assets/uploads/67fbe7f6a2b6a.png" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4CAF50;
            --danger-color: #f44336;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --text-color: #333;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body { 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fa;
            color: var(--text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        
        .login-container {
            width: 380px;
            padding: 2rem;
            background-color: white;
            border-radius: 10px;
            box-shadow: var(--shadow);
        }
        
        .logo {
            text-align: center;
            margin-bottom: 1.5rem;
            color: var(--primary-color);
        }
        
        .logo i {
            font-size: 3rem;
            margin-bottom: 0.5rem;
        }
        
        .logo h1 {
            font-size: 1.8rem;
            font-weight: 600;
        }
        
        form .input-group {
            margin-bottom: 1.2rem;
            position: relative;
        }
        
        form .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #aaa;
        }
        
        form input {
            width: 100%;
            padding: 12px 15px 12px 45px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        form input:focus {
            outline: none;
            border-color: var(--primary-color);
        }
        
        form button {
            width: 100%;
            padding: 12px;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        form button:hover {
            background-color: var(--secondary-color);
        }
        
        .error { 
            color: var(--danger-color);
            text-align: center;
            margin-bottom: 1rem;
            padding: 8px;
            background-color: rgba(244, 67, 54, 0.1);
            border-radius: 4px;
        }
        .task-link {
            margin-top: 10px;
        }

        .task-link a {
            color: var(--primary-color);
            text-decoration: none;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
        }

        .task-link a i {
            margin-right: 5px;
        }

        .task-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <i class="fas fa-tasks"></i>
            <h1>Kerjain</h1>
        </div>
        
        <form method="post" action="index.php">
            <?php if ($error): ?>
                <div class="error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <div class="input-group">
                <i class="fas fa-user"></i>
                <input type="text" name="username" placeholder="Username" required>
            </div>
            
            <div class="input-group">
                <i class="fas fa-lock"></i>
                <input type="password" name="password" placeholder="Password" required>
            </div>
            
            <button type="submit" name="login">
                <i class="fas fa-sign-in-alt"></i> Login
            </button>
        </form>
    </div>
</body>
</html>
<?php 
    exit(); 
} 

// Load tasks jika sudah login
$tasks = loadTasks();

// Filter tugas berdasarkan status
function filterTasksByStatus($tasks, $status) {
    $today = date('Y-m-d');
    $filteredTasks = [];
    
    foreach ($tasks as $task) {
        switch ($status) {
            case 'current':
                if (!$task['completed'] && $task['start_date'] <= $today && $task['deadline'] >= $today) {
                    $filteredTasks[] = $task;
                }
                break;
            case 'upcoming':
                if (!$task['completed'] && $task['start_date'] > $today) {
                    $filteredTasks[] = $task;
                }
                break;
            case 'completed':
                if ($task['completed']) {
                    $filteredTasks[] = $task;
                }
                break;
            case 'deadline':
                $deadlineDate = new DateTime($task['deadline']);
                $todayDate = new DateTime($today);
                $diff = $todayDate->diff($deadlineDate)->days;
                $isPast = $deadlineDate < $todayDate;
                
                if (!$task['completed'] && ($isPast || $diff <= 3)) {
                    $filteredTasks[] = $task;
                }
                break;
        }
    }
    
    // Urutkan tugas berdasarkan deadline terdekat
usort($filteredTasks, function($a, $b) {
    return strtotime($a['start_date']) - strtotime($b['start_date']);
});

return $filteredTasks;
}

// Filter tugas saat ini untuk kategori yang dipilih
$filteredTasks = [];
if (isset($tasks[$currentCategory])) {
    $filteredTasks = filterTasksByStatus($tasks[$currentCategory], $currentStatus);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kerjain</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.13/flatpickr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.13/flatpickr.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --success-color: #4CAF50;
            --danger-color: #f44336;
            --warning-color: #ffc107;
            --info-color: #2196F3;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --text-color: #333;
            --border-color: #e0e0e0;
            --shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            --sidebar-width: 250px;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body { 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fa;
            color: var(--text-color);
            line-height: 1.6;
        }
        
        .container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            background-color: white;
            box-shadow: var(--shadow);
            padding: 1.5rem 0;
            position: fixed;
            height: 100%;
            overflow-y: auto;
            z-index: 1000;
            transition: transform 0.3s ease;
        }
        
        .sidebar-header {
            display: flex;
            align-items: center;
            padding: 0 1.5rem 1.5rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 1.5rem;
        }
        
        .sidebar-header i {
            font-size: 1.8rem;
            color: var(--primary-color);
            margin-right: 10px;
        }
        
        .sidebar-header h1 {
            font-size: 1.3rem;
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .sidebar-menu h2 {
            font-size: 0.9rem;
            text-transform: uppercase;
            color: #999;
            margin: 1rem 0 0.5rem;
            padding: 0 1.5rem;
        }
        
        .sidebar-menu ul {
            list-style: none;
        }
        
        .sidebar-menu li a {
            display: flex;
            align-items: center;
            padding: 0.8rem 1.5rem;
            text-decoration: none;
            color: var(--text-color);
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .sidebar-menu li a:hover {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
        }
        
        .sidebar-menu li a.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        .sidebar-menu li a i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .sidebar-menu .badge {
            margin-left: auto;
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            border-radius: 20px;
            padding: 2px 8px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .sidebar-menu li a.active .badge {
            background-color: white;
            color: var(--primary-color);
        }
        
        .main-content {
            flex: 1;
            margin-left: var(--sidebar-width);
            padding: 2rem;
        }
        
        /* Header Styles */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
        }
        
        .page-title h1 {
            font-size: 1.8rem;
            color: var(--dark-color);
            margin-bottom: 0.5rem;
        }
        
        .page-title p {
            color: #666;
            font-size: 0.95rem;
        }
        
        .header-actions {
            display: flex;
            align-items: center;
        }
        
        .header-actions .btn {
            margin-left: 10px;
        }
    
        
        /* Task Container Styles */
        .task-container {
            display: grid;
            grid-template-columns: 7fr 3fr;
            gap: 1.5rem;
        }
        
        .task-list-container {
            background-color: white;
            border-radius: 10px;
            box-shadow: var(--shadow);
            padding: 1.5rem;
        }
        
        .task-list-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 15px;
            margin-bottom: 15px;
            border-bottom: 1px solid var(--border-color);
        }
        
        .task-list-header h2 {
            color: var(--primary-color);
            font-size: 1.3rem;
            display: flex;
            align-items: center;
        }
        
        .task-list-header h2 i {
            margin-right: 10px;
        }
        
        .task-count {
            background-color: var(--primary-color);
            color: white;
            border-radius: 20px;
            padding: 3px 10px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .task-list {
            max-height: 600px;
            overflow-y: auto;
        }
        
        .task-item {
            position: relative;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 12px;
            background-color: var(--light-color);
            border-left: 4px solid var(--primary-color);
            transition: all 0.3s;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        
        .task-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 3px 6px rgba(0,0,0,0.1);
        }
        
        .task-item.overdue {
            border-left-color: var(--danger-color);
        }
        
        .task-item.today {
            border-left-color: var(--warning-color);
        }
        
        .task-item.upcoming {
            border-left-color: var(--info-color);
        }
        
        .task-item.completed {
            border-left-color: var(--success-color);
            background-color: rgba(76, 175, 80, 0.1);
        }
        
        .task-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }
        
        .task-title {
            font-weight: 600;
            color: var(--dark-color);
            margin-right: 10px;
            font-size: 15px;
        }
        
        .task-completed .task-title {
            text-decoration: line-through;
            color: #888;
        }
        
        .task-dates {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
            font-size: 13px;
            color: #666;
        }
        
        .task-start-date,
        .task-deadline {
            display: flex;
            align-items: center;
            margin-right: 12px;
        }
        
        .task-start-date i,
        .task-deadline i {
            margin-right: 4px;
            font-size: 12px;
        }
        
        .task-description {
            font-size: 13px;
            color: #555;
            margin-bottom: 8px;
            line-height: 1.4;
            max-height: 60px;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
        }
        
        .task-actions {
            display: flex;
            flex-wrap: wrap;
            justify-content: flex-end;
            gap: 6px;
        }
        
        .task-actions a {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            text-decoration: none;
            display: flex;
            align-items: center;
        }
        
        .task-actions a i {
            margin-right: 4px;
            font-size: 11px;
        }
        
        /* Subject Pills */
        .subject-list {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-bottom: 10px;
        }
        
        .subject-pill {
            display: inline-flex;
            align-items: center;
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 11px;
            text-decoration: none;
            transition: all 0.2s;
        }
        
        .subject-pill:hover {
            background-color: rgba(67, 97, 238, 0.2);
        }
        
        .subject-pill i {
            margin-right: 4px;
            font-size: 10px;
        }
        
        .subject-pill.completed {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--success-color);
        }
        
        /* Calendar Styles */
        .calendar-container {
            background-color: white;
            border-radius: 10px;
            box-shadow: var(--shadow);
            padding: 1.5rem;
        }
        
        .calendar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 15px;
            margin-bottom: 15px;
            border-bottom: 1px solid var(--border-color);
        }
        
        .calendar-header h2 {
            color: var(--primary-color);
            font-size: 1.3rem;
            display: flex;
            align-items: center;
        }
        
        .calendar-header h2 i {
            margin-right: 10px;
        }
        
        .calendar-nav {
            display: flex;
            align-items: center;
        }
        
        .calendar-nav a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            text-decoration: none;
            margin: 0 5px;
            transition: all 0.3s;
        }
        
        .calendar-nav a:hover {
            background-color: var(--primary-color);
            color: white;
        }
        
        .calendar-nav .current-month {
            font-weight: 600;
            color: var(--primary-color);
            margin: 0 10px;
        }
        
        .calendar {
            width: 100%;
            border-collapse: collapse;
        }
        
        .calendar th {
            padding: 10px;
            text-align: center;
            font-weight: 600;
            color: #666;
        }
        
        .calendar td {
            padding: 10px;
            text-align: center;
            border: 1px solid #eee;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .calendar td.today {
            background-color: rgba(255, 193, 7, 0.2);
            font-weight: 600;
        }
        
        .calendar td.has-tasks {
            position: relative;
        }
        
        .calendar td.has-tasks::after {
            content: '';
            position: absolute;
            bottom: 5px;
            left: 50%;
            transform: translateX(-50%);
            width: 5px;
            height: 5px;
            border-radius: 50%;
            background-color: var(--primary-color);
        }
        
        .calendar td:hover {
            background-color: rgba(67, 97, 238, 0.1);
        }
        
        .calendar-legend {
            margin-top: 20px;
            font-size: 13px;
            color: #666;
        }
        
        .legend-item {
            display: flex;
            align-items: center;
            margin-bottom: 5px;
        }
        
        .legend-dot {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 8px;
        }
        
        /* Button Styles */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 15px;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
        }
        
        .btn i {
            margin-right: 5px;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--secondary-color);
        }
        
        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }
        
        .btn-danger:hover {
            background-color: #d32f2f;
        }
        
        .btn-success {
            background-color: var(--success-color);
            color: white;
        }
        
        .btn-success:hover {
            background-color: #388e3c;
        }
        
        .btn-warning {
            background-color: var(--warning-color);
            color: white;
        }
        
        .btn-warning:hover {
            background-color: #e0a800;
        }
        
        .btn-info {
            background-color: var(--info-color);
            color: white;
        }
        
        .btn-info:hover {
            background-color: #0b7dda;
        }
        
        .btn-outline {
            background-color: transparent;
            border: 1px solid var(--border-color);
            color: var(--text-color);
        }
        
        .btn-outline:hover {
            background-color: var(--light-color);
        }
        
        .btn-add {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: var(--primary-color);
            color: white;
            font-size: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
            z-index: 100;
            transition: all 0.3s;
        }
        
        .btn-add:hover {
            background-color: var(--secondary-color);
            transform: scale(1.05);
        }
        
        .btn-sm {
            padding: 5px 10px;
            font-size: 12px;
        }
        
        /* Mobile Menu Button */
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            color: var(--primary-color);
            font-size: 1.5rem;
            cursor: pointer;
            z-index: 1010;
        }
        
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            justify-content: center;
            align-items: center;
        }
        
        .modal-content {
            background-color: white;
            border-radius: 10px;
            max-width: 600px;
            width: 100%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            animation: modalFadeIn 0.3s;
        }
        
        @keyframes modalFadeIn {
            from { transform: translateY(-50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        
        .modal-header {
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid var(--border-color);
        }
        
        .modal-header h2 {
            font-size: 1.3rem;
            color: var(--primary-color);
            display: flex;
            align-items: center;
        }
        
        .modal-header h2 i {
            margin-right: 10px;
        }
        
        .modal-close {
            font-size: 1.5rem;
            color: #888;
            cursor: pointer;
            background: none;
            border: none;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #555;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
        }
        
        .subject-checkboxes {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        
        .subject-checkbox {
            display: flex;
            align-items: center;
        }
        
        .subject-checkbox input[type="checkbox"] {
            margin-right: 8px;
        }
        
        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid var(--border-color);
            text-align: right;
        }
        
        /* Responsive styles */
        @media (max-width: 992px) {
            .task-container {
                grid-template-columns: 1fr;
            }
            
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
                padding: 1.5rem;
            }
            
            .menu-toggle {
                display: flex;
                margin-right: 10px;
            }
            
            .header {
                position: sticky;
                top: 0;
                background-color: #f5f7fa;
                z-index: 900;
                padding: 15px 0;
            }
            
            .task-dates {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .task-start-date,
            .task-deadline {
                margin-bottom: 5px;
            }
        }
        
        @media (max-width: 768px) {
            .header {
                flex-wrap: wrap;
            }
            
            .header-actions {
                margin-top: 10px;
                width: 100%;
                justify-content: space-between;
            }
            
            .task-actions {
                justify-content: flex-start;
                margin-top: 10px;
            }
            
            .btn-add {
                bottom: 20px;
                right: 20px;
                width: 50px;
                height: 50px;
            }
            
            .calendar td,
            .calendar th {
                padding: 5px;
                font-size: 12px;
            }
        }
        
        /* Mobile Filter Navigation */
        .mobile-filter-nav {
            display: none;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 15px;
            width: 100%;
        }
        
        .mobile-filter-item {
            flex: 1;
            min-width: 140px;
            position: relative;
        }
        
        .dropdown-toggle {
            width: 100%;
            padding: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: white;
            border: 1px solid var(--border-color);
            border-radius: 6px;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .dropdown-toggle:hover {
            border-color: var(--primary-color);
        }
        
        .dropdown-toggle i {
            margin-right: 5px;
        }
        
        .dropdown-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            width: 100%;
            z-index: 999;
            background-color: white;
            border-radius: 6px;
            box-shadow: var(--shadow);
            margin-top: 5px;
            max-height: 300px;
            overflow-y: auto;
        }
        
        .dropdown-menu a {
            display: flex;
            align-items: center;
            padding: 10px 15px;
            text-decoration: none;
            color: var(--text-color);
            transition: background-color 0.3s;
        }
        
        .dropdown-menu a i {
            margin-right: 8px;
            width: 16px;
            text-align: center;
        }
        
        .dropdown-menu a:hover {
            background-color: rgba(67, 97, 238, 0.1);
        }
        
        .dropdown-menu a.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        /* Empty state */
        .empty-state {
            text-align: center;
            padding: 2rem;
            color: #888;
        }
        
        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }
        
        .empty-state p {
            font-size: 1rem;
            margin-bottom: 1rem;
        }
        
        /* Task status indicators */
        .status-indicator {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
            margin-left: 8px;
        }
        
        .status-current {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
        }
        
        .status-upcoming {
            background-color: rgba(33, 150, 243, 0.1);
            color: var(--info-color);
        }
        
        .status-completed {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--success-color);
        }
        
        .status-deadline {
            background-color: rgba(244, 67, 54, 0.1);
            color: var(--danger-color);
        }
        
        /* Notification dot for sidebar */
        .notification-dot {
            position: relative;
        }
        
        /* Backdrop for mobile menu */
        .sidebar-backdrop {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }
        
        /* Mobile Filter Panel */
        .mobile-filter-panel {
            display: none;
            position: fixed;
            bottom: 90px;
            left: 20px;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            z-index: 99;
            width: 280px;
            padding: 15px;
            animation: slideUp 0.3s ease;
        }
        
        @keyframes slideUp {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        
        .mobile-filter-panel h3 {
            font-size: 15px;
            margin-bottom: 8px;
            color: var(--primary-color);
            display: flex;
            align-items: center;
        }
        
        .mobile-filter-panel h3 i {
            margin-right: 6px;
            font-size: 14px;
        }
        
        .filter-section {
            margin-bottom: 12px;
        }
        
        .filter-options {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }
        
        .filter-option {
            display: flex;
            align-items: center;
            padding: 6px 10px;
            border-radius: 6px;
            text-decoration: none;
            color: var(--text-color);
            transition: all 0.2s;
            font-size: 13px;
        }
        
        .filter-option:hover {
            background-color: rgba(67, 97, 238, 0.1);
        }
        
        .filter-option.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        .filter-option i {
            margin-right: 8px;
            width: 16px;
            text-align: center;
        }
        
        /* Subject Filter in Mobile Panel */
        .subject-filter-options {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 6px;
        }
        
        .subject-filter-option {
            display: flex;
            align-items: center;
            padding: 5px 8px;
            border-radius: 6px;
            font-size: 12px;
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .subject-filter-option:hover {
            background-color: rgba(67, 97, 238, 0.2);
        }
        
        .subject-filter-option.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        .subject-filter-option i {
            margin-right: 4px;
            font-size: 11px;
        }
        
        /* Show mobile filter elements on small screens */
        @media (max-width: 768px) {
            .mobile-filter-button {
                display: flex;
            }
            
            .mobile-filter-nav {
                display: flex;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Sidebar -->
        <div class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <i class="fas fa-tasks"></i>
                <h1>Kerjain</h1>
            </div>
            
            <div class="sidebar-menu">
                <h2>Kategori</h2>
                <ul>
                    <li>
                        <a href="index.php?category=work&status=<?php echo $currentStatus; ?>" class="<?php echo $currentCategory === 'work' ? 'active' : ''; ?>">
                            <i class="fas fa-briefcase"></i> Pekerjaan
                            <span class="badge"><?php echo count($tasks['work']); ?></span>
                        </a>
                    </li>
                    <li>
                        <a href="index.php?category=personal&status=<?php echo $currentStatus; ?>" class="<?php echo $currentCategory === 'personal' ? 'active' : ''; ?>">
                            <i class="fas fa-user"></i> Pribadi
                            <span class="badge"><?php echo count($tasks['personal']); ?></span>
                        </a>
                    </li>
                </ul>
                
                <h2>Status</h2>
                <ul>
                    <li>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=current" class="<?php echo $currentStatus === 'current' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-day"></i> Saat Ini
                        </a>
                    </li>
                    <li>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=upcoming" class="<?php echo $currentStatus === 'upcoming' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-plus"></i> Mendatang
                        </a>
                    </li>
                    <li>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=deadline" class="<?php echo $currentStatus === 'deadline' ? 'active notification-dot' : 'notification-dot'; ?>">
                            <i class="fas fa-calendar-times"></i> Deadline
                        </a>
                    </li>
                    <li>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=completed" class="<?php echo $currentStatus === 'completed' ? 'active' : ''; ?>">
                            <i class="fas fa-check-circle"></i> Selesai
                        </a>
                    </li>
                </ul>
                
                <h2>Akun</h2>
                <ul>
                    <li>
                        <a href="index.php?logout=1">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Backdrop for mobile sidebar -->
        <div class="sidebar-backdrop" id="sidebarBackdrop"></div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <button class="menu-toggle" id="menuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <div class="page-title">
                    <h1>
                        <?php
                        switch ($currentCategory) {
                            case 'work':
                                echo '<i class="fas fa-briefcase"></i> Tugas Pekerjaan';
                                break;
                            case 'college':
                                echo '<i class="fas fa-graduation-cap"></i> Tugas Kuliah';
                                break;
                            case 'personal':
                                echo '<i class="fas fa-user"></i> Tugas Pribadi';
                                break;
                        }
                        ?>
                    </h1>
                    <p>
                        <?php
                        switch ($currentStatus) {
                            case 'current':
                                echo 'Tugas yang sedang berlangsung';
                                break;
                            case 'upcoming':
                                echo 'Tugas yang akan datang';
                                break;
                            case 'deadline':
                                echo 'Tugas dengan deadline dekat';
                                break;
                            case 'completed':
                                echo 'Tugas yang sudah selesai';
                                break;
                        }
                        ?>
                    </p>
                </div>
                
                <div class="header-actions">
                    <a href="#" class="btn btn-primary" id="addTaskBtn">
                        <i class="fas fa-plus"></i> Tambah Tugas
                    </a>
                </div>
            </div>
            
            <!-- Mobile Filter Navigation -->
            <div class="mobile-filter-nav">
                <div class="mobile-filter-item">
                    <button class="dropdown-toggle" id="categoryDropdownToggle">
                        <i class="fas fa-folder"></i> Kategori
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="categoryDropdownMenu">
                        <a href="index.php?category=work&status=<?php echo $currentStatus; ?>" class="<?php echo $currentCategory === 'work' ? 'active' : ''; ?>">
                            <i class="fas fa-briefcase"></i> Pekerjaan
                        </a>
                        <a href="index.php?category=personal&status=<?php echo $currentStatus; ?>" class="<?php echo $currentCategory === 'personal' ? 'active' : ''; ?>">
                            <i class="fas fa-user"></i> Pribadi
                        </a>
                    </div>
                </div>
                
                <div class="mobile-filter-item">
                    <button class="dropdown-toggle" id="statusDropdownToggle">
                        <i class="fas fa-filter"></i> Status
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="statusDropdownMenu">
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=current" class="<?php echo $currentStatus === 'current' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-day"></i> Saat Ini
                        </a>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=upcoming" class="<?php echo $currentStatus === 'upcoming' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-plus"></i> Mendatang
                        </a>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=deadline" class="<?php echo $currentStatus === 'deadline' ? 'active' : ''; ?>">
                            <i class="fas fa-calendar-times"></i> Deadline
                        </a>
                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=completed" class="<?php echo $currentStatus === 'completed' ? 'active' : ''; ?>">
                            <i class="fas fa-check-circle"></i> Selesai
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Task Container -->
            <div class="task-container">
                <!-- Task List -->
                <div class="task-list-container">
                    <div class="task-list-header">
                        <h2>
                            <?php
                            switch ($currentStatus) {
                                case 'current':
                                    echo '<i class="fas fa-calendar-day"></i> Tugas Saat Ini';
                                    break;
                                case 'upcoming':
                                    echo '<i class="fas fa-calendar-plus"></i> Tugas Mendatang';
                                    break;
                                case 'deadline':
                                    echo '<i class="fas fa-calendar-times"></i> Tugas Deadline';
                                    break;
                                case 'completed':
                                    echo '<i class="fas fa-check-circle"></i> Tugas Selesai';
                                    break;
                            }
                            ?>
                        </h2>
                        <span class="task-count"><?php echo count($filteredTasks); ?></span>
                    </div>
                    
                    <div class="task-list">
                        <?php if (empty($filteredTasks)): ?>
                            <div class="empty-state">
                                <i class="fas fa-clipboard-list"></i>
                                <p>Tidak ada tugas untuk ditampilkan</p>
                                <a href="#" class="btn btn-primary" id="emptyAddTaskBtn">
                                    <i class="fas fa-plus"></i> Tambah Tugas Baru
                                </a>
                            </div>
                        <?php else: ?>
                            <?php foreach ($filteredTasks as $task): 
                                // Tentukan kelas untuk tugas
                                $taskClass = '';
                                $today = date('Y-m-d');
                                
                                if ($task['completed']) {
                                    $taskClass = 'completed';
                                } elseif ($task['deadline'] < $today) {
                                    $taskClass = 'overdue';
                                } elseif ($task['deadline'] == $today) {
                                    $taskClass = 'today';
                                } elseif ($task['start_date'] > $today) {
                                    $taskClass = 'upcoming';
                                }
                            ?>
                                <div class="task-item <?php echo $taskClass; ?> <?php echo $task['completed'] ? 'task-completed' : ''; ?>">
                                    <div class="task-header">
                                        <span class="task-title"><?php echo htmlspecialchars($task['title']); ?></span>
                                        
                                        <?php if ($currentCategory === 'college'): ?>
                                            <span class="status-indicator <?php echo 'status-' . $currentStatus; ?>">
                                                <?php
                                                switch ($currentStatus) {
                                                    case 'current':
                                                        echo 'Saat Ini';
                                                        break;
                                                    case 'upcoming':
                                                        echo 'Mendatang';
                                                        break;
                                                    case 'deadline':
                                                        echo 'Deadline';
                                                        break;
                                                    case 'completed':
                                                        echo 'Selesai';
                                                        break;
                                                }
                                                ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="task-dates">
                                        <div class="task-start-date">
                                            <i class="fas fa-play"></i> Mulai: <?php echo date('d M Y', strtotime($task['start_date'])); ?>
                                        </div>
                                        <div class="task-deadline">
                                            <i class="fas fa-flag"></i> Deadline: <?php echo date('d M Y', strtotime($task['deadline'])); ?>
                                        </div>
                                    </div>
                                    
                                    <?php if (!empty($task['description'])): ?>
                                        <div class="task-description"><?php echo nl2br(htmlspecialchars($task['description'])); ?></div>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($task['link'])): ?>
                                        <div class="task-link">
                                            <a href="<?php echo htmlspecialchars($task['link']); ?>" target="_blank">
                                                <i class="fas fa-link"></i> <?php echo htmlspecialchars($task['link']); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($currentCategory === 'college' && isset($task['subjects']) && !empty($task['subjects'])): ?>
                                        <div class="subject-list">
                                            <?php foreach ($task['subjects'] as $subjectKey => $subject): ?>
                                                <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&task_id=<?php echo $task['id']; ?>&toggle_subject=<?php echo $subjectKey; ?>" 
                                                   class="subject-pill <?php echo $subject['completed'] ? 'completed' : ''; ?>"
                                                   title="<?php echo $subject['completed'] ? 'Batalkan selesai' : 'Tandai selesai'; ?>">
                                                    <i class="<?php echo $subject['completed'] ? 'fas fa-check-circle' : 'fas fa-book'; ?>"></i>
                                                    <?php echo $subject['name']; ?>
                                                </a>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="task-actions">
                                        <?php if (!$task['completed']): ?>
                                            <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&toggle=<?php echo $task['id']; ?>" class="btn btn-sm btn-success">
                                                <i class="fas fa-check"></i> Selesai
                                            </a>
                                        <?php else: ?>
                                            <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&toggle=<?php echo $task['id']; ?>" class="btn btn-sm btn-warning">
                                                <i class="fas fa-undo"></i> Batalkan
                                            </a>
                                        <?php endif; ?>
                                        
                                        <a href="#" class="btn btn-sm btn-info edit-task-btn" data-id="<?php echo $task['id']; ?>">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                        
                                        <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&delete=<?php echo $task['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus tugas ini?');">
                                            <i class="fas fa-trash"></i> Hapus
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Calendar -->
                <div class="calendar-container">
                    <div class="calendar-header">
                        <h2><i class="fas fa-calendar-alt"></i> Kalender</h2>
                        <div class="calendar-nav">
                            <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&month=<?php echo $calendarMonth - 1; ?>&year=<?php echo $calendarYear; ?>">
                                <i class="fas fa-chevron-left"></i>
                            </a>
                            <span class="current-month">
                                <?php 
                                $monthNames = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
                                echo $monthNames[$calendarMonth - 1] . ' ' . $calendarYear; 
                                ?>
                            </span>
                            <a href="index.php?category=<?php echo $currentCategory; ?>&status=<?php echo $currentStatus; ?>&month=<?php echo $calendarMonth + 1; ?>&year=<?php echo $calendarYear; ?>">
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        </div>
                    </div>
                    
                    <table class="calendar">
                        <thead>
                            <tr>
                                <th>Min</th>
                                <th>Sen</th>
                                <th>Sel</th>
                                <th>Rab</th>
                                <th>Kam</th>
                                <th>Jum</th>
                                <th>Sab</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Buat kalender
                            $firstDay = mktime(0, 0, 0, $calendarMonth, 1, $calendarYear);
                            $daysInMonth = date('t', $firstDay);
                            $dayOfWeek = date('w', $firstDay);
                            $today = date('Y-m-d');
                            
                            // Kumpulkan tanggal-tanggal yang memiliki tugas
                            $taskDates = [];
                            foreach ($tasks as $category => $categoryTasks) {
                                foreach ($categoryTasks as $task) {
                                    $startDate = $task['start_date'];
                                    $endDate = $task['deadline'];
                                    
                                    // Tambahkan semua tanggal dari start_date hingga deadline
                                    $currentDate = new DateTime($startDate);
                                    $lastDate = new DateTime($endDate);
                                    
                                    while ($currentDate <= $lastDate) {
                                        $dateStr = $currentDate->format('Y-m-d');
                                        $taskDates[$dateStr] = true;
                                        $currentDate->modify('+1 day');
                                    }
                                }
                            }
                            
                            // Mulai baris kalender
                            echo "<tr>";
                            
                            // Tambahkan sel kosong untuk hari-hari sebelum hari pertama bulan
                            for ($i = 0; $i < $dayOfWeek; $i++) {
                                echo "<td></td>";
                            }
                            
                            // Isi kalender dengan tanggal
                            for ($day = 1; $day <= $daysInMonth; $day++) {
                                $date = sprintf('%04d-%02d-%02d', $calendarYear, $calendarMonth, $day);
                                $class = '';
                                
                                if ($date == $today) {
                                    $class .= ' today';
                                }
                                
                                if (isset($taskDates[$date])) {
                                    $class .= ' has-tasks';
                                }
                                
                                echo "<td class=\"$class\" data-date=\"$date\">$day</td>";
                                
                                // Jika hari ini adalah Sabtu, tutup baris dan mulai baris baru
                                if (($day + $dayOfWeek) % 7 == 0) {
                                    echo "</tr>";
                                    if ($day < $daysInMonth) {
                                        echo "<tr>";
                                    }
                                }
                            }
                            
                            // Tambahkan sel kosong untuk hari-hari setelah hari terakhir bulan
                            $remainingCells = 7 - (($daysInMonth + $dayOfWeek) % 7);
                            if ($remainingCells < 7) {
                                for ($i = 0; $i < $remainingCells; $i++) {
                                    echo "<td></td>";
                                }
                            }
                            
                            // Tutup baris terakhir
                            echo "</tr>";
                            ?>
                        </tbody>
                    </table>
                    
                    <div class="calendar-legend">
                        <div class="legend-item">
                            <span class="legend-dot" style="background-color: rgba(255, 193, 7, 0.5);"></span>
                            Hari ini
                        </div>
                        <div class="legend-item">
                            <span class="legend-dot" style="background-color: var(--primary-color);"></span>
                            Ada tugas
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mobile Filter Panel -->
    <div class="mobile-filter-panel" id="mobileFilterPanel">
        <div class="filter-section">
            <h3><i class="fas fa-folder"></i> Kategori</h3>
            <div class="filter-options">
                <a href="index.php?category=work&status=<?php echo $currentStatus; ?>" class="filter-option <?php echo $currentCategory === 'work' ? 'active' : ''; ?>">
                    <i class="fas fa-briefcase"></i> Pekerjaan
                </a>
                <a href="index.php?category=personal&status=<?php echo $currentStatus; ?>" class="filter-option <?php echo $currentCategory === 'personal' ? 'active' : ''; ?>">
                    <i class="fas fa-user"></i> Pribadi
                </a>
            </div>
        </div>
        
        <div class="filter-section">
            <h3><i class="fas fa-filter"></i> Status</h3>
            <div class="filter-options">
                <a href="index.php?category=<?php echo $currentCategory; ?>&status=current" class="filter-option <?php echo $currentStatus === 'current' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar-day"></i> Saat Ini
                </a>
                <a href="index.php?category=<?php echo $currentCategory; ?>&status=upcoming" class="filter-option <?php echo $currentStatus === 'upcoming' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar-plus"></i> Mendatang
                </a>
                <a href="index.php?category=<?php echo $currentCategory; ?>&status=deadline" class="filter-option <?php echo $currentStatus === 'deadline' ? 'active' : ''; ?>">
                    <i class="fas fa-calendar-times"></i> Deadline
                </a>
                <a href="index.php?category=<?php echo $currentCategory; ?>&status=completed" class="filter-option <?php echo $currentStatus === 'completed' ? 'active' : ''; ?>">
                    <i class="fas fa-check-circle"></i> Selesai
                </a>
            </div>
        </div>
        
        <?php if ($currentCategory === 'college'): ?>
        <div class="filter-section">
            <h3><i class="fas fa-book"></i> Mapel</h3>
            <div class="subject-filter-options">
                <?php foreach ($collegeSubjects as $subjectKey => $subjectName): ?>
                <a href="index.php?category=college&status=<?php echo $currentStatus; ?>&subject=<?php echo $subjectKey; ?>" 
                   class="subject-filter-option <?php echo isset($_GET['subject']) && $_GET['subject'] === $subjectKey ? 'active' : ''; ?>">
                    <i class="fas fa-book"></i> <?php echo $subjectName; ?>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
    <!-- Add/Edit Task Modal -->
    <div class="modal" id="taskModal">
        <div class="modal-content">
            <div class="modal-header">
                <h2 id="modalTitle"><i class="fas fa-tasks"></i> <span>Tambah Tugas Baru</span></h2>
                <button class="modal-close" id="closeModal">&times;</button>
            </div>
            
            <div class="modal-body">
                <form id="taskForm" method="post" action="index.php">
                    <input type="hidden" id="task_id" name="task_id" value="">
                    <input type="hidden" id="original_category" name="original_category" value="">
                    
                    <div class="form-group">
                        <label for="title">Judul Tugas</label>
                        <input type="text" id="title" name="title" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="category">Kategori</label>
                        <select id="category" name="category" class="form-control" required>
                            <option value="work">Pekerjaan</option>
                            <option value="personal">Pribadi</option>
                        </select>
                    </div>
                    
                    <div class="form-group" id="subjectsGroup" style="display: none;">
                        <label>Mapel</label>
                        <div class="subject-checkboxes">
                            <?php foreach ($collegeSubjects as $subjectKey => $subjectName): ?>
                                <div class="subject-checkbox">
                                    <input type="checkbox" id="subject_<?php echo $subjectKey; ?>" name="subjects[]" value="<?php echo $subjectKey; ?>">
                                    <label for="subject_<?php echo $subjectKey; ?>"><?php echo $subjectName; ?></label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="start_date">Tanggal Mulai</label>
                        <input type="text" id="start_date" name="start_date" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="deadline">Deadline</label>
                        <input type="text" id="deadline" name="deadline" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Deskripsi</label>
                        <textarea id="description" name="description" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label for="link">Link (opsional)</label>
                        <input type="url" id="link" name="link" class="form-control">
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline" id="cancelTask">Batal</button>
                        <button type="submit" class="btn btn-primary" id="saveTaskBtn" name="add_task">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Add Task Button -->
    <a href="#" class="btn-add" id="floatingAddTaskBtn">
        <i class="fas fa-plus"></i>
    </a>
    
    <script>
        // Initialize date pickers
        const startDatePicker = flatpickr("#start_date", {
            dateFormat: "Y-m-d",
            defaultDate: "today",
            locale: {
                weekdays: {
                    shorthand: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
                    longhand: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"]
                },
                months: {
                    shorthand: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agt", "Sep", "Okt", "Nov", "Des"],
                    longhand: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"]
                }
            }
        });
        
        const deadlinePicker = flatpickr("#deadline", {
            dateFormat: "Y-m-d",
            defaultDate: "today",
            locale: {
                weekdays: {
                    shorthand: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
                    longhand: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"]
                },
                months: {
                    shorthand: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agt", "Sep", "Okt", "Nov", "Des"],
                    longhand: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"]
                }
            }
        });
        
        // Modal functionality
        const modal = document.getElementById("taskModal");
        const addTaskBtn = document.getElementById("addTaskBtn");
        const floatingAddTaskBtn = document.getElementById("floatingAddTaskBtn");
        const emptyAddTaskBtn = document.getElementById("emptyAddTaskBtn");
        const closeModal = document.getElementById("closeModal");
        const cancelTask = document.getElementById("cancelTask");
        const modalTitle = document.getElementById("modalTitle").querySelector("span");
        const taskForm = document.getElementById("taskForm");
        const saveTaskBtn = document.getElementById("saveTaskBtn");
        const categorySelect = document.getElementById("category");
        const subjectsGroup = document.getElementById("subjectsGroup");
        
        // Toggle subjects visibility based on category selection
        categorySelect.addEventListener("change", function() {
            if (this.value === "college") {
                subjectsGroup.style.display = "block";
            } else {
                subjectsGroup.style.display = "none";
            }
        });
        
        // Open modal in add mode
        function openAddTaskModal() {
            resetForm();
            modalTitle.textContent = "Tambah Tugas Baru";
            saveTaskBtn.name = "add_task";
            
            // Default to current category
            const currentCategory = "<?php echo $currentCategory; ?>";
            categorySelect.value = currentCategory;
            
            // Show subjects if category is college
            if (currentCategory === "college") {
                subjectsGroup.style.display = "block";
            }
            
            modal.style.display = "flex";
        }
        
        addTaskBtn.addEventListener("click", openAddTaskModal);
        floatingAddTaskBtn.addEventListener("click", openAddTaskModal);
        if (emptyAddTaskBtn) {
            emptyAddTaskBtn.addEventListener("click", openAddTaskModal);
        }
        
        // Close modal
        closeModal.addEventListener("click", function() {
            modal.style.display = "none";
        });
        
        cancelTask.addEventListener("click", function() {
            modal.style.display = "none";
        });
        
        window.addEventListener("click", function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        });
        
        // Reset form fields
        function resetForm() {
            taskForm.reset();
            document.getElementById("task_id").value = "";
            document.getElementById("original_category").value = "";
            
            // Reset subject checkboxes
            document.querySelectorAll('input[name="subjects[]"]').forEach(checkbox => {
                checkbox.checked = false;
            });
            
            // Hide subjects group by default
            subjectsGroup.style.display = "none";
            
            // Reset flatpickr
            const today = new Date();
            startDatePicker.setDate(today);
            deadlinePicker.setDate(today);
        }
        
        // Calendar cell click to add task
        document.querySelectorAll('.calendar td[data-date]').forEach(cell => {
            cell.addEventListener('click', function() {
                const dateStr = this.getAttribute('data-date');
                resetForm();
                startDatePicker.setDate(dateStr);
                deadlinePicker.setDate(dateStr);
                
                // Default to current category
                const currentCategory = "<?php echo $currentCategory; ?>";
                categorySelect.value = currentCategory;
                
                // Show subjects if category is college
                if (currentCategory === "college") {
                    subjectsGroup.style.display = "block";
                }
                
                modalTitle.textContent = "Tambah Tugas Baru";
                saveTaskBtn.name = "add_task";
                modal.style.display = "flex";
            });
        });
        
        // Edit task button functionality
        const editButtons = document.querySelectorAll('.edit-task-btn');
        editButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const taskId = this.getAttribute('data-id');
                editTask(taskId);
            });
        });
        
        // Function to load task data for editing
        function editTask(taskId) {
            <?php
            echo "const tasks = " . json_encode($tasks) . ";\n";
            ?>
            
            // Find the task by ID across all categories
            let foundTask = null;
            let category = '';
            
            for (const cat in tasks) {
                for (const task of tasks[cat]) {
                    if (task.id === taskId) {
                        foundTask = task;
                        category = cat;
                        break;
                    }
                }
                if (foundTask) break;
            }
            
            if (foundTask) {
                // Set form values
                document.getElementById("task_id").value = foundTask.id;
                document.getElementById("original_category").value = category;
                document.getElementById("title").value = foundTask.title;
                document.getElementById("category").value = category;
                document.getElementById("description").value = foundTask.description || '';
                document.getElementById("link").value = foundTask.link || '';
                
                // Set dates in flatpickr
                startDatePicker.setDate(foundTask.start_date);
                deadlinePicker.setDate(foundTask.deadline);
                
                // Show/hide subjects based on category
                if (category === "college") {
                    subjectsGroup.style.display = "block";
                    
                    // Check appropriate subject checkboxes
                    if (foundTask.subjects) {
                        document.querySelectorAll('input[name="subjects[]"]').forEach(checkbox => {
                            if (foundTask.subjects[checkbox.value]) {
                                checkbox.checked = true;
                            }
                        });
                    }
                } else {
                    subjectsGroup.style.display = "none";
                }
                
                // Update modal title and submit button name
                modalTitle.textContent = "Edit Tugas";
                saveTaskBtn.name = "edit_task";
                
                // Show the modal
                modal.style.display = "flex";
            } else {
                alert("Tugas tidak ditemukan!");
            }
        }
        
        // Submit task form
        taskForm.addEventListener('submit', function(e) {
            // Client-side validation
            const startDate = new Date(document.getElementById("start_date").value);
            const deadline = new Date(document.getElementById("deadline").value);
            const category = document.getElementById("category").value;
            
            if (deadline < startDate) {
                e.preventDefault();
                alert("Deadline tidak boleh sebelum tanggal mulai!");
                return false;
            }
            
            // Validate subject selection for college tasks
            if (category === "college") {
                const subjectChecked = document.querySelectorAll('input[name="subjects[]"]:checked').length > 0;
                if (!subjectChecked) {
                    e.preventDefault();
                    alert("Pilih minimal satu mapel untuk tugas kuliah!");
                    return false;
                }
            }
            
            return true;
        });
        
        // Mobile Menu Toggle
        const menuToggle = document.getElementById("menuToggle");
        const sidebar = document.getElementById("sidebar");
        const sidebarBackdrop = document.getElementById("sidebarBackdrop");
        
        menuToggle.addEventListener("click", function() {
            sidebar.classList.toggle("active");
            sidebarBackdrop.style.display = sidebar.classList.contains("active") ? "block" : "none";
        });
        
        sidebarBackdrop.addEventListener("click", function() {
            sidebar.classList.remove("active");
            this.style.display = "none";
        });
        
        // Mobile Dropdown Functionality
        const categoryDropdownToggle = document.getElementById("categoryDropdownToggle");
        const categoryDropdownMenu = document.getElementById("categoryDropdownMenu");
        const statusDropdownToggle = document.getElementById("statusDropdownToggle");
        const statusDropdownMenu = document.getElementById("statusDropdownMenu");
        
        categoryDropdownToggle.addEventListener("click", function(e) {
            e.stopPropagation();
            categoryDropdownMenu.style.display = categoryDropdownMenu.style.display === "block" ? "none" : "block";
            statusDropdownMenu.style.display = "none";
        });
        
        statusDropdownToggle.addEventListener("click", function(e) {
            e.stopPropagation();
            statusDropdownMenu.style.display = statusDropdownMenu.style.display === "block" ? "none" : "block";
            categoryDropdownMenu.style.display = "none";
        });
        
        // Mobile Filter Button and Panel
        const mobileFilterButton = document.getElementById("mobileFilterButton");
        const mobileFilterPanel = document.getElementById("mobileFilterPanel");
        
        mobileFilterButton.addEventListener("click", function() {
            mobileFilterPanel.style.display = mobileFilterPanel.style.display === "block" ? "none" : "block";
        });
        
        // Close dropdowns and filter panel when clicking outside
        document.addEventListener("click", function(e) {
            if (!e.target.closest('.mobile-filter-item') && !e.target.closest('.mobile-filter-panel') && !e.target.closest('.mobile-filter-button')) {
                categoryDropdownMenu.style.display = "none";
                statusDropdownMenu.style.display = "none";
                mobileFilterPanel.style.display = "none";
            }
        });
        
        // Add animation classes to elements
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".task-item").forEach((item, index) => {
                item.classList.add("animate__animated", "animate__fadeIn");
                item.style.animationDelay = (index * 0.1) + "s";
            });
        });
    </script>
</body>
</html>
