// JavaScript untuk Aplikasi Pengelola Pelanggaran Ambalan Joko Tole Putri Koening

// Fungsi untuk menampilkan detail anggota dalam modal
function showAnggotaDetail(id) {
    fetch('api/get_anggota.php?id=' + id)
        .then(response => response.json())
        .then(data => {
            document.getElementById('detailNama').textContent = data.nama;
            document.getElementById('detailNomorInduk').textContent = data.nomor_induk;
            document.getElementById('detailJabatan').textContent = data.jabatan;
            document.getElementById('detailAngkatan').textContent = data.angkatan;
            document.getElementById('detailAlamat').textContent = data.alamat;
            document.getElementById('detailNomorWA').textContent = data.nomor_wa;
            document.getElementById('detailTanggalLahir').textContent = data.tanggal_lahir;
            document.getElementById('detailEmail').textContent = data.email;
            
            // Tampilkan tombol WhatsApp
            document.getElementById('waButton').href = 'https://wa.me/' + data.nomor_wa;
            
            // Tampilkan modal
            document.getElementById('anggotaDetailModal').style.display = 'block';
        })
        .catch(error => console.error('Error:', error));
}

// Fungsi untuk menutup modal
function closeModal() {
    document.getElementById('anggotaDetailModal').style.display = 'none';
}

// Fungsi untuk menampilkan tab konten
function openTab(evt, tabName) {
    // Sembunyikan semua konten tab
    var tabcontent = document.getElementsByClassName("tab-content");
    for (var i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }

    // Hapus kelas aktif dari semua tab
    var tablinks = document.getElementsByClassName("tab-link");
    for (var i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }

    // Tampilkan tab yang dipilih dan tambahkan kelas aktif
    document.getElementById(tabName).style.display = "block";
    evt.currentTarget.className += " active";
    
    // Simpan tab aktif di localStorage
    localStorage.setItem('activeTab', tabName);
}

// Ketika dokumen dimuat
document.addEventListener('DOMContentLoaded', function() {
    // Cek apakah ada tab aktif yang tersimpan
    var activeTab = localStorage.getItem('activeTab');
    if (activeTab) {
        // Buka tab yang tersimpan
        document.getElementById(activeTab).style.display = "block";
        // Tambahkan kelas aktif ke tab link
        document.querySelector('[onclick="openTab(event, \'' + activeTab + '\')"]').className += " active";
    } else {
        // Default: buka tab anggota
        document.getElementById('Anggota').style.display = "block";
        document.querySelector('[onclick="openTab(event, \'Anggota\')"]').className += " active";
    }
    
    // Tutup modal ketika mengklik di luar modal
    window.onclick = function(event) {
        var modal = document.getElementById('anggotaDetailModal');
        if (event.target == modal) {
            closeModal();
        }
    }
});
