<?php
// API untuk mendapatkan data anggota berdasarkan ID
header('Content-Type: application/json');

// Fungsi untuk membaca data dari file JSON
function readJsonFile($filename) {
    $jsonData = file_get_contents($filename);
    return json_decode($jsonData, true);
}

// Cek apakah parameter ID ada
if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    // Baca data anggota
    $anggotaData = readJsonFile('../data/anggota.json');
    
    // Cari anggota berdasarkan ID
    $anggota = null;
    foreach ($anggotaData['anggota'] as $item) {
        if ($item['id'] === $id) {
            $anggota = $item;
            break;
        }
    }
    
    // Jika anggota ditemukan, kembalikan data
    if ($anggota) {
        echo json_encode($anggota);
    } else {
        // Jika tidak ditemukan, kembalikan error
        http_response_code(404);
        echo json_encode(['error' => 'Anggota tidak ditemukan']);
    }
} else {
    // Jika parameter ID tidak ada, kembalikan error
    http_response_code(400);
    echo json_encode(['error' => 'Parameter ID diperlukan']);
}
?>
