<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Daftar Penyelenggara</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama</th>
                                <th>Kontak</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $organizers = loadData(ORGANIZERS_FILE);
                            if (empty($organizers)) {
                                echo '<tr><td colspan="2" class="text-center">Belum ada penyelenggara.</td></tr>';
                            } else {
                                foreach ($organizers as $organizer) {
                                    ?>
                                    <tr>
                                        <td><?= htmlspecialchars($organizer['name']) ?></td>
                                        <td><?= htmlspecialchars($organizer['contact']) ?></td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tambah Penyelenggara</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="action" value="add_organizer">
                    <div class="mb-3">
                        <label for="name" class="form-label">Nama</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="contact" class="form-label">Kontak</label>
                        <input type="text" class="form-control" id="contact" name="contact" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </div>
</div>