<?php if ($editEventId): ?>
            <div class="baris-form">
                <div class="form-group">
                    <label>Tanggal Mulai Pendaftaran:</label>
                    <input type="date" name="tanggalMulai" value="<?= $eventUntukEdit['mulai_pendaftaran'] ?? '' ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Durasi Pendaftaran (Hari):</label>
                    <input type="number" name="durasiPendaftaran" value="<?= $eventUntukEdit['durasi_pendaftaran'] ?? 30 ?>" min="25" max="45" required>
                    <small style="color: #666;">25-45 hari optimal</small>
                </div>
            </div>
            <?php endif; ?><?php
session_start();

// Konfigurasi
define('DATA_FILE', 'events.json');
define('LOGIN_PIN', '051205');

// Inisialisasi file data jika belum ada
if (!file_exists(DATA_FILE)) {
    file_put_contents(DATA_FILE, json_encode([], JSON_PRETTY_PRINT));
}

// Fungsi Helper
function muatEvent() {
    $data = file_get_contents(DATA_FILE);
    return json_decode($data, true) ?: [];
}

function simpanEvent($events) {
    file_put_contents(DATA_FILE, json_encode($events, JSON_PRETTY_PRINT));
}

function sudahLogin() {
    return isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;
}

function cariSlotOptimal($eventExisting) {
    $today = new DateTime();
    $mulaiPendaftaran = clone $today;
    $mulaiPendaftaran->modify('+5 days'); // 5 hari persiapan
    
    $opsiSlot = [];
    
    // Coba cari slot optimal untuk 90 hari ke depan
    for ($i = 0; $i < 90; $i += 7) { // Cek tiap minggu
        $testMulai = clone $mulaiPendaftaran;
        $testMulai->modify("+$i days");
        
        // Cari durasi pendaftaran optimal (25-45 hari, berakhir Jumat)
        for ($durasi = 25; $durasi <= 45; $durasi++) {
            $testAkhir = clone $testMulai;
            $testAkhir->modify('+' . ($durasi - 1) . ' days');
            
            // Harus berakhir di Jumat
            if ($testAkhir->format('w') != 5) continue;
            
            // Pelaksanaan harus di Sabtu
            $testPelaksanaan = clone $testAkhir;
            $testPelaksanaan->modify('+1 day');
            
            // Cek konflik dengan event existing (skip jika tidak ada event)
            $konflik = [];
            if (!empty($eventExisting)) {
                $konflik = cekKonflik(['pelaksanaan' => $testPelaksanaan->format('Y-m-d')], $eventExisting);
            }
            
            if (empty($konflik)) {
                // Cek distribusi per bulan (max 3 event)
                $bulanPelaksanaan = $testPelaksanaan->format('Y-m');
                $eventBulanIni = array_filter($eventExisting, function($event) use ($bulanPelaksanaan) {
                    return substr($event['pelaksanaan'], 0, 7) == $bulanPelaksanaan;
                });
                
                if (count($eventBulanIni) < 3) {
                    $opsiSlot[] = [
                        'mulai_pendaftaran' => $testMulai->format('Y-m-d'),
                        'durasi_pendaftaran' => $durasi,
                        'selesai_pendaftaran' => $testAkhir->format('Y-m-d'),
                        'pelaksanaan' => $testPelaksanaan->format('Y-m-d'),
                        'bulan' => $testPelaksanaan->format('F Y'),
                        'event_bulan_ini' => count($eventBulanIni),
                        'skor' => (3 - count($eventBulanIni)) * 10 + (45 - $i) // Prioritas: bulan kosong + lebih cepat
                    ];
                    
                    // Jika sudah dapat 3 opsi yang bagus, stop
                    if (count($opsiSlot) >= 3) break 2;
                }
            }
        }
    }
    
    // Urutkan berdasarkan skor tertinggi
    usort($opsiSlot, function($a, $b) {
        return $b['skor'] - $a['skor'];
    });
    
    return array_slice($opsiSlot, 0, 3); // Ambil 3 opsi terbaik
}

function hitungTimeline($dataInput, $slotTerpilih = null) {
    if ($slotTerpilih) {
        $mulaiPendaftaran = new DateTime($slotTerpilih['mulai_pendaftaran']);
        $durasiPendaftaran = $slotTerpilih['durasi_pendaftaran'];
    } else {
        // Fallback manual
        $mulaiPendaftaran = new DateTime($dataInput['tanggalMulai']);
        $durasiPendaftaran = (int)$dataInput['durasiPendaftaran'];
    }
    
    $susulan = $dataInput['susulan'] ?? 'tidak';
    $hariSusulan = $dataInput['hariSusulan'] ?? 'minggu';
    $babakFinal = $dataInput['babakFinal'] ?? 'tidak';
    
    // Tanggal akhir pendaftaran
    $akhirPendaftaran = clone $mulaiPendaftaran;
    $akhirPendaftaran->modify('+' . ($durasiPendaftaran - 1) . ' hari');
    
    // Tanggal pelaksanaan - HARUS hari Sabtu
    $pelaksanaan = clone $akhirPendaftaran;
    $pelaksanaan->modify('+1 hari');
    
    // Cari Sabtu terdekat
    while ($pelaksanaan->format('w') != 6) {
        $pelaksanaan->modify('+1 hari');
    }
    
    // Tanggal susulan
    $tanggalSusulan = null;
    if ($susulan === 'ya') {
        $tanggalSusulan = clone $pelaksanaan;
        if ($hariSusulan === 'minggu') {
            $tanggalSusulan->modify('+1 hari');
        } else if ($hariSusulan === 'senin') {
            $tanggalSusulan->modify('+2 hari');
        }
    }
    
    // Tanggal pengumuman (3 hari setelah pelaksanaan/susulan) - OTOMATIS
    $pengumuman = $tanggalSusulan ? clone $tanggalSusulan : clone $pelaksanaan;
    $pengumuman->modify('+3 hari');
    
    $timeline = [
        'mulai_pendaftaran' => $mulaiPendaftaran->format('Y-m-d'),
        'selesai_pendaftaran' => $akhirPendaftaran->format('Y-m-d'),
        'pelaksanaan' => $pelaksanaan->format('Y-m-d'),
        'tanggal_susulan' => $tanggalSusulan ? $tanggalSusulan->format('Y-m-d') : null,
        'pengumuman' => $pengumuman->format('Y-m-d'),
        'durasi_pendaftaran' => $durasiPendaftaran,
        'susulan' => $susulan,
        'hari_susulan' => $hariSusulan,
        'babak_final' => $babakFinal
    ];
    
    // Hitung fase tambahan
    if ($babakFinal === 'ya') {
        $daftarUlangMulai = clone $pengumuman;
        $daftarUlangMulai->modify('+1 hari');
        $daftarUlangSelesai = clone $daftarUlangMulai;
        $daftarUlangSelesai->modify('+9 hari');
        
        $tanggalFinal = clone $daftarUlangSelesai;
        $tanggalFinal->modify('+1 hari');
        while ($tanggalFinal->format('w') != 6) {
            $tanggalFinal->modify('+1 hari');
        }
        
        $pengumumanFinal = clone $tanggalFinal;
        $pengumumanFinal->modify('+3 hari');
        
        $aksesPenghargaanMulai = clone $pengumumanFinal;
        $aksesPenghargaanMulai->modify('+1 hari');
        $aksesPenghargaanSelesai = clone $aksesPenghargaanMulai;
        $aksesPenghargaanSelesai->modify('+9 hari');
        
        $sapuBersih = clone $aksesPenghargaanSelesai;
        $sapuBersih->modify('+5 hari');
        
        $timeline['daftar_ulang_mulai'] = $daftarUlangMulai->format('Y-m-d');
        $timeline['daftar_ulang_selesai'] = $daftarUlangSelesai->format('Y-m-d');
        $timeline['tanggal_final'] = $tanggalFinal->format('Y-m-d');
        $timeline['pengumuman_final'] = $pengumumanFinal->format('Y-m-d');
        $timeline['akses_penghargaan_mulai'] = $aksesPenghargaanMulai->format('Y-m-d');
        $timeline['akses_penghargaan_selesai'] = $aksesPenghargaanSelesai->format('Y-m-d');
        $timeline['sapu_bersih'] = $sapuBersih->format('Y-m-d');
    } else {
        $klaimGel1Mulai = clone $pengumuman;
        $klaimGel1Mulai->modify('+1 hari');
        $klaimGel1Selesai = clone $klaimGel1Mulai;
        $klaimGel1Selesai->modify('+9 hari');
        
        $formUmpanBalik = clone $klaimGel1Selesai;
        $formUmpanBalik->modify('+1 hari');
        
        $jeda1Mulai = clone $formUmpanBalik;
        $jeda1Mulai->modify('+1 hari');
        $jeda1Selesai = clone $jeda1Mulai;
        $jeda1Selesai->modify('+4 hari');
        
        $klaimGel2Mulai = clone $jeda1Selesai;
        $klaimGel2Mulai->modify('+1 hari');
        $klaimGel2Selesai = clone $klaimGel2Mulai;
        $klaimGel2Selesai->modify('+13 hari');
        
        $jeda2Mulai = clone $klaimGel2Selesai;
        $jeda2Mulai->modify('+1 hari');
        $jeda2Selesai = clone $jeda2Mulai;
        $jeda2Selesai->modify('+4 hari');
        
        $sapuBersih = clone $jeda2Selesai;
        $sapuBersih->modify('+1 hari');
        
        $timeline['klaim_gel1_mulai'] = $klaimGel1Mulai->format('Y-m-d');
        $timeline['klaim_gel1_selesai'] = $klaimGel1Selesai->format('Y-m-d');
        $timeline['form_umpan_balik'] = $formUmpanBalik->format('Y-m-d');
        $timeline['jeda1_mulai'] = $jeda1Mulai->format('Y-m-d');
        $timeline['jeda1_selesai'] = $jeda1Selesai->format('Y-m-d');
        $timeline['klaim_gel2_mulai'] = $klaimGel2Mulai->format('Y-m-d');
        $timeline['klaim_gel2_selesai'] = $klaimGel2Selesai->format('Y-m-d');
        $timeline['jeda2_mulai'] = $jeda2Mulai->format('Y-m-d');
        $timeline['jeda2_selesai'] = $jeda2Selesai->format('Y-m-d');
        $timeline['sapu_bersih'] = $sapuBersih->format('Y-m-d');
    }
    
    return $timeline;
}

function cekKonflik($eventBaru, $eventExisting, $kecualiId = null) {
    $konflik = [];
    $pelaksanaanBaru = strtotime($eventBaru['pelaksanaan']);
    
    foreach ($eventExisting as $event) {
        if ($kecualiId && $event['id'] == $kecualiId) continue;
        
        $pelaksanaanLama = strtotime($event['pelaksanaan']);
        $selisihHari = abs(($pelaksanaanBaru - $pelaksanaanLama) / (60 * 60 * 24));
        
        if ($selisihHari < 12) {
            $konflik[] = [
                'jenis' => 'jarak',
                'event' => $event,
                'hari' => $selisihHari,
                'pesan' => "Jarak hanya {$selisihHari} hari dengan {$event['nama_lomba']} (minimal 12 hari)"
            ];
        }
        
        $mingguBaru = date('Y-W', $pelaksanaanBaru);
        $mingguLama = date('Y-W', $pelaksanaanLama);
        if ($mingguBaru == $mingguLama) {
            $konflik[] = [
                'jenis' => 'minggu_sama',
                'event' => $event,
                'pesan' => "Pelaksanaan di minggu yang sama dengan {$event['nama_lomba']}"
            ];
        }
    }
    
    return $konflik;
}

function saranTanggalOptimal($tanggalMulai, $eventExisting) {
    $saran = [];
    $mulai = strtotime($tanggalMulai);
    
    for ($i = 0; $i < 60; $i++) {
        $tanggalTest = $mulai + ($i * 24 * 60 * 60);
        
        if (date('w', $tanggalTest) != 6) continue;
        
        $konflik = cekKonflik(['pelaksanaan' => date('Y-m-d', $tanggalTest)], $eventExisting);
        
        if (empty($konflik)) {
            $saran[] = date('Y-m-d', $tanggalTest);
            if (count($saran) >= 3) break;
        }
    }
    
    return $saran;
}

function hitungBebanKerja($events, $bulanTarget = null) {
    $bebanKerja = [];
    $bulanTarget = $bulanTarget ?: date('Y-m');
    
    foreach ($events as $event) {
        $fase = [
            'pra_pendaftaran' => [date('Y-m-d', strtotime($event['mulai_pendaftaran'] . ' -7 days')), $event['mulai_pendaftaran'], 'tinggi'],
            'pendaftaran' => [$event['mulai_pendaftaran'], $event['selesai_pendaftaran'], 'rendah'],
            'pelaksanaan' => [$event['pelaksanaan'], $event['pelaksanaan'], 'tinggi'],
            'packing' => [date('Y-m-d', strtotime($event['pengumuman'] . ' +1 day')), date('Y-m-d', strtotime($event['pengumuman'] . ' +7 days')), 'tinggi']
        ];
        
        foreach ($fase as $namaFase => $data) {
            list($mulai, $selesai, $intensitas) = $data;
            if (substr($mulai, 0, 7) <= $bulanTarget && substr($selesai, 0, 7) >= $bulanTarget) {
                $minggu = date('Y-W', strtotime($mulai));
                if (!isset($bebanKerja[$minggu])) $bebanKerja[$minggu] = 0;
                $bebanKerja[$minggu] += ($intensitas == 'tinggi') ? 3 : 1;
            }
        }
    }
    
    return $bebanKerja;
}

function formatTanggal($tanggal) {
    setlocale(LC_TIME, 'id_ID.UTF-8', 'Indonesian_Indonesia.1252', 'id_ID', 'IND');
    return (new DateTime($tanggal))->format('l, d F Y');
}

function formatRentangTanggal($mulai, $selesai) {
    $tanggalMulai = new DateTime($mulai);
    $tanggalSelesai = new DateTime($selesai);
    
    if ($tanggalMulai->format('Y-m') === $tanggalSelesai->format('Y-m')) {
        return $tanggalMulai->format('l, d') . ' - ' . $tanggalSelesai->format('l, d F Y');
    } else {
        return $tanggalMulai->format('l, d F Y') . ' - ' . $tanggalSelesai->format('l, d F Y');
    }
}

// Tangani Aksi
if ($_POST) {
    if (isset($_POST['login'])) {
        if ($_POST['pin'] === LOGIN_PIN) {
            $_SESSION['logged_in'] = true;
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $error = "PIN salah!";
        }
    } elseif (sudahLogin()) {
        $events = muatEvent();
        
        if (isset($_POST['logout'])) {
            session_destroy();
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit;
        }
        
        if (isset($_POST['cari_slot_otomatis'])) {
            // Validasi input terlebih dahulu
            if (empty($_POST['namaLomba']) || empty($_POST['singkatanLomba']) || empty($_POST['penyelenggara'])) {
                $error = "Mohon lengkapi semua field yang diperlukan!";
            } else {
                $slotOptimal = cariSlotOptimal($events);
                $_SESSION['slot_optimal'] = $slotOptimal;
                $_SESSION['data_form'] = $_POST;
                
                if (empty($slotOptimal)) {
                    $error = "Tidak ditemukan slot optimal. Lihat detail di bawah.";
                }
            }
        }
        
        if (isset($_POST['pilih_slot'])) {
            if (isset($_POST['slot_index']) && isset($_SESSION['slot_optimal']) && isset($_SESSION['data_form'])) {
                $slotIndex = (int)$_POST['slot_index'];
                if (isset($_SESSION['slot_optimal'][$slotIndex])) {
                    $slotTerpilih = $_SESSION['slot_optimal'][$slotIndex];
                    $dataPreview = hitungTimeline($_SESSION['data_form'], $slotTerpilih);
                    $dataPreview = array_merge($_SESSION['data_form'], $dataPreview, ['slot_terpilih' => $slotTerpilih]);
                    $_SESSION['data_preview'] = $dataPreview;
                    unset($_SESSION['slot_optimal']);
                } else {
                    $error = "Slot yang dipilih tidak valid!";
                }
            } else {
                $error = "Data slot tidak lengkap!";
            }
        }
        
        if (isset($_POST['generate_preview'])) {
            // Untuk edit event, gunakan data manual tanpa slot
            if (isset($_POST['event_id']) && !empty($_POST['event_id'])) {
                // Edit mode - gunakan tanggal manual
                $dataPreview = hitungTimeline($_POST);
            } else {
                // Mode baru - gunakan slot atau manual
                $dataPreview = hitungTimeline($_POST);
            }
            $dataPreview = array_merge($_POST, $dataPreview);
            $_SESSION['data_preview'] = $dataPreview;
        }
        
        if (isset($_POST['simpan_event'])) {
            if (isset($_SESSION['data_preview'])) {
                $dataEvent = $_SESSION['data_preview'];
                $dataEvent['id'] = $_POST['event_id'] ?: uniqid();
                $dataEvent['dibuat_pada'] = date('Y-m-d H:i:s');
                
                // Pastikan field yang diperlukan ada
                $dataEvent['nama_lomba'] = $dataEvent['namaLomba'];
                $dataEvent['singkatan_lomba'] = $dataEvent['singkatanLomba'];
                
                $konflik = cekKonflik($dataEvent, $events, $_POST['event_id']);
                
                if (!empty($konflik) && !isset($_POST['paksa_simpan'])) {
                    $peringatanKonflik = $konflik;
                    $eventUntukEdit = $dataEvent;
                } else {
                    if ($_POST['event_id']) {
                        // Update existing event
                        foreach ($events as &$event) {
                            if ($event['id'] == $_POST['event_id']) {
                                $event = array_merge($event, $dataEvent);
                                break;
                            }
                        }
                    } else {
                        // Add new event
                        $events[] = $dataEvent;
                    }
                    simpanEvent($events);
                    unset($_SESSION['data_preview'], $_SESSION['slot_optimal'], $_SESSION['data_form']);
                    $sukses = "Event berhasil disimpan!";
                    $events = muatEvent();
                }
            } else {
                $error = "Data preview tidak ditemukan! Silakan buat preview terlebih dahulu.";
            }
        }
        
        if (isset($_POST['hapus_event'])) {
            $events = array_filter($events, function($event) {
                return $event['id'] != $_POST['event_id'];
            });
            simpanEvent($events);
            $sukses = "Event berhasil dihapus!";
            $events = muatEvent();
        }
    }
}

$tampilan = $_GET['view'] ?? 'generator';
$bulanTampil = $_GET['month'] ?? date('Y-m');
$editEventId = $_GET['edit'] ?? null;
$detailEventId = $_GET['detail'] ?? null;
$events = sudahLogin() ? muatEvent() : [];

if ($editEventId) {
    $eventUntukEdit = array_filter($events, function($event) use ($editEventId) {
        return $event['id'] == $editEventId;
    });
    $eventUntukEdit = reset($eventUntukEdit);
    unset($_SESSION['data_preview'], $_SESSION['slot_optimal']); // Bersihkan preview saat edit
}

if ($detailEventId) {
    $detailEvent = array_filter($events, function($event) use ($detailEventId) {
        return $event['id'] == $detailEventId;
    });
    $detailEvent = reset($detailEvent);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelola Event - Olimpiade</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #2563eb, #1d4ed8); color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px; }
        .nav { display: flex; gap: 10px; margin-bottom: 20px; }
        .nav a { background: #3b82f6; color: white; padding: 10px 20px; border-radius: 5px; text-decoration: none; transition: all 0.3s; }
        .nav a.active, .nav a:hover { background: #1d4ed8; transform: translateY(-1px); }
        .card { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 600; color: #374151; }
        .form-group input, .form-group select { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; }
        .form-group input:focus, .form-group select:focus { outline: none; border-color: #3b82f6; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
        .btn { background: #3b82f6; color: white; padding: 12px 20px; border: none; border-radius: 6px; cursor: pointer; margin-right: 10px; font-weight: 500; transition: all 0.3s; }
        .btn:hover { background: #2563eb; transform: translateY(-1px); }
        .btn-danger { background: #dc2626; }
        .btn-danger:hover { background: #b91c1c; }
        .btn-success { background: #16a34a; }
        .btn-success:hover { background: #15803d; }
        .btn-warning { background: #ea580c; }
        .btn-warning:hover { background: #c2410c; }
        .btn-secondary { background: #6b7280; }
        .btn-secondary:hover { background: #4b5563; }
        .alert { padding: 15px; border-radius: 6px; margin-bottom: 20px; }
        .alert-success { background: #dcfce7; color: #166534; border: 1px solid #bbf7d0; }
        .alert-danger { background: #fef2f2; color: #991b1b; border: 1px solid #fecaca; }
        .alert-warning { background: #fefbeb; color: #92400e; border: 1px solid #fed7aa; }
        .preview-card { background: linear-gradient(135deg, #dbeafe, #e0f2fe); border: 1px solid #3b82f6; padding: 20px; border-radius: 8px; margin: 20px 0; }
        .slot-card { background: #f8fafc; border: 2px solid #e2e8f0; padding: 15px; border-radius: 6px; margin-bottom: 15px; cursor: pointer; transition: all 0.3s; }
        .slot-card:hover { background: #e2e8f0; border-color: #64748b; transform: translateY(-1px); }
        .slot-card.selected { background: #dbeafe; border-color: #3b82f6; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
        .timeline-section { border-left: 4px solid #3b82f6; padding-left: 15px; margin-bottom: 15px; }
        .timeline-section h4 { color: #1d4ed8; margin-bottom: 8px; font-size: 16px; }
        .timeline-section.hijau { border-left-color: #16a34a; }
        .timeline-section.hijau h4 { color: #15803d; }
        .timeline-section.orange { border-left-color: #ea580c; }
        .timeline-section.orange h4 { color: #c2410c; }
        .timeline-section.ungu { border-left-color: #7c3aed; }
        .timeline-section.ungu h4 { color: #6d28d9; }
        .timeline-section.kuning { border-left-color: #eab308; }
        .timeline-section.kuning h4 { color: #ca8a04; }
        .kalender { display: grid; grid-template-columns: repeat(7, 1fr); gap: 2px; margin-top: 20px; }
        .kalender-header { background: #374151; color: white; padding: 10px; text-align: center; font-weight: bold; }
        .kalender-hari { background: white; min-height: 100px; padding: 5px; border: 1px solid #e5e7eb; position: relative; }
        .kalender-hari.bulan-lain { background: #f9fafb; color: #6b7280; }
        .kalender-hari.hari-ini { background: #dbeafe; }
        .event-dot { width: 8px; height: 8px; border-radius: 50%; margin: 1px; display: inline-block; }
        .event-tinggi { background: #dc2626; }
        .event-sedang { background: #ea580c; }
        .event-rendah { background: #16a34a; }
        .peringatan-konflik { background: #fef3c7; border: 1px solid #f59e0b; padding: 15px; border-radius: 6px; margin: 15px 0; }
        .saran { background: #dbeafe; border: 1px solid #3b82f6; padding: 15px; border-radius: 6px; margin: 15px 0; }
        .daftar-event { display: grid; gap: 15px; }
        .item-event { background: white; padding: 15px; border-radius: 8px; border-left: 4px solid #3b82f6; transition: all 0.3s; }
        .item-event:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.15); }
        .flex { display: flex; gap: 10px; align-items: center; }
        .form-login { max-width: 400px; margin: 100px auto; }
        table { width: 100%; border-collapse: collapse; }
        table th, table td { padding: 12px; text-align: left; border-bottom: 1px solid #e5e7eb; }
        table th { background: #f9fafb; font-weight: 600; }
        .beban-tinggi { background: #fef2f2; }
        .beban-sedang { background: #fefbeb; }
        .item-timeline { border-left: 3px solid #3b82f6; padding-left: 15px; margin-bottom: 10px; }
        .nav-bulan { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .nav-bulan h3 { flex: 1; text-align: center; font-size: 24px; color: #1f2937; }
        .grup-radio { display: flex; gap: 15px; align-items: center; }
        .grup-radio label { margin-bottom: 0; cursor: pointer; }
        .baris-form { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .auto-info { background: #f0f9ff; border: 1px solid #0ea5e9; padding: 15px; border-radius: 6px; margin: 15px 0; }
    </style>
</head>
<body>

<?php if (!sudahLogin()): ?>
<div class="container">
    <div class="form-login card">
        <h2>Masuk Pengelola Event</h2>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="form-group">
                <label>PIN:</label>
                <input type="password" name="pin" required placeholder="Masukkan PIN">
            </div>
            <button type="submit" name="login" class="btn">Masuk</button>
        </form>
    </div>
</div>
<?php else: ?>

<div class="container">
    <div class="header flex">
        <h1>🏆 Pengelola Event Olimpiade</h1>
        <div style="margin-left: auto;">
            <span style="margin-right: 15px;">Total Event: <strong><?= count($events) ?></strong></span>
            <form method="POST" style="display: inline;">
                <button type="submit" name="logout" class="btn btn-danger">Keluar</button>
            </form>
        </div>
    </div>

    <div class="nav">
        <a href="?view=generator" class="<?= $tampilan == 'generator' ? 'active' : '' ?>">Buat Event</a>
        <a href="?view=list" class="<?= $tampilan == 'list' ? 'active' : '' ?>">Daftar Event</a>
        <a href="?view=calendar" class="<?= $tampilan == 'calendar' ? 'active' : '' ?>">Kalender</a>
        <a href="?view=analysis" class="<?= $tampilan == 'analysis' ? 'active' : '' ?>">Analisis Beban</a>
    </div>

    <?php if (isset($sukses)): ?>
        <div class="alert alert-success">✅ <?= $sukses ?></div>
    <?php endif; ?>

    <?php if (isset($error)): ?>
        <div class="alert alert-danger">❌ <?= $error ?></div>
    <?php endif; ?>

    <?php if (isset($peringatanKonflik)): ?>
        <div class="peringatan-konflik">
            <h3>⚠️ Peringatan Konflik Jadwal</h3>
            <?php foreach ($peringatanKonflik as $konflik): ?>
                <p>• <?= $konflik['pesan'] ?></p>
            <?php endforeach; ?>
            
            <?php
            $saran = saranTanggalOptimal($eventUntukEdit['pelaksanaan'], $events);
            if (!empty($saran)):
            ?>
                <div class="saran">
                    <strong>💡 Saran Tanggal Optimal:</strong>
                    <?php foreach ($saran as $saranTanggal): ?>
                        <button type="button" onclick="alert('Gunakan fitur Pencarian Otomatis untuk saran yang lebih baik')" class="btn" style="margin: 5px;">
                            <?= formatTanggal($saranTanggal) ?>
                        </button>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            
            <p><strong>Tetap simpan event ini?</strong></p>
            <form method="POST" style="display: inline;">
                <?php foreach ($_POST as $key => $value): ?>
                    <input type="hidden" name="<?= $key ?>" value="<?= htmlspecialchars($value) ?>">
                <?php endforeach; ?>
                <input type="hidden" name="paksa_simpan" value="1">
                <button type="submit" class="btn btn-warning">Ya, Tetap Simpan</button>
                <button type="button" onclick="window.location.reload()" class="btn">Batal</button>
            </form>
        </div>
    <?php endif; ?>

    <?php if ($tampilan == 'generator'): ?>
    <div class="card">
        <h2><?= $editEventId ? 'Ubah Event' : 'Buat Event Baru' ?></h2>
        
        <?php if (!$editEventId && !isset($_SESSION['slot_optimal']) && !isset($_SESSION['data_preview'])): ?>
        <div class="auto-info">
            <h4>🤖 Sistem Penjadwalan Otomatis</h4>
            <p>• <strong>Pendaftaran dimulai 5 hari</strong> setelah event dibuat</p>
            <p>• <strong>Durasi pendaftaran optimal</strong> (25-45 hari, berakhir Jumat)</p>
            <p>• <strong>Pelaksanaan di hari Sabtu</strong> setelah pendaftaran berakhir</p>
            <p>• <strong>Maksimal 3 event per bulan</strong> untuk beban kerja optimal</p>
            <p>• <strong>Jarak minimal 12 hari</strong> antar pelaksanaan event</p>
        </div>
        <?php endif; ?>
        
        <form method="POST" id="formEvent">
            <input type="hidden" name="event_id" value="<?= $editEventId ?>">
            
            <div class="baris-form">
                <div class="form-group">
                    <label>Nama Lomba:</label>
                    <input type="text" name="namaLomba" required value="<?= htmlspecialchars($eventUntukEdit['nama_lomba'] ?? $_SESSION['data_form']['namaLomba'] ?? $_SESSION['data_preview']['namaLomba'] ?? '') ?>" placeholder="Contoh: Olimpiade Sains Nasional">
                </div>
                
                <div class="form-group">
                    <label>Singkatan Lomba:</label>
                    <input type="text" name="singkatanLomba" required value="<?= htmlspecialchars($eventUntukEdit['singkatan_lomba'] ?? $_SESSION['data_form']['singkatanLomba'] ?? $_SESSION['data_preview']['singkatanLomba'] ?? '') ?>" placeholder="Contoh: OSN">
                </div>
            </div>
            
            <div class="form-group">
                <label>Penyelenggara:</label>
                <input type="text" name="penyelenggara" required value="<?= htmlspecialchars($eventUntukEdit['penyelenggara'] ?? $_SESSION['data_form']['penyelenggara'] ?? $_SESSION['data_preview']['penyelenggara'] ?? '') ?>" placeholder="Contoh: Kementerian Pendidikan dan Kebudayaan">
            </div>
            
            <div class="form-group">
                <label>Ada Susulan:</label>
                <div class="grup-radio">
                    <label><input type="radio" name="susulan" value="ya" <?= ($eventUntukEdit['susulan'] ?? $_SESSION['data_form']['susulan'] ?? $_SESSION['data_preview']['susulan'] ?? '') == 'ya' ? 'checked' : '' ?>> Ya</label>
                    <label><input type="radio" name="susulan" value="tidak" <?= ($eventUntukEdit['susulan'] ?? $_SESSION['data_form']['susulan'] ?? $_SESSION['data_preview']['susulan'] ?? 'tidak') == 'tidak' ? 'checked' : '' ?>> Tidak</label>
                    <select name="hariSusulan" style="width: auto; margin-left: 10px;">
                        <option value="minggu" <?= ($eventUntukEdit['hari_susulan'] ?? $_SESSION['data_form']['hariSusulan'] ?? $_SESSION['data_preview']['hariSusulan'] ?? '') == 'minggu' ? 'selected' : '' ?>>Minggu</option>
                        <option value="senin" <?= ($eventUntukEdit['hari_susulan'] ?? $_SESSION['data_form']['hariSusulan'] ?? $_SESSION['data_preview']['hariSusulan'] ?? '') == 'senin' ? 'selected' : '' ?>>Senin</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label>Ada Babak Final:</label>
                <div class="grup-radio">
                    <label><input type="radio" name="babakFinal" value="ya" <?= ($eventUntukEdit['babak_final'] ?? $_SESSION['data_form']['babakFinal'] ?? $_SESSION['data_preview']['babakFinal'] ?? '') == 'ya' ? 'checked' : '' ?>> Ya</label>
                    <label><input type="radio" name="babakFinal" value="tidak" <?= ($eventUntukEdit['babak_final'] ?? $_SESSION['data_form']['babakFinal'] ?? $_SESSION['data_preview']['babakFinal'] ?? 'tidak') == 'tidak' ? 'checked' : '' ?>> Tidak</label>
                </div>
            </div>
            
            <?php if (!$editEventId): ?>
            <button type="submit" name="cari_slot_otomatis" class="btn btn-success">🔍 Cari Slot Otomatis</button>
            <?php else: ?>
            <button type="submit" name="generate_preview" class="btn">📋 Buat Preview Timeline</button>
            <a href="?view=generator" class="btn btn-secondary">Batal</a>
            <?php endif; ?>
        </form>
        
        <?php if (isset($_SESSION['slot_optimal']) && !empty($_SESSION['slot_optimal'])): ?>
        <div class="card" style="margin-top: 20px;">
            <h3>🎯 Slot Optimal Ditemukan</h3>
            <p>Berdasarkan event yang ada, berikut adalah 3 slot terbaik untuk event Anda:</p>
            
            <form method="POST" id="formSlot">
                <?php foreach ($_SESSION['slot_optimal'] as $index => $slot): ?>
                <div class="slot-card" onclick="selectSlot(<?= $index ?>)" id="card_<?= $index ?>">
                    <div style="display: flex; align-items: center;">
                        <input type="radio" name="slot_index" value="<?= $index ?>" id="slot_<?= $index ?>" style="margin-right: 10px;" required>
                        <div style="flex: 1;">
                            <strong>Opsi <?= $index + 1 ?>:</strong> Pelaksanaan di <strong><?= formatTanggal($slot['pelaksanaan']) ?></strong><br>
                            <small style="color: #6b7280;">
                                📅 Pendaftaran: <?= formatRentangTanggal($slot['mulai_pendaftaran'], $slot['selesai_pendaftaran']) ?> (<?= $slot['durasi_pendaftaran'] ?> hari)<br>
                                📊 Event di <?= $slot['bulan'] ?>: <?= $slot['event_bulan_ini'] ?>/3 event
                            </small>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                
                <div style="margin-top: 15px;">
                    <button type="submit" name="pilih_slot" class="btn btn-success">✅ Pilih Slot & Buat Preview</button>
                    <a href="?view=generator" class="btn btn-secondary">Cari Ulang</a>
                </div>
            </form>
        </div>
        <?php elseif (isset($_SESSION['slot_optimal']) && empty($_SESSION['slot_optimal'])): ?>
        <div class="alert alert-warning">
            <h4>😔 Tidak Ada Slot Optimal</h4>
            <p>Tidak ditemukan slot yang cocok dalam 90 hari ke depan dengan kriteria:</p>
            <ul style="margin: 10px 0; padding-left: 20px;">
                <li>Maksimal 3 event per bulan</li>
                <li>Jarak minimal 12 hari antar pelaksanaan</li>
                <li>Pelaksanaan di hari Sabtu</li>
            </ul>
            <p><strong>Saran:</strong></p>
            <ul style="margin: 10px 0; padding-left: 20px;">
                <li>Kurangi jumlah event existing, atau</li>
                <li>Coba lagi bulan depan, atau</li>
                <li>Edit event existing untuk mengatur ulang jadwal</li>
            </ul>
            <a href="?view=generator" class="btn">🔄 Coba Lagi</a>
            <a href="?view=list" class="btn btn-secondary">📋 Lihat Event Existing</a>
        </div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['data_preview'])): 
            $preview = $_SESSION['data_preview'];
        ?>
        <div class="preview-card">
            <h3 style="color: #1d4ed8; margin-bottom: 20px;">📅 Preview Timeline Event</h3>
            
            <?php if (isset($preview['slot_terpilih'])): ?>
            <div style="background: rgba(16, 185, 129, 0.1); padding: 10px; border-radius: 6px; margin-bottom: 15px;">
                <strong>🎯 Slot Terpilih:</strong> Opsi dengan <?= $preview['slot_terpilih']['event_bulan_ini'] ?> event di <?= $preview['slot_terpilih']['bulan'] ?>
            </div>
            <?php endif; ?>
            
            <div class="timeline-section">
                <h4>Informasi Event</h4>
                <p><strong>Nama Lomba:</strong> <?= htmlspecialchars($preview['namaLomba']) ?> (<?= htmlspecialchars($preview['singkatanLomba']) ?>)</p>
                <p><strong>Penyelenggara:</strong> <?= htmlspecialchars($preview['penyelenggara']) ?></p>
            </div>
            
            <div class="timeline-section hijau">
                <h4>Tahap Pendaftaran</h4>
                <p><strong>Pendaftaran:</strong> <?= formatRentangTanggal($preview['mulai_pendaftaran'], $preview['selesai_pendaftaran']) ?></p>
                <small style="color: #6b7280;">Durasi: <?= $preview['durasi_pendaftaran'] ?> hari</small>
            </div>
            
            <div class="timeline-section orange">
                <h4>Tahap Pelaksanaan</h4>
                <p><strong><?= $preview['babakFinal'] == 'ya' ? 'Penyisihan' : 'Pelaksanaan' ?>:</strong> <?= formatTanggal($preview['pelaksanaan']) ?></p>
                <?php if ($preview['susulan'] == 'ya'): ?>
                    <p><strong>Susulan:</strong> <?= formatTanggal($preview['tanggal_susulan']) ?></p>
                <?php endif; ?>
                <p><strong>Pengumuman:</strong> <?= formatTanggal($preview['pengumuman']) ?> <small style="color: #6b7280;">(otomatis 3 hari setelah pelaksanaan)</small></p>
            </div>
            
            <?php if ($preview['babakFinal'] == 'ya'): ?>
            <div class="timeline-section ungu">
                <h4>Tahap Final</h4>
                <p><strong>Daftar Ulang Finalis:</strong> <?= formatRentangTanggal($preview['daftar_ulang_mulai'], $preview['daftar_ulang_selesai']) ?></p>
                <p><strong>Babak Final:</strong> <?= formatTanggal($preview['tanggal_final']) ?></p>
                <p><strong>Pengumuman Pemenang:</strong> <?= formatTanggal($preview['pengumuman_final']) ?></p>
            </div>
            
            <div class="timeline-section kuning">
                <h4>Tahap Penghargaan</h4>
                <p><strong>Akses Penghargaan:</strong> <?= formatRentangTanggal($preview['akses_penghargaan_mulai'], $preview['akses_penghargaan_selesai']) ?></p>
                <p><strong>Sapu Bersih:</strong> <?= formatTanggal($preview['sapu_bersih']) ?></p>
            </div>
            <?php else: ?>
            <div class="timeline-section kuning">
                <h4>Tahap Penghargaan</h4>
                <p><strong>Klaim Penghargaan Gelombang 1:</strong> <?= formatRentangTanggal($preview['klaim_gel1_mulai'], $preview['klaim_gel1_selesai']) ?></p>
                <p><strong>Form Umpan Balik:</strong> <?= formatTanggal($preview['form_umpan_balik']) ?></p>
                <p><strong>Jeda Gelombang 1:</strong> <?= formatRentangTanggal($preview['jeda1_mulai'], $preview['jeda1_selesai']) ?></p>
                <p><strong>Klaim Penghargaan Gelombang 2:</strong> <?= formatRentangTanggal($preview['klaim_gel2_mulai'], $preview['klaim_gel2_selesai']) ?></p>
                <p><strong>Jeda Gelombang 2:</strong> <?= formatRentangTanggal($preview['jeda2_mulai'], $preview['jeda2_selesai']) ?></p>
                <p><strong>Sapu Bersih:</strong> <?= formatTanggal($preview['sapu_bersih']) ?></p>
            </div>
            <?php endif; ?>
            
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <form method="POST" style="display: inline;">
                    <input type="hidden" name="event_id" value="<?= $editEventId ?>">
                    <button type="submit" name="simpan_event" class="btn btn-success">💾 Simpan Event</button>
                </form>
                <button type="button" onclick="window.location.href='?view=generator<?= $editEventId ? '&edit=' . $editEventId : '' ?>'" class="btn btn-secondary">✏️ Edit Timeline</button>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <?php elseif ($tampilan == 'list'): ?>
    <div class="card">
        <h2>📋 Daftar Event (<?= count($events) ?>)</h2>
        
        <?php if (empty($events)): ?>
            <p style="text-align: center; color: #6b7280; padding: 40px;">
                Belum ada event yang dibuat.<br>
                <a href="?view=generator" class="btn" style="margin-top: 15px;">Buat Event Pertama</a>
            </p>
        <?php else: ?>
            <div class="daftar-event">
                <?php foreach ($events as $event): ?>
                <div class="item-event">
                    <div class="flex">
                        <div style="flex: 1;">
                            <h3><?= htmlspecialchars($event['nama_lomba'] ?? $event['namaLomba']) ?> (<?= htmlspecialchars($event['singkatan_lomba'] ?? $event['singkatanLomba']) ?>)</h3>
                            <p><strong>Pelaksanaan:</strong> <?= formatTanggal($event['pelaksanaan']) ?></p>
                            <p><strong>Pendaftaran:</strong> <?= formatRentangTanggal($event['mulai_pendaftaran'], $event['selesai_pendaftaran']) ?></p>
                            <p><strong>Status:</strong> 
                                <?php
                                $today = date('Y-m-d');
                                if ($today < $event['mulai_pendaftaran']) echo '<span style="color: #3b82f6;">🔵 Akan Datang</span>';
                                elseif ($today <= $event['selesai_pendaftaran']) echo '<span style="color: #16a34a;">🟢 Pendaftaran Aktif</span>';
                                elseif ($today <= $event['pelaksanaan']) echo '<span style="color: #ea580c;">🟡 Menuju Pelaksanaan</span>';
                                else echo '<span style="color: #6b7280;">⚪ Selesai</span>';
                                ?>
                            </p>
                        </div>
                        <div>
                            <a href="?view=list&detail=<?= $event['id'] ?>" class="btn btn-secondary">Detail</a>
                            <a href="?view=generator&edit=<?= $event['id'] ?>" class="btn">Edit</a>
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Yakin hapus event ini?')">
                                <input type="hidden" name="event_id" value="<?= $event['id'] ?>">
                                <button type="submit" name="hapus_event" class="btn btn-danger">Hapus</button>
                            </form>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($detailEventId && $detailEvent): ?>
    <div class="card">
        <h3>📋 Detail Timeline: <?= htmlspecialchars($detailEvent['nama_lomba'] ?? $detailEvent['namaLomba']) ?></h3>
        <div style="background: #f8fafc; padding: 20px; border-radius: 8px; margin-top: 15px;">
            <div class="timeline-section">
                <h4>Informasi Event</h4>
                <p><strong>Nama Lomba:</strong> <?= htmlspecialchars($detailEvent['nama_lomba'] ?? $detailEvent['namaLomba']) ?> (<?= htmlspecialchars($detailEvent['singkatan_lomba'] ?? $detailEvent['singkatanLomba']) ?>)</p>
                <p><strong>Penyelenggara:</strong> <?= htmlspecialchars($detailEvent['penyelenggara']) ?></p>
            </div>
            
            <div class="timeline-section hijau">
                <h4>Tahap Pendaftaran</h4>
                <p><strong>Pendaftaran:</strong> <?= formatRentangTanggal($detailEvent['mulai_pendaftaran'], $detailEvent['selesai_pendaftaran']) ?></p>
            </div>
            
            <div class="timeline-section orange">
                <h4>Tahap Pelaksanaan</h4>
                <p><strong><?= ($detailEvent['babak_final'] ?? $detailEvent['babakFinal'] ?? 'tidak') == 'ya' ? 'Penyisihan' : 'Pelaksanaan' ?>:</strong> <?= formatTanggal($detailEvent['pelaksanaan']) ?></p>
                <?php if (($detailEvent['susulan'] ?? 'tidak') == 'ya' && isset($detailEvent['tanggal_susulan'])): ?>
                    <p><strong>Susulan:</strong> <?= formatTanggal($detailEvent['tanggal_susulan']) ?></p>
                <?php endif; ?>
                <p><strong>Pengumuman:</strong> <?= formatTanggal($detailEvent['pengumuman']) ?></p>
            </div>
            
            <?php if (($detailEvent['babak_final'] ?? $detailEvent['babakFinal'] ?? 'tidak') == 'ya'): ?>
            <div class="timeline-section ungu">
                <h4>Tahap Final</h4>
                <?php if (isset($detailEvent['daftar_ulang_mulai'])): ?>
                    <p><strong>Daftar Ulang Finalis:</strong> <?= formatRentangTanggal($detailEvent['daftar_ulang_mulai'], $detailEvent['daftar_ulang_selesai']) ?></p>
                    <p><strong>Babak Final:</strong> <?= formatTanggal($detailEvent['tanggal_final']) ?></p>
                    <p><strong>Pengumuman Pemenang:</strong> <?= formatTanggal($detailEvent['pengumuman_final']) ?></p>
                <?php endif; ?>
            </div>
            
            <div class="timeline-section kuning">
                <h4>Tahap Penghargaan</h4>
                <?php if (isset($detailEvent['akses_penghargaan_mulai'])): ?>
                    <p><strong>Akses Penghargaan:</strong> <?= formatRentangTanggal($detailEvent['akses_penghargaan_mulai'], $detailEvent['akses_penghargaan_selesai']) ?></p>
                    <p><strong>Sapu Bersih:</strong> <?= formatTanggal($detailEvent['sapu_bersih']) ?></p>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="timeline-section kuning">
                <h4>Tahap Penghargaan</h4>
                <?php if (isset($detailEvent['klaim_gel1_mulai'])): ?>
                    <p><strong>Klaim Penghargaan Gelombang 1:</strong> <?= formatRentangTanggal($detailEvent['klaim_gel1_mulai'], $detailEvent['klaim_gel1_selesai']) ?></p>
                    <p><strong>Form Umpan Balik:</strong> <?= formatTanggal($detailEvent['form_umpan_balik']) ?></p>
                    <p><strong>Jeda Gelombang 1:</strong> <?= formatRentangTanggal($detailEvent['jeda1_mulai'], $detailEvent['jeda1_selesai']) ?></p>
                    <p><strong>Klaim Penghargaan Gelombang 2:</strong> <?= formatRentangTanggal($detailEvent['klaim_gel2_mulai'], $detailEvent['klaim_gel2_selesai']) ?></p>
                    <p><strong>Jeda Gelombang 2:</strong> <?= formatRentangTanggal($detailEvent['jeda2_mulai'], $detailEvent['jeda2_selesai']) ?></p>
                    <p><strong>Sapu Bersih:</strong> <?= formatTanggal($detailEvent['sapu_bersih']) ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                <a href="?view=list" class="btn btn-secondary">← Kembali ke Daftar</a>
                <a href="?view=generator&edit=<?= $detailEvent['id'] ?>" class="btn">Edit Event</a>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php elseif ($tampilan == 'calendar'): ?>
    <div class="card">
        <div class="nav-bulan">
            <a href="?view=calendar&month=<?= date('Y-m', strtotime($bulanTampil . '-01 -1 month')) ?>" class="btn">← Bulan Sebelumnya</a>
            <h2><?= (new DateTime($bulanTampil . '-01'))->format('F Y') ?></h2>
            <a href="?view=calendar&month=<?= date('Y-m', strtotime($bulanTampil . '-01 +1 month')) ?>" class="btn">Bulan Berikutnya →</a>
        </div>
        
        <?php
        $hari1 = new DateTime($bulanTampil . '-01');
        $hariAkhir = new DateTime($hari1->format('Y-m-t'));
        $mulaiKalender = clone $hari1;
        $mulaiKalender->modify('last sunday');
        $akhirKalender = clone $hariAkhir;
        $akhirKalender->modify('next saturday');
        
        // Persiapkan data event untuk kalender
        $eventPerTanggal = [];
        foreach ($events as $event) {
            $tanggal = [
                $event['mulai_pendaftaran'] => ['jenis' => 'pendaftaran', 'intensitas' => 'rendah'],
                $event['selesai_pendaftaran'] => ['jenis' => 'akhir_pendaftaran', 'intensitas' => 'sedang'],
                $event['pelaksanaan'] => ['jenis' => 'pelaksanaan', 'intensitas' => 'tinggi'],
                $event['pengumuman'] => ['jenis' => 'pengumuman', 'intensitas' => 'sedang']
            ];
            
            foreach ($tanggal as $tanggalEvent => $info) {
                if (!isset($eventPerTanggal[$tanggalEvent])) $eventPerTanggal[$tanggalEvent] = [];
                $eventPerTanggal[$tanggalEvent][] = array_merge($info, ['event' => $event]);
            }
        }
        ?>
        
        <div class="kalender">
            <div class="kalender-header">Min</div>
            <div class="kalender-header">Sen</div>
            <div class="kalender-header">Sel</div>
            <div class="kalender-header">Rab</div>
            <div class="kalender-header">Kam</div>
            <div class="kalender-header">Jum</div>
            <div class="kalender-header">Sab</div>
            
            <?php
            $tanggalSekarang = clone $mulaiKalender;
            while ($tanggalSekarang <= $akhirKalender) {
                $stringTanggal = $tanggalSekarang->format('Y-m-d');
                $adalahBulanSekarang = $tanggalSekarang->format('Y-m') == $bulanTampil;
                $adalahHariIni = $stringTanggal == date('Y-m-d');
                $eventHari = $eventPerTanggal[$stringTanggal] ?? [];
                
                echo '<div class="kalender-hari' . 
                     ($adalahBulanSekarang ? '' : ' bulan-lain') . 
                     ($adalahHariIni ? ' hari-ini' : '') . '">';
                
                echo '<div>' . $tanggalSekarang->format('j') . '</div>';
                
                foreach ($eventHari as $eventHari) {
                    $kelasEvent = 'event-' . $eventHari['intensitas'];
                    $namaEvent = $eventHari['event']['nama_lomba'] ?? $eventHari['event']['namaLomba'];
                    echo '<div class="event-dot ' . $kelasEvent . '" title="' . 
                         htmlspecialchars($namaEvent) . ' - ' . ucfirst($eventHari['jenis']) . '"></div>';
                }
                
                echo '</div>';
                $tanggalSekarang->modify('+1 day');
            }
            ?>
        </div>
        
        <div style="margin-top: 20px;">
            <h4>Keterangan:</h4>
            <p><span class="event-dot event-rendah"></span> Pendaftaran (Dampak Rendah)</p>
            <p><span class="event-dot event-sedang"></span> Akhir Pendaftaran / Pengumuman (Dampak Sedang)</p>
            <p><span class="event-dot event-tinggi"></span> Pelaksanaan (Dampak Tinggi)</p>
        </div>
    </div>

    <?php elseif ($tampilan == 'analysis'): ?>
    <div class="card">
        <div class="nav-bulan">
            <a href="?view=analysis&month=<?= date('Y-m', strtotime($bulanTampil . '-01 -1 month')) ?>" class="btn">← Bulan Sebelumnya</a>
            <h2>📊 Analisis Beban Kerja - <?= (new DateTime($bulanTampil . '-01'))->format('F Y') ?></h2>
            <a href="?view=analysis&month=<?= date('Y-m', strtotime($bulanTampil . '-01 +1 month')) ?>" class="btn">Bulan Berikutnya →</a>
        </div>
        
        <?php
        $bebanKerja = hitungBebanKerja($events, $bulanTampil);
        $minggu = [];
        
        // Generate minggu untuk bulan target
        $hari1 = new DateTime($bulanTampil . '-01');
        $mulaiMinggu = clone $hari1;
        $mulaiMinggu->modify('last monday');
        
        for ($i = 0; $i < 6; $i++) {
            $awalMinggu = clone $mulaiMinggu;
            $awalMinggu->modify("+$i weeks");
            $akhirMinggu = clone $awalMinggu;
            $akhirMinggu->modify('+6 days');
            $kodeMinggu = $awalMinggu->format('Y-W');
            
            $minggu[$kodeMinggu] = [
                'mulai' => $awalMinggu->format('Y-m-d'),
                'selesai' => $akhirMinggu->format('Y-m-d'),
                'beban' => $bebanKerja[$kodeMinggu] ?? 0
            ];
        }
        ?>
        
        <table>
            <thead>
                <tr>
                    <th>Minggu</th>
                    <th>Tanggal</th>
                    <th>Beban Kerja</th>
                    <th>Status</th>
                    <th>Event di Minggu Ini</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($minggu as $kodeMinggu => $dataMinggu): ?>
                <tr class="<?= $dataMinggu['beban'] > 6 ? 'beban-tinggi' : ($dataMinggu['beban'] > 3 ? 'beban-sedang' : '') ?>">
                    <td>Minggu <?= substr($kodeMinggu, -2) ?></td>
                    <td><?= (new DateTime($dataMinggu['mulai']))->format('d M') ?> - <?= (new DateTime($dataMinggu['selesai']))->format('d M Y') ?></td>
                    <td><?= $dataMinggu['beban'] ?> poin</td>
                    <td>
                        <?php
                        if ($dataMinggu['beban'] > 6) echo '<span style="color: #dc2626;">🔴 Sangat Padat</span>';
                        elseif ($dataMinggu['beban'] > 3) echo '<span style="color: #ea580c;">🟡 Padat</span>';
                        else echo '<span style="color: #16a34a;">🟢 Ringan</span>';
                        ?>
                    </td>
                    <td>
                        <?php
                        $eventMinggu = array_filter($events, function($event) use ($dataMinggu) {
                            return $event['pelaksanaan'] >= $dataMinggu['mulai'] && $event['pelaksanaan'] <= $dataMinggu['selesai'];
                        });
                        
                        foreach ($eventMinggu as $event) {
                            $singkatan = $event['singkatan_lomba'] ?? $event['singkatanLomba'];
                            echo '<span style="font-size: 12px; background: #e5e7eb; padding: 2px 6px; border-radius: 3px; margin-right: 5px;">' . 
                                 htmlspecialchars($singkatan) . '</span>';
                        }
                        ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div style="margin-top: 20px;">
            <h4>📊 Insight Beban Kerja:</h4>
            <div class="item-timeline">
                <strong>Total Event Aktif:</strong> <?= count($events) ?> event
            </div>
            <div class="item-timeline">
                <strong>Minggu Paling Padat:</strong> 
                <?php 
                $bebanMaks = 0;
                $mingguMaks = '';
                foreach ($minggu as $kodeMinggu => $dataMinggu) {
                    if ($dataMinggu['beban'] > $bebanMaks) {
                        $bebanMaks = $dataMinggu['beban'];
                        $mingguMaks = $kodeMinggu;
                    }
                }
                echo $bebanMaks > 0 ? 'Minggu ' . substr($mingguMaks, -2) . ' (' . $bebanMaks . ' poin)' : 'Tidak ada';
                ?>
            </div>
            <div class="item-timeline">
                <strong>Rekomendasi:</strong> 
                <?php
                $mingguPadat = array_filter($minggu, function($dataMinggu) { return $dataMinggu['beban'] > 6; });
                if (count($mingguPadat) > 0) {
                    echo 'Ada ' . count($mingguPadat) . ' minggu dengan beban tinggi. Pertimbangkan untuk mengatur ulang jadwal event.';
                } else {
                    echo 'Beban kerja terdistribusi dengan baik. Bisa menambah 1-2 event lagi di bulan ini.';
                }
                ?>
            </div>
            <div class="item-timeline">
                <strong>Kapasitas Bulan Ini:</strong> 
                <?php
                $eventBulanIni = array_filter($events, function($event) use ($bulanTampil) {
                    return substr($event['pelaksanaan'], 0, 7) == $bulanTampil;
                });
                $jumlahEventBulanIni = count($eventBulanIni);
                echo $jumlahEventBulanIni . '/3 event ';
                if ($jumlahEventBulanIni >= 3) echo '(Sudah Maksimal ❌)';
                elseif ($jumlahEventBulanIni >= 2) echo '(Mendekati Batas ⚠️)';
                else echo '(Masih Bisa Tambah ✅)';
                ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
function selectSlot(index) {
    // Clear all selections
    document.querySelectorAll('.slot-card').forEach(card => {
        card.classList.remove('selected');
    });
    
    // Select the clicked slot
    const radioButton = document.getElementById('slot_' + index);
    const card = document.getElementById('card_' + index);
    
    if (radioButton && card) {
        radioButton.checked = true;
        card.classList.add('selected');
    }
}

// Auto-submit prevention and validation
document.addEventListener('DOMContentLoaded', function() {
    const formSlot = document.getElementById('formSlot');
    if (formSlot) {
        formSlot.addEventListener('submit', function(e) {
            const selectedSlot = document.querySelector('input[name="slot_index"]:checked');
            if (!selectedSlot) {
                e.preventDefault();
                alert('Silakan pilih salah satu slot terlebih dahulu!');
                return false;
            }
        });
    }
    
    // Auto-select first slot if none selected
    const firstSlot = document.getElementById('slot_0');
    if (firstSlot && !document.querySelector('input[name="slot_index"]:checked')) {
        selectSlot(0);
    }
    
    // Form validation untuk form utama
    const formEvent = document.getElementById('formEvent');
    if (formEvent) {
        formEvent.addEventListener('submit', function(e) {
            const namaLomba = document.querySelector('input[name="namaLomba"]');
            const singkatanLomba = document.querySelector('input[name="singkatanLomba"]');
            const penyelenggara = document.querySelector('input[name="penyelenggara"]');
            
            if (!namaLomba.value.trim() || !singkatanLomba.value.trim() || !penyelenggara.value.trim()) {
                e.preventDefault();
                alert('Mohon lengkapi semua field yang diperlukan!');
                return false;
            }
        });
    }
});
</script>

<?php endif; ?>
</body>
</html>