<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $dataFile = 'data.json';
    $data = json_decode(file_get_contents($dataFile), true);
    $blacklist = $data['blacklist'] ?? [];
    $maxEmails = 20;

    // Cek apakah email sudah ada di blacklist
    if (in_array($email, $blacklist)) {
        echo "Email ini sudah diblacklist.";
        exit;
    }

    // Menghasilkan maksimal 20 email dengan dua titik
    $generatedEmails = generateEmails($email, $maxEmails);

    // Menambah email ke blacklist
    $blacklist[] = $email;

    // Update data.json
    $data['blacklist'] = $blacklist;
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT));

    // Tampilkan hasilnya
    echo "<h2>Email yang Dihasilkan:</h2>";
    echo "<ul>";
    foreach ($generatedEmails as $generatedEmail) {
        echo "<li>" . htmlspecialchars($generatedEmail) . "</li>";
    }
    echo "</ul>";
}

function generateEmails($email, $maxEmails) {
    $generatedEmails = [];
    $emailParts = explode('@', $email);
    $localPart = $emailParts[0];
    $domainPart = $emailParts[1];

    for ($i = 0; $i < $maxEmails; $i++) {
        $modifiedEmail = addDots($localPart) . '@' . $domainPart;
        $generatedEmails[] = $modifiedEmail;
    }

    return $generatedEmails;
}

function addDots($localPart) {
    // Menambahkan dua titik pada bagian local email
    $length = strlen($localPart);
    $dotPositions = [rand(1, $length - 1), rand(1, $length - 1)];

    // Pastikan posisi titik tidak sama
    if ($dotPositions[0] == $dotPositions[1]) {
        $dotPositions[1] = ($dotPositions[1] + 1) % $length;
    }

    // Urutkan posisi titik
    sort($dotPositions);

    // Sisipkan titik
    $localPartWithDots = substr($localPart, 0, $dotPositions[0]) . '.' . substr($localPart, $dotPositions[0]);
    $localPartWithDots = substr($localPartWithDots, 0, $dotPositions[1] + 1) . '.' . substr($localPartWithDots, $dotPositions[1] + 1);

    return $localPartWithDots;
}
?>
