<?php
session_start();

// Database file
$data_file = 'data.json';

// Create file if not exists
if (!file_exists($data_file)) {
    $initial_data = [
        'mapel' => [
            'Bank dan Lembaga Keuangan Non Bank',
            'Komunikasi Bisnis',
            'Statistika Ekonomi',
            'Pengantar Akuntansi',
            'Pengantar Ekonomi Mikro',
            'Perekonomian Indonesia'
        ],
        'diskusi' => [],
        'tugas' => [],
        'baca' => [],
        'diskusi_selesai' => [],
        'tugas_selesai' => [],
        'baca_selesai' => [],
        'users' => [
            'rizaldi' => [
                'password' => 'admin123',
                'nama' => 'Super Admin',
                'nim' => 'ADMIN',
                'role' => 'super_admin',
                'expires' => null
            ]
        ],
        'settings' => [
            'theme' => 'default'
        ]
    ];
    file_put_contents($data_file, json_encode($initial_data, JSON_PRETTY_PRINT));
}

// Load data
$data = json_decode(file_get_contents($data_file), true);

    // Login validation
if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    if (isset($data['users'][$username]) && $data['users'][$username]['password'] === $password) {
        // Check if account is expired
        if ($data['users'][$username]['expires'] !== null && strtotime($data['users'][$username]['expires']) < time()) {
            $error = "Akun Anda telah kadaluarsa!";
        } else {
            $_SESSION['logged_in'] = true;
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $data['users'][$username]['role'] ?? 'user';
            $_SESSION['nama'] = $data['users'][$username]['nama'];
            $_SESSION['nim'] = $data['users'][$username]['nim'];
            
            // Redirect to main page
            header('Location: index.php');
            exit();
        }
    } else {
        $error = "Username atau password salah!";
    }
}

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit();
}

// Check if user already logged in
$logged_in = isset($_SESSION['logged_in']) && $_SESSION['logged_in'];
$is_super_admin = $logged_in && isset($_SESSION['role']) && $_SESSION['role'] === 'super_admin';
$username = $logged_in ? $_SESSION['username'] : '';

// Format date 
function formatDate($date) {
    if (empty($date)) return '';
    return date('Y-m-d', strtotime($date));
}

// Save data function
function saveData($data, $file) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

// Handle form submissions if logged in
if ($logged_in) {
    // Add new user (super admin only)
    if (isset($_POST['add_user']) && $is_super_admin) {
        $new_username = trim($_POST['new_username']);
        $new_password = trim($_POST['new_password']);
        $new_nama = trim($_POST['new_nama']);
        $new_nim = trim($_POST['new_nim']);
        $new_expires = !empty($_POST['new_expires']) ? formatDate($_POST['new_expires']) : null;
        
        if (!empty($new_username) && !empty($new_password)) {
            $data['users'][$new_username] = [
                'password' => $new_password,
                'nama' => $new_nama,
                'nim' => $new_nim,
                'role' => 'user',
                'expires' => $new_expires
            ];
            saveData($data, $data_file);
            header('Location: index.php?tab=pengaturan');
            exit();
        }
    }
    
    // Delete user (super admin only)
    if (isset($_GET['delete_user']) && $is_super_admin) {
        $delete_username = $_GET['delete_user'];
        if (isset($data['users'][$delete_username]) && $delete_username !== 'rizaldi') {
            unset($data['users'][$delete_username]);
            saveData($data, $data_file);
        }
        header('Location: index.php?tab=pengaturan');
        exit();
    }
    
    // Add new discussion
    if (isset($_POST['add_diskusi'])) {
        $nomor = $_POST['nomor_diskusi'];
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_diskusi']) ? formatDate($_POST['tanggal_dibuat_diskusi']) : date('Y-m-d');
        $deadline = !empty($_POST['deadline_diskusi']) ? formatDate($_POST['deadline_diskusi']) : '';
        
        $data['diskusi'][] = [
            'nomor' => $nomor,
            'tanggal_dibuat' => $tanggalDibuat,
            'deadline' => $deadline,
            'selesai' => []
        ];
        saveData($data, $data_file);
        header('Location: index.php?tab=diskusi');
        exit();
    }
    
    // Update discussion
    if (isset($_POST['update_diskusi'])) {
        $index = $_POST['diskusi_index'];
        $nomor = $_POST['nomor_diskusi'];
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_diskusi']) ? formatDate($_POST['tanggal_dibuat_diskusi']) : date('Y-m-d');
        $deadline = !empty($_POST['deadline_diskusi']) ? formatDate($_POST['deadline_diskusi']) : '';
        
        $data['diskusi'][$index]['nomor'] = $nomor;
        $data['diskusi'][$index]['tanggal_dibuat'] = $tanggalDibuat;
        $data['diskusi'][$index]['deadline'] = $deadline;
        
        saveData($data, $data_file);
        header('Location: index.php?tab=diskusi');
        exit();
    }
    
    // Delete discussion
    if (isset($_GET['delete_diskusi'])) {
        $index = $_GET['delete_diskusi'];
        if (isset($data['diskusi'][$index])) {
            array_splice($data['diskusi'], $index, 1);
            saveData($data, $data_file);
        }
        header('Location: index.php?tab=diskusi');
        exit();
    }
    
    // Add new task
    if (isset($_POST['add_tugas'])) {
        $nomor = $_POST['nomor_tugas'];
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_tugas']) ? formatDate($_POST['tanggal_dibuat_tugas']) : date('Y-m-d');
        $deadline = !empty($_POST['deadline_tugas']) ? formatDate($_POST['deadline_tugas']) : '';
        
        $data['tugas'][] = [
            'nomor' => $nomor,
            'tanggal_dibuat' => $tanggalDibuat,
            'deadline' => $deadline,
            'selesai' => []
        ];
        saveData($data, $data_file);
        header('Location: index.php?tab=tugas');
        exit();
    }
    
    // Update task
    if (isset($_POST['update_tugas'])) {
        $index = $_POST['tugas_index'];
        $nomor = $_POST['nomor_tugas'];
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_tugas']) ? formatDate($_POST['tanggal_dibuat_tugas']) : date('Y-m-d');
        $deadline = !empty($_POST['deadline_tugas']) ? formatDate($_POST['deadline_tugas']) : '';
        
        $data['tugas'][$index]['nomor'] = $nomor;
        $data['tugas'][$index]['tanggal_dibuat'] = $tanggalDibuat;
        $data['tugas'][$index]['deadline'] = $deadline;
        
        saveData($data, $data_file);
        header('Location: index.php?tab=tugas');
        exit();
    }
    
    // Delete task
    if (isset($_GET['delete_tugas'])) {
        $index = $_GET['delete_tugas'];
        if (isset($data['tugas'][$index])) {
            array_splice($data['tugas'], $index, 1);
            saveData($data, $data_file);
        }
        header('Location: index.php?tab=tugas');
        exit();
    }
    
    // Add new reading
    if (isset($_POST['add_baca'])) {
        $mapel = $_POST['mapel_baca'];
        $jumlahBab = intval($_POST['jumlah_bab']);
        
        // Check if mapel already exists
        $exists = false;
        foreach ($data['baca'] as $index => $baca) {
            if ($baca['mapel'] === $mapel) {
                $data['baca'][$index]['jumlah_bab'] = $jumlahBab;
                $exists = true;
                break;
            }
        }
        
        if (!$exists) {
            $data['baca'][] = [
                'mapel' => $mapel,
                'jumlah_bab' => $jumlahBab,
                'bab_selesai' => []
            ];
        }
        
        saveData($data, $data_file);
        header('Location: index.php?tab=baca');
        exit();
    }
    
    // Update reading
    if (isset($_POST['update_baca'])) {
        $index = $_POST['baca_index'];
        $mapel = $_POST['mapel_baca'];
        $jumlahBab = intval($_POST['jumlah_bab']);
        
        $data['baca'][$index]['mapel'] = $mapel;
        $data['baca'][$index]['jumlah_bab'] = $jumlahBab;
        
        saveData($data, $data_file);
        header('Location: index.php?tab=baca');
        exit();
    }
    
    // Delete reading
    if (isset($_GET['delete_baca'])) {
        $index = $_GET['delete_baca'];
        if (isset($data['baca'][$index])) {
            array_splice($data['baca'], $index, 1);
            saveData($data, $data_file);
        }
        header('Location: index.php?tab=baca');
        exit();
    }
    
    // Mark chapter as read
    if (isset($_POST['complete_bab'])) {
        $baca_index = $_POST['baca_index'];
        $bab_nomor = $_POST['bab_nomor'];
        
        if (!in_array($bab_nomor, $data['baca'][$baca_index]['bab_selesai'])) {
            $data['baca'][$baca_index]['bab_selesai'][] = $bab_nomor;
            sort($data['baca'][$baca_index]['bab_selesai']);
        }
        
        // If all chapters are completed, move to completed readings
        if (count($data['baca'][$baca_index]['bab_selesai']) >= $data['baca'][$baca_index]['jumlah_bab']) {
            $baca = $data['baca'][$baca_index];
            $data['baca_selesai'][] = $baca;
            array_splice($data['baca'], $baca_index, 1);
        }
        
        saveData($data, $data_file);
        header('Location: index.php?tab=baca');
        exit();
    }
    
    // Mark discussion as completed for a subject
    if (isset($_POST['complete_diskusi'])) {
        $diskusi_index = $_POST['diskusi_index'];
        $mapel = $_POST['mapel'];
        
        // Add mapel to completed list if not already there
        if (!in_array($mapel, $data['diskusi'][$diskusi_index]['selesai'])) {
            $data['diskusi'][$diskusi_index]['selesai'][] = $mapel;
        }
        
        // If all subjects are completed, move to completed discussions
        if (count($data['diskusi'][$diskusi_index]['selesai']) >= count($data['mapel'])) {
            $diskusi = $data['diskusi'][$diskusi_index];
            $data['diskusi_selesai'][] = $diskusi;
            array_splice($data['diskusi'], $diskusi_index, 1);
        }
        
        saveData($data, $data_file);
        header('Location: index.php?tab=diskusi');
        exit();
    }
    
    // Mark task as completed for a subject
    if (isset($_POST['complete_tugas'])) {
        $tugas_index = $_POST['tugas_index'];
        $mapel = $_POST['mapel'];
        
        // Add mapel to completed list if not already there
        if (!in_array($mapel, $data['tugas'][$tugas_index]['selesai'])) {
            $data['tugas'][$tugas_index]['selesai'][] = $mapel;
        }
        
        // If all subjects are completed, move to completed tasks
        if (count($data['tugas'][$tugas_index]['selesai']) >= count($data['mapel'])) {
            $tugas = $data['tugas'][$tugas_index];
            $data['tugas_selesai'][] = $tugas;
            array_splice($data['tugas'], $tugas_index, 1);
        }
        
        saveData($data, $data_file);
        header('Location: index.php?tab=tugas');
        exit();
    }
    
    // Edit subject list
    if (isset($_POST['update_mapel'])) {
        $data['mapel'] = array_map('trim', explode("\n", trim($_POST['mapel_list'])));
        // Remove empty lines
        $data['mapel'] = array_filter($data['mapel'], function($value) { return $value !== ''; });
        saveData($data, $data_file);
        header('Location: index.php?tab=pengaturan');
        exit();
    }
    
    // Update theme
    if (isset($_POST['update_theme'])) {
        $data['settings']['theme'] = $_POST['theme'];
        saveData($data, $data_file);
        header('Location: index.php?tab=pengaturan');
        exit();
    }
}

// Get current tab
$current_tab = isset($_GET['tab']) ? $_GET['tab'] : 'diskusi';

// Get theme
$theme = isset($data['settings']['theme']) ? $data['settings']['theme'] : 'default';

// Theme color definitions
$themes = [
    'default' => [
        'primary' => '#4CAF50',
        'secondary' => '#45a049',
        'danger' => '#f44336',
        'warning' => '#ff9800',
        'info' => '#2196F3',
        'dark' => '#333',
        'light' => '#f4f4f4',
        'success' => '#4CAF50'
    ],
    'blue' => [
        'primary' => '#2196F3',
        'secondary' => '#0b7dda',
        'danger' => '#f44336',
        'warning' => '#ff9800',
        'info' => '#00bcd4',
        'dark' => '#333',
        'light' => '#f4f4f4',
        'success' => '#4CAF50'
    ],
    'dark' => [
        'primary' => '#333',
        'secondary' => '#444',
        'danger' => '#f44336',
        'warning' => '#ff9800',
        'info' => '#2196F3',
        'dark' => '#222',
        'light' => '#444',
        'success' => '#4CAF50'
    ],
    'purple' => [
        'primary' => '#9c27b0',
        'secondary' => '#7B1FA2',
        'danger' => '#f44336',
        'warning' => '#ff9800',
        'info' => '#2196F3',
        'dark' => '#333',
        'light' => '#f4f4f4',
        'success' => '#4CAF50'
    ]
];

// Use selected theme or fallback to default
$current_theme = isset($themes[$theme]) ? $themes[$theme] : $themes['default'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tugasin - Aplikasi Manajemen Tugas</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: <?php echo $current_theme['primary']; ?>;
            --secondary-color: <?php echo $current_theme['secondary']; ?>;
            --danger-color: <?php echo $current_theme['danger']; ?>;
            --warning-color: <?php echo $current_theme['warning']; ?>;
            --info-color: <?php echo $current_theme['info']; ?>;
            --dark-color: <?php echo $current_theme['dark']; ?>;
            --light-color: <?php echo $current_theme['light']; ?>;
            --success-color: <?php echo $current_theme['success']; ?>;
            --border-radius: 8px;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            background-color: #f9f9f9;
            color: #333;
            padding-bottom: 60px;
        }
        
        .container {
            width: 100%;
            max-width: 1000px;
            margin: 0 auto;
            padding: 10px;
        }
        
        header {
            background-color: var(--primary-color);
            color: white;
            padding: 0.8rem;
            text-align: center;
            margin-bottom: 15px;
            border-radius: var(--border-radius);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        header h1 {
            margin: 0;
            font-size: 1.5rem;
        }
        
        .logout-btn {
            background-color: rgba(255,255,255,0.2);
            border: none;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
        }
        
        .logout-btn:hover {
            background-color: rgba(255,255,255,0.3);
        }
        
        .login-container {
            max-width: 400px;
            margin: 40px auto;
            background: white;
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        input[type="text"],
        input[type="password"],
        input[type="date"],
        input[type="number"],
        textarea,
        select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        textarea {
            height: 150px;
            resize: vertical;
        }
        
        button, .btn {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            display: inline-block;
            text-decoration: none;
        }
        
        button:hover, .btn:hover {
            background-color: var(--secondary-color);
        }
        
        .btn-sm {
            padding: 4px 8px;
            font-size: 12px;
        }
        
        .btn-danger {
            background-color: var(--danger-color);
        }
        
        .btn-danger:hover {
            background-color: #d32f2f;
        }
        
        .alert {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        
        .alert-danger {
            background-color: #ffebee;
            color: var(--danger-color);
            border: 1px solid #ffcdd2;
        }
        
        .desktop-tabs {
            display: flex;
            border-bottom: 1px solid #ddd;
            margin-bottom: 15px;
        }
        
        .desktop-tab {
            padding: 8px 15px;
            cursor: pointer;
            background-color: #f1f1f1;
            border: 1px solid #ddd;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-right: 3px;
        }
        
        .desktop-tab.active {
            background-color: white;
            border-bottom: 2px solid var(--primary-color);
            font-weight: bold;
        }
        
        .mobile-nav {
            display: none;
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background-color: white;
            box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        .mobile-tabs {
            display: flex;
            justify-content: space-around;
        }
        
        .mobile-tab {
            flex: 1;
            padding: 8px 0;
            font-size: 12px;
            text-align: center;
            cursor: pointer;
            color: #777;
        }
        
        .mobile-tab.active {
            color: var(--primary-color);
            font-weight: bold;
        }
        
        .mobile-tab i {
            display: block;
            margin-bottom: 2px;
            font-size: 16px;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .card {
            background-color: white;
            border-radius: var(--border-radius);
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            padding: 15px;
            margin-bottom: 15px;
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .card-header h3 {
            margin: 0;
            font-size: 1.2rem;
        }
        
        .card-actions {
            display: flex;
            gap: 5px;
        }
        
        .badge {
            display: inline-block;
            padding: 3px 6px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: bold;
            margin-right: 3px;
            margin-bottom: 3px;
        }
        
        .badge-success {
            background-color: var(--success-color);
            color: white;
        }
        
        .badge-warning {
            background-color: var(--warning-color);
            color: white;
        }
        
        .badge-info {
            background-color: var(--info-color);
            color: white;
        }
        
        .badge-danger {
            background-color: var(--danger-color);
            color: white;
        }
        
        .date-info {
            padding: 8px;
            background-color: #f9f9f9;
            border-radius: 4px;
            margin-bottom: 10px;
            font-size: 0.9rem;
        }
        
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.6);
            z-index: 1000;
            overflow-y: auto;
        }
        
        .modal-content {
            background: white;
            border-radius: var(--border-radius);
            padding: 20px;
            width: 90%;
            max-width: 500px;
            margin: 20px auto;
            box-shadow: 0 3px 10px rgba(0,0,0,0.2);
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .modal-header h2 {
            margin: 0;
            font-size: 1.3rem;
        }
        
        .close {
            font-size: 24px;
            cursor: pointer;
        }
        
        .progress-container {
            margin-top: 10px;
            margin-bottom: 15px;
        }
        
        .progress-bar {
            height: 8px;
            background-color: #e0e0e0;
            border-radius: 4px;
            margin-top: 5px;
        }
        
        .progress {
            height: 100%;
            background-color: var(--primary-color);
            border-radius: 4px;
        }
        
        .search-box {
            margin-bottom: 15px;
        }
        
        .actions-row {
            display: flex;
            justify-content: space-between;
            margin-top: 10px;
        }
        
        .fab-button {
            position: fixed;
            bottom: 70px;
            right: 20px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 3px 5px rgba(0,0,0,0.2);
            cursor: pointer;
            z-index: 900;
        }
        
        .fab-button i {
            font-size: 24px;
        }
        
        .mapel-list {
            margin-top: 10px;
        }
        
        .mapel-item {
            padding: 5px 0;
        }
        
        .stats-card {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 15px;
        }
        
        .stat-item {
            flex: 1;
            min-width: 120px;
            background-color: white;
            border-radius: var(--border-radius);
            padding: 10px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08);
            text-align: center;
        }
        
        .stat-value {
            font-size: 24px;
            font-weight: bold;
            color: var(--primary-color);
        }
        
        .stat-label {
            font-size: 12px;
            color: #777;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th, table td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        
        table th {
            background-color: #f1f1f1;
        }
        
        .action-buttons {
            display: flex;
            justify-content: flex-end;
            gap: 5px;
            margin-top: 15px;
        }
        
        .chapter-list {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-top: 10px;
        }
        
        .chapter-item {
            width: 36px;
            height: 36px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 4px;
            background-color: #f1f1f1;
            cursor: pointer;
            font-weight: bold;
        }
        
        .chapter-item.completed {
            background-color: var(--success-color);
            color: white;
        }
        
        .theme-options {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px;
        }
        
        .theme-option {
            width: 80px;
            padding: 10px;
            background-color: #f1f1f1;
            border-radius: 4px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .theme-option.active {
            border: 2px solid var(--primary-color);
        }
        
        .color-preview {
            height: 20px;
            margin-bottom: 5px;
            border-radius: 3px;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .desktop-tabs {
                display: none;
            }
            
            .mobile-nav {
                display: block;
            }
            
            .card-header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .card-actions {
                margin-top: 10px;
                width: 100%;
                justify-content: flex-end;
            }
            
            .container {
                padding: 5px;
            }
            
            header h1 {
                font-size: 1.3rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$logged_in): ?>
            <!-- Login Form -->
            <div class="login-container">
                <h2 style="text-align: center; margin-bottom: 20px;">Tugasin - Login</h2>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>
                
                <form method="post" action="">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" id="username" name="username" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    
                    <button type="submit" name="login" class="btn" style="width: 100%;">Login</button>
                </form>
                
                <div style="margin-top: 15px; text-align: center; font-size: 0.9rem; color: #666;">
                    <p>Untuk informasi login, silahkan hubungi admin.</p>
                </div>
            </div>
        <?php else: ?>
            <!-- Main Application -->
            <header>
                <h1>Tugasin</h1>
                <div>
                    <span style="margin-right: 10px; font-size: 0.9rem;">
                        <i class="fas fa-user"></i> <?php echo isset($_SESSION['nama']) ? $_SESSION['nama'] : $username; ?>
                    </span>
                    <a href="?logout=1" class="logout-btn"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
            </header>
            
            <!-- Desktop Navigation Tabs -->
            <div class="desktop-tabs">
                <div class="desktop-tab <?php echo $current_tab === 'diskusi' ? 'active' : ''; ?>" data-tab="diskusi">Diskusi</div>
                <div class="desktop-tab <?php echo $current_tab === 'tugas' ? 'active' : ''; ?>" data-tab="tugas">Tugas</div>
                <div class="desktop-tab <?php echo $current_tab === 'baca' ? 'active' : ''; ?>" data-tab="baca">Baca</div>
                <div class="desktop-tab <?php echo $current_tab === 'selesai' ? 'active' : ''; ?>" data-tab="selesai">Selesai</div>
                <div class="desktop-tab <?php echo $current_tab === 'pengaturan' ? 'active' : ''; ?>" data-tab="pengaturan">Pengaturan</div>
            </div>
            
            <!-- Mobile Navigation -->
            <nav class="mobile-nav">
                <div class="mobile-tabs">
                    <div class="mobile-tab <?php echo $current_tab === 'diskusi' ? 'active' : ''; ?>" data-tab="diskusi">
                        <i class="fas fa-comments"></i>
                        <span>Diskusi</span>
                    </div>
                    <div class="mobile-tab <?php echo $current_tab === 'tugas' ? 'active' : ''; ?>" data-tab="tugas">
                        <i class="fas fa-tasks"></i>
                        <span>Tugas</span>
                    </div>
                    <div class="mobile-tab <?php echo $current_tab === 'baca' ? 'active' : ''; ?>" data-tab="baca">
                        <i class="fas fa-book"></i>
                        <span>Baca</span>
                    </div>
                    <div class="mobile-tab <?php echo $current_tab === 'selesai' ? 'active' : ''; ?>" data-tab="selesai">
                        <i class="fas fa-check-circle"></i>
                        <span>Selesai</span>
                    </div>
                    <div class="mobile-tab <?php echo $current_tab === 'pengaturan' ? 'active' : ''; ?>" data-tab="pengaturan">
                        <i class="fas fa-cog"></i>
                        <span>Pengaturan</span>
                    </div>
                </div>
            </nav>
            
            <!-- Floating Action Button for Mobile -->
            <div class="fab-button" id="fab-button">
                <i class="fas fa-plus"></i>
            </div>
            
            <!-- Statistik Awal untuk Semua Tab -->
            <div class="stats-card">
                <div class="stat-item">
                    <div class="stat-value"><?php echo count($data['diskusi']); ?></div>
                    <div class="stat-label">Diskusi Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo count($data['tugas']); ?></div>
                    <div class="stat-label">Tugas Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo count($data['baca']); ?></div>
                    <div class="stat-label">Baca Aktif</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value"><?php echo count($data['diskusi_selesai']) + count($data['tugas_selesai']) + count($data['baca_selesai']); ?></div>
                    <div class="stat-label">Total Selesai</div>
                </div>
            </div>
            
            <!-- Diskusi Tab -->
            <div class="tab-content <?php echo $current_tab === 'diskusi' ? 'active' : ''; ?>" id="diskusi-content">
                <!-- Search box -->
                <div class="search-box">
                    <input type="text" id="search-diskusi" placeholder="Cari diskusi..." onkeyup="searchItems('search-diskusi', 'diskusi-list')">
                </div>
                
                <div id="diskusi-list">
                    <?php if (empty($data['diskusi'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada diskusi yang aktif.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['diskusi'] as $index => $diskusi): ?>
                            <div class="card diskusi-card">
                                <div class="card-header">
                                    <h3><?php echo $diskusi['nomor']; ?></h3>
                                    <div class="card-actions">
                                        <button class="btn btn-sm" onclick="openModal('edit-diskusi-modal-<?php echo $index; ?>')"><i class="fas fa-edit"></i></button>
                                        <button class="btn btn-sm" onclick="openModal('diskusi-modal-<?php echo $index; ?>')"><i class="fas fa-check"></i></button>
                                        <button class="btn btn-sm btn-danger" onclick="confirmDelete('delete_diskusi', <?php echo $index; ?>)"><i class="fas fa-trash"></i></button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="date-info">
                                        <p><strong>Tanggal Dibuat:</strong> <?php echo isset($diskusi['tanggal_dibuat']) ? $diskusi['tanggal_dibuat'] : 'Tidak diatur'; ?></p>
                                        <?php if (!empty($diskusi['deadline'])): ?>
                                            <p><strong>Deadline:</strong> <?php echo $diskusi['deadline']; ?>
                                                <?php
                                                    if (!empty($diskusi['deadline'])) {
                                                        $today = time();
                                                        $deadline = strtotime($diskusi['deadline']);
                                                        $days_left = ceil(($deadline - $today) / (60 * 60 * 24));
                                                        
                                                        if ($days_left < 0) {
                                                            echo '<span class="badge badge-danger">Terlambat ' . abs($days_left) . ' hari</span>';
                                                        } else if ($days_left == 0) {
                                                            echo '<span class="badge badge-warning">Hari ini</span>';
                                                        } else if ($days_left <= 3) {
                                                            echo '<span class="badge badge-warning">Tersisa ' . $days_left . ' hari</span>';
                                                        } else {
                                                            echo '<span class="badge badge-info">Tersisa ' . $days_left . ' hari</span>';
                                                        }
                                                    }
                                                ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Progress bar -->
                                    <div class="progress-container">
                                        <small>Progres: <?php echo count($diskusi['selesai']); ?> dari <?php echo count($data['mapel']); ?> mata pelajaran</small>
                                        <div class="progress-bar">
                                            <div class="progress" style="width: <?php echo count($data['mapel']) > 0 ? (count($diskusi['selesai']) / count($data['mapel']) * 100) : 0; ?>%"></div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <strong>Mata Pelajaran yang sudah selesai:</strong>
                                        <div style="margin-top: 5px;">
                                            <?php if (empty($diskusi['selesai'])): ?>
                                                <p>Belum ada mata pelajaran yang selesai.</p>
                                            <?php else: ?>
                                                <?php foreach ($diskusi['selesai'] as $mapel): ?>
                                                    <span class="badge badge-success"><?php echo $mapel; ?></span>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Diskusi Completion Modal -->
                            <div class="modal" id="diskusi-modal-<?php echo $index; ?>">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2>Selesaikan <?php echo $diskusi['nomor']; ?></h2>
                                        <span class="close" onclick="closeModal('diskusi-modal-<?php echo $index; ?>')">&times;</span>
                                    </div>
                                    <div>
                                        <p>Pilih mata pelajaran yang sudah selesai:</p>
                                        <form method="post" action="">
                                            <input type="hidden" name="diskusi_index" value="<?php echo $index; ?>">
                                            
                                            <div class="mapel-list">
                                                <?php foreach ($data['mapel'] as $mapel): ?>
                                                    <div class="mapel-item">
                                                        <label>
                                                            <input type="radio" name="mapel" value="<?php echo $mapel; ?>" class="mapel-checkbox" required 
                                                                <?php echo in_array($mapel, $diskusi['selesai']) ? 'disabled checked' : ''; ?>>
                                                            <?php echo $mapel; ?>
                                                            <?php if (in_array($mapel, $diskusi['selesai'])): ?>
                                                                <span class="badge badge-success">Selesai</span>
                                                            <?php endif; ?>
                                                        </label>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                            
                                            <div class="action-buttons">
                                                <button type="button" onclick="closeModal('diskusi-modal-<?php echo $index; ?>')" class="btn-danger">Batal</button>
                                                <button type="submit" name="complete_diskusi">Simpan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Edit Diskusi Modal -->
                            <div class="modal" id="edit-diskusi-modal-<?php echo $index; ?>">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2>Edit Diskusi</h2>
                                        <span class="close" onclick="closeModal('edit-diskusi-modal-<?php echo $index; ?>')">&times;</span>
                                    </div>
                                    <div>
                                        <form method="post" action="">
                                            <input type="hidden" name="diskusi_index" value="<?php echo $index; ?>">
                                            
                                            <div class="form-group">
                                                <label for="nomor_diskusi_<?php echo $index; ?>">Nomor Diskusi</label>
                                                <input type="text" id="nomor_diskusi_<?php echo $index; ?>" name="nomor_diskusi" value="<?php echo $diskusi['nomor']; ?>" required>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="tanggal_dibuat_diskusi_<?php echo $index; ?>">Tanggal Dibuat</label>
                                                <input type="date" id="tanggal_dibuat_diskusi_<?php echo $index; ?>" name="tanggal_dibuat_diskusi" value="<?php echo $diskusi['tanggal_dibuat']; ?>">
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="deadline_diskusi_<?php echo $index; ?>">Deadline</label>
                                                <input type="date" id="deadline_diskusi_<?php echo $index; ?>" name="deadline_diskusi" value="<?php echo $diskusi['deadline']; ?>">
                                            </div>
                                            
                                            <div class="action-buttons">
                                                <button type="button" onclick="closeModal('edit-diskusi-modal-<?php echo $index; ?>')" class="btn-danger">Batal</button>
                                                <button type="submit" name="update_diskusi">Simpan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Add Diskusi Modal -->
                <div class="modal" id="add-diskusi-modal">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Tambah Diskusi Baru</h2>
                            <span class="close" onclick="closeModal('add-diskusi-modal')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <div class="form-group">
                                    <label for="nomor_diskusi">Nomor Diskusi</label>
                                    <input type="text" id="nomor_diskusi" name="nomor_diskusi" required placeholder="contoh: Diskusi 1">
                                </div>
                                
                                <div class="form-group">
                                    <label for="tanggal_dibuat_diskusi">Tanggal Dibuat</label>
                                    <input type="date" id="tanggal_dibuat_diskusi" name="tanggal_dibuat_diskusi" value="<?php echo date('Y-m-d'); ?>">
                                </div>
                                
                                <div class="form-group">
                                    <label for="deadline_diskusi">Deadline</label>
                                    <input type="date" id="deadline_diskusi" name="deadline_diskusi">
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('add-diskusi-modal')" class="btn-danger">Batal</button>
                                    <button type="submit" name="add_diskusi">Tambah</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tugas Tab -->
            <div class="tab-content <?php echo $current_tab === 'tugas' ? 'active' : ''; ?>" id="tugas-content">
                <!-- Search box -->
                <div class="search-box">
                    <input type="text" id="search-tugas" placeholder="Cari tugas..." onkeyup="searchItems('search-tugas', 'tugas-list')">
                </div>
                
                <div id="tugas-list">
                    <?php if (empty($data['tugas'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada tugas yang aktif.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['tugas'] as $index => $tugas): ?>
                            <div class="card tugas-card">
                                <div class="card-header">
                                    <h3><?php echo $tugas['nomor']; ?></h3>
                                    <div class="card-actions">
                                        <button class="btn btn-sm" onclick="openModal('edit-tugas-modal-<?php echo $index; ?>')"><i class="fas fa-edit"></i></button>
                                        <button class="btn btn-sm" onclick="openModal('tugas-modal-<?php echo $index; ?>')"><i class="fas fa-check"></i></button>
                                        <button class="btn btn-sm btn-danger" onclick="confirmDelete('delete_tugas', <?php echo $index; ?>)"><i class="fas fa-trash"></i></button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="date-info">
                                        <p><strong>Tanggal Dibuat:</strong> <?php echo isset($tugas['tanggal_dibuat']) ? $tugas['tanggal_dibuat'] : 'Tidak diatur'; ?></p>
                                        <?php if (!empty($tugas['deadline'])): ?>
                                            <p><strong>Deadline:</strong> <?php echo $tugas['deadline']; ?>
                                                <?php
                                                    if (!empty($tugas['deadline'])) {
                                                        $today = time();
                                                        $deadline = strtotime($tugas['deadline']);
                                                        $days_left = ceil(($deadline - $today) / (60 * 60 * 24));
                                                        
                                                        if ($days_left < 0) {
                                                            echo '<span class="badge badge-danger">Terlambat ' . abs($days_left) . ' hari</span>';
                                                        } else if ($days_left == 0) {
                                                            echo '<span class="badge badge-warning">Hari ini</span>';
                                                        } else if ($days_left <= 3) {
                                                            echo '<span class="badge badge-warning">Tersisa ' . $days_left . ' hari</span>';
                                                        } else {
                                                            echo '<span class="badge badge-info">Tersisa ' . $days_left . ' hari</span>';
                                                        }
                                                    }
                                                ?>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Progress bar -->
                                    <div class="progress-container">
                                        <small>Progres: <?php echo count($tugas['selesai']); ?> dari <?php echo count($data['mapel']); ?> mata pelajaran</small>
                                        <div class="progress-bar">
                                            <div class="progress" style="width: <?php echo count($data['mapel']) > 0 ? (count($tugas['selesai']) / count($data['mapel']) * 100) : 0; ?>%"></div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <strong>Mata Pelajaran yang sudah selesai:</strong>
                                        <div style="margin-top: 5px;">
                                            <?php if (empty($tugas['selesai'])): ?>
                                                <p>Belum ada mata pelajaran yang selesai.</p>
                                            <?php else: ?>
                                                <?php foreach ($tugas['selesai'] as $mapel): ?>
                                                    <span class="badge badge-success"><?php echo $mapel; ?></span>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Tugas Completion Modal -->
                            <div class="modal" id="tugas-modal-<?php echo $index; ?>">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2>Selesaikan <?php echo $tugas['nomor']; ?></h2>
                                        <span class="close" onclick="closeModal('tugas-modal-<?php echo $index; ?>')">&times;</span>
                                    </div>
                                    <div>
                                        <p>Pilih mata pelajaran yang sudah selesai:</p>
                                        <form method="post" action="">
                                            <input type="hidden" name="tugas_index" value="<?php echo $index; ?>">
                                            
                                            <div class="mapel-list">
                                                <?php foreach ($data['mapel'] as $mapel): ?>
                                                    <div class="mapel-item">
                                                        <label>
                                                            <input type="radio" name="mapel" value="<?php echo $mapel; ?>" class="mapel-checkbox" required
                                                                <?php echo in_array($mapel, $tugas['selesai']) ? 'disabled checked' : ''; ?>>
                                                            <?php echo $mapel; ?>
                                                            <?php if (in_array($mapel, $tugas['selesai'])): ?>
                                                                <span class="badge badge-success">Selesai</span>
                                                            <?php endif; ?>
                                                        </label>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                            
                                            <div class="action-buttons">
                                                <button type="button" onclick="closeModal('tugas-modal-<?php echo $index; ?>')" class="btn-danger">Batal</button>
                                                <button type="submit" name="complete_tugas">Simpan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Edit Tugas Modal -->
                            <div class="modal" id="edit-tugas-modal-<?php echo $index; ?>">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2>Edit Tugas</h2>
                                        <span class="close" onclick="closeModal('edit-tugas-modal-<?php echo $index; ?>')">&times;</span>
                                    </div>
                                    <div>
                                        <form method="post" action="">
                                            <input type="hidden" name="tugas_index" value="<?php echo $index; ?>">
                                            
                                            <div class="form-group">
                                                <label for="nomor_tugas_<?php echo $index; ?>">Nomor Tugas</label>
                                                <input type="text" id="nomor_tugas_<?php echo $index; ?>" name="nomor_tugas" value="<?php echo $tugas['nomor']; ?>" required>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="tanggal_dibuat_tugas_<?php echo $index; ?>">Tanggal Dibuat</label>
                                                <input type="date" id="tanggal_dibuat_tugas_<?php echo $index; ?>" name="tanggal_dibuat_tugas" value="<?php echo $tugas['tanggal_dibuat']; ?>">
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="deadline_tugas_<?php echo $index; ?>">Deadline</label>
                                                <input type="date" id="deadline_tugas_<?php echo $index; ?>" name="deadline_tugas" value="<?php echo $tugas['deadline']; ?>">
                                            </div>
                                            
                                            <div class="action-buttons">
                                                <button type="button" onclick="closeModal('edit-tugas-modal-<?php echo $index; ?>')" class="btn-danger">Batal</button>
                                                <button type="submit" name="update_tugas">Simpan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Add Tugas Modal -->
                <div class="modal" id="add-tugas-modal">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Tambah Tugas Baru</h2>
                            <span class="close" onclick="closeModal('add-tugas-modal')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <div class="form-group">
                                    <label for="nomor_tugas">Nomor Tugas</label>
                                    <input type="text" id="nomor_tugas" name="nomor_tugas" required placeholder="contoh: Tugas 1">
                                </div>
                                
                                <div class="form-group">
                                    <label for="tanggal_dibuat_tugas">Tanggal Dibuat</label>
                                    <input type="date" id="tanggal_dibuat_tugas" name="tanggal_dibuat_tugas" value="<?php echo date('Y-m-d'); ?>">
                                </div>
                                
                                <div class="form-group">
                                    <label for="deadline_tugas">Deadline</label>
                                    <input type="date" id="deadline_tugas" name="deadline_tugas">
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('add-tugas-modal')" class="btn-danger">Batal</button>
                                    <button type="submit" name="add_tugas">Tambah</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Baca Tab -->
            <div class="tab-content <?php echo $current_tab === 'baca' ? 'active' : ''; ?>" id="baca-content">
                <!-- Search box -->
                <div class="search-box">
                    <input type="text" id="search-baca" placeholder="Cari mata pelajaran..." onkeyup="searchItems('search-baca', 'baca-list')">
                </div>
                
                <div id="baca-list">
                    <?php if (empty($data['baca'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada data membaca yang aktif.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['baca'] as $index => $baca): ?>
                            <div class="card baca-card">
                                <div class="card-header">
                                    <h3><?php echo $baca['mapel']; ?></h3>
                                    <div class="card-actions">
                                        <button class="btn btn-sm" onclick="openModal('edit-baca-modal-<?php echo $index; ?>')"><i class="fas fa-edit"></i></button>
                                        <button class="btn btn-sm btn-danger" onclick="confirmDelete('delete_baca', <?php echo $index; ?>)"><i class="fas fa-trash"></i></button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <!-- Progress bar -->
                                    <div class="progress-container">
                                        <small>Progres: <?php echo count($baca['bab_selesai']); ?> dari <?php echo $baca['jumlah_bab']; ?> bab</small>
                                        <div class="progress-bar">
                                            <div class="progress" style="width: <?php echo $baca['jumlah_bab'] > 0 ? (count($baca['bab_selesai']) / $baca['jumlah_bab'] * 100) : 0; ?>%"></div>
                                        </div>
                                    </div>
                                    
                                    <div>
                                        <strong>Bab yang sudah dibaca:</strong>
                                        <div class="chapter-list">
                                            <?php for ($i = 1; $i <= $baca['jumlah_bab']; $i++): ?>
                                                <?php $isCompleted = in_array($i, $baca['bab_selesai']); ?>
                                                <div class="chapter-item <?php echo $isCompleted ? 'completed' : ''; ?>" onclick="markChapterAsRead(<?php echo $index; ?>, <?php echo $i; ?>)">
                                                    <?php echo $i; ?>
                                                </div>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Edit Baca Modal -->
                            <div class="modal" id="edit-baca-modal-<?php echo $index; ?>">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h2>Edit Data Baca</h2>
                                        <span class="close" onclick="closeModal('edit-baca-modal-<?php echo $index; ?>')">&times;</span>
                                    </div>
                                    <div>
                                        <form method="post" action="">
                                            <input type="hidden" name="baca_index" value="<?php echo $index; ?>">
                                            
                                            <div class="form-group">
                                                <label for="mapel_baca_<?php echo $index; ?>">Mata Pelajaran</label>
                                                <input type="text" id="mapel_baca_<?php echo $index; ?>" name="mapel_baca" value="<?php echo $baca['mapel']; ?>" required>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label for="jumlah_bab_<?php echo $index; ?>">Jumlah Bab</label>
                                                <input type="number" id="jumlah_bab_<?php echo $index; ?>" name="jumlah_bab" value="<?php echo $baca['jumlah_bab']; ?>" min="1" required>
                                            </div>
                                            
                                            <div class="action-buttons">
                                                <button type="button" onclick="closeModal('edit-baca-modal-<?php echo $index; ?>')" class="btn-danger">Batal</button>
                                                <button type="submit" name="update_baca">Simpan</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Mark Chapter Read Form (Hidden) -->
                            <form id="mark-chapter-form-<?php echo $index; ?>" method="post" action="" style="display:none;">
                                <input type="hidden" name="baca_index" value="<?php echo $index; ?>">
                                <input type="hidden" id="bab_nomor_<?php echo $index; ?>" name="bab_nomor" value="">
                                <input type="hidden" name="complete_bab" value="1">
                            </form>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Add Baca Modal -->
                <div class="modal" id="add-baca-modal">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Tambah Data Baca</h2>
                            <span class="close" onclick="closeModal('add-baca-modal')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <div class="form-group">
                                    <label for="mapel_baca">Mata Pelajaran</label>
                                    <select id="mapel_baca" name="mapel_baca" required>
                                        <option value="">- Pilih Mata Pelajaran -</option>
                                        <?php foreach ($data['mapel'] as $mapel): ?>
                                            <option value="<?php echo $mapel; ?>"><?php echo $mapel; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="jumlah_bab">Jumlah Bab</label>
                                    <input type="number" id="jumlah_bab" name="jumlah_bab" min="1" value="1" required>
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('add-baca-modal')" class="btn-danger">Batal</button>
                                    <button type="submit" name="add_baca">Tambah</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Selesai Tab -->
            <div class="tab-content <?php echo $current_tab === 'selesai' ? 'active' : ''; ?>" id="selesai-content">
                <!-- Search box -->
                <div class="search-box">
                    <input type="text" id="search-selesai" placeholder="Cari item selesai..." onkeyup="searchItems('search-selesai', 'selesai-list')">
                </div>
                
                <div id="selesai-list">
                    <!-- Diskusi Selesai -->
                    <h3>Diskusi Selesai</h3>
                    <?php if (empty($data['diskusi_selesai'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada diskusi yang selesai.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['diskusi_selesai'] as $diskusi): ?>
                            <div class="card">
                                <div class="card-header">
                                    <h3><?php echo $diskusi['nomor']; ?></h3>
                                    <span class="badge badge-success">Selesai</span>
                                </div>
                                <div class="card-body">
                                    <?php if (isset($diskusi['tanggal_dibuat']) || isset($diskusi['deadline'])): ?>
                                        <div class="date-info">
                                            <?php if (isset($diskusi['tanggal_dibuat'])): ?>
                                                <p><strong>Tanggal Dibuat:</strong> <?php echo $diskusi['tanggal_dibuat']; ?></p>
                                            <?php endif; ?>
                                            <?php if (isset($diskusi['deadline'])): ?>
                                                <p><strong>Deadline:</strong> <?php echo $diskusi['deadline']; ?></p>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    
                    <!-- Tugas Selesai -->
                    <h3 style="margin-top: 20px;">Tugas Selesai</h3>
                    <?php if (empty($data['tugas_selesai'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada tugas yang selesai.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['tugas_selesai'] as $tugas): ?>
                            <div class="card">
                                <div class="card-header">
                                    <h3><?php echo $tugas['nomor']; ?></h3>
                                    <span class="badge badge-success">Selesai</span>
                                </div>
                                <div class="card-body">
                                    <?php if (isset($tugas['tanggal_dibuat']) || isset($tugas['deadline'])): ?>
                                        <div class="date-info">
                                            <?php if (isset($tugas['tanggal_dibuat'])): ?>
                                                <p><strong>Tanggal Dibuat:</strong> <?php echo $tugas['tanggal_dibuat']; ?></p>
                                            <?php endif; ?>
                                            <?php if (isset($tugas['deadline'])): ?>
                                                <p><strong>Deadline:</strong> <?php echo $tugas['deadline']; ?></p>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    
                    <!-- Baca Selesai -->
                    <h3 style="margin-top: 20px;">Baca Selesai</h3>
                    <?php if (empty($data['baca_selesai'])): ?>
                        <div class="card">
                            <div class="card-body">
                                <p>Belum ada baca yang selesai.</p>
                            </div>
                        </div>
                    <?php else: ?>
                        <?php foreach ($data['baca_selesai'] as $baca): ?>
                            <div class="card">
                                <div class="card-header">
                                    <h3><?php echo $baca['mapel']; ?></h3>
                                    <span class="badge badge-success">Selesai</span>
                                </div>
                                <div class="card-body">
                                    <p><strong>Jumlah Bab:</strong> <?php echo $baca['jumlah_bab']; ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Pengaturan Tab -->
            <div class="tab-content <?php echo $current_tab === 'pengaturan' ? 'active' : ''; ?>" id="pengaturan-content">
                <div class="card">
                    <div class="card-header">
                        <h3>Daftar Mata Pelajaran</h3>
                    </div>
                    <div class="card-body">
                        <p>Ubah daftar mata pelajaran (satu baris untuk setiap mata pelajaran):</p>
                        <form method="post" action="">
                            <div class="form-group">
                                <textarea name="mapel_list" rows="8"><?php echo implode("\n", $data['mapel']); ?></textarea>
                            </div>
                            <button type="submit" name="update_mapel">Simpan Perubahan</button>
                        </form>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h3>Pengaturan Tema</h3>
                    </div>
                    <div class="card-body">
                        <p>Pilih tema aplikasi:</p>
                        <form method="post" action="">
                            <div class="theme-options">
                                <?php foreach ($themes as $theme_key => $theme_value): ?>
                                    <div class="theme-option <?php echo $theme === $theme_key ? 'active' : ''; ?>" data-theme="<?php echo $theme_key; ?>">
                                        <div class="color-preview" style="background-color: <?php echo $theme_value['primary']; ?>;"></div>
                                        <div><?php echo ucfirst($theme_key); ?></div>
                                    </div>
                                <?php endforeach; ?>
                                <input type="hidden" name="theme" id="selected-theme" value="<?php echo $theme; ?>">
                            </div>
                            <button type="submit" name="update_theme" style="margin-top: 15px;">Terapkan Tema</button>
                        </form>
                    </div>
                </div>
                
                <?php if ($is_super_admin): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3>Kelola Pengguna</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Username</th>
                                            <th>Nama</th>
                                            <th>NIM</th>
                                            <th>Kedaluwarsa</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($data['users'] as $user_key => $user): ?>
                                            <tr>
                                                <td><?php echo $user_key; ?></td>
                                                <td><?php echo $user['nama']; ?></td>
                                                <td><?php echo $user['nim']; ?></td>
                                                <td><?php echo !empty($user['expires']) ? $user['expires'] : 'Tidak ada'; ?></td>
                                                <td>
                                                    <?php if ($user_key !== 'rizaldi'): ?>
                                                        <a href="?delete_user=<?php echo $user_key; ?>&tab=pengaturan" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus pengguna ini?')">Hapus</a>
                                                    <?php else: ?>
                                                        <span class="badge badge-info">Super Admin</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <div style="margin-top: 20px;">
                                <h4>Tambah Pengguna Baru</h4>
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="new_username">Username</label>
                                        <input type="text" id="new_username" name="new_username" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="new_password">Password</label>
                                        <input type="password" id="new_password" name="new_password" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="new_nama">Nama Lengkap</label>
                                        <input type="text" id="new_nama" name="new_nama" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="new_nim">NIM</label>
                                        <input type="text" id="new_nim" name="new_nim" required>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="new_expires">Kedaluwarsa (opsional)</label>
                                        <input type="date" id="new_expires" name="new_expires">
                                    </div>
                                    
                                    <button type="submit" name="add_user">Tambah Pengguna</button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Mobile Logout Button -->
                <div class="card" style="display: none;" id="mobile-logout-card">
                    <div class="card-body">
                        <a href="?logout=1" class="btn btn-danger" style="width: 100%;">Logout</a>
                    </div>
                </div>
            </div>
            
            <!-- Modal for adding new things based on current tab -->
            <div class="modal" id="add-modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 id="add-modal-title">Tambah Baru</h2>
                        <span class="close" onclick="closeModal('add-modal')">&times;</span>
                    </div>
                    <div id="add-modal-content">
                        <!-- Content will be loaded dynamically -->
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <script>
        // Get current tab from URL or use default
        let currentTab = '<?php echo $current_tab; ?>';
        
        // Function to switch tabs
        function switchTab(tabName) {
            // Update URL with tab parameter
            const newUrl = window.location.pathname + '?tab=' + tabName;
            window.history.replaceState({}, '', newUrl);
            
            // Redirect to the new URL
            window.location.href = newUrl;
        }
        
        // Set click handlers for desktop tabs
        document.querySelectorAll('.desktop-tab').forEach(tab => {
            tab.addEventListener('click', () => {
                const tabName = tab.getAttribute('data-tab');
                switchTab(tabName);
            });
        });
        
        // Set click handlers for mobile tabs
        document.querySelectorAll('.mobile-tab').forEach(tab => {
            tab.addEventListener('click', () => {
                const tabName = tab.getAttribute('data-tab');
                switchTab(tabName);
            });
        });
        
        // Modal functions
        function openModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Search function
        function searchItems(inputId, listId) {
            const input = document.getElementById(inputId);
            const filter = input.value.toUpperCase();
            const list = document.getElementById(listId);
            const cards = list.getElementsByClassName('card');
            
            for (let i = 0; i < cards.length; i++) {
                const card = cards[i];
                const title = card.querySelector('h3');
                if (title) {
                    const txtValue = title.textContent || title.innerText;
                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                        card.style.display = "";
                    } else {
                        card.style.display = "none";
                    }
                }
            }
        }
        
        // Confirm delete function
        function confirmDelete(action, id) {
            if (confirm('Apakah Anda yakin ingin menghapus item ini?')) {
                window.location.href = `?${action}=${id}&tab=${currentTab}`;
            }
        }
        
        // Mark chapter as read
        function markChapterAsRead(bacaIndex, babNomor) {
            document.getElementById(`bab_nomor_${bacaIndex}`).value = babNomor;
            document.getElementById(`mark-chapter-form-${bacaIndex}`).submit();
        }
        
        // Theme selection
        document.querySelectorAll('.theme-option').forEach(option => {
            option.addEventListener('click', () => {
                const theme = option.getAttribute('data-theme');
                document.querySelectorAll('.theme-option').forEach(opt => opt.classList.remove('active'));
                option.classList.add('active');
                document.getElementById('selected-theme').value = theme;
            });
        });
        
        // Floating action button handler
        document.getElementById('fab-button').addEventListener('click', () => {
            switch (currentTab) {
                case 'diskusi':
                    openModal('add-diskusi-modal');
                    break;
                case 'tugas':
                    openModal('add-tugas-modal');
                    break;
                case 'baca':
                    openModal('add-baca-modal');
                    break;
            }
        });
        
        // Show/hide mobile logout button based on screen size
        function handleMobileLogout() {
            const mobileLogoutCard = document.getElementById('mobile-logout-card');
            if (mobileLogoutCard) {
                if (window.innerWidth <= 768) {
                    mobileLogoutCard.style.display = 'block';
                } else {
                    mobileLogoutCard.style.display = 'none';
                }
            }
        }
        
        // Initial call
        handleMobileLogout();
        
        // Add event listener for window resize
        window.addEventListener('resize', handleMobileLogout);
        
        // Close modal when clicking outside
        window.onclick = function(event) {
            document.querySelectorAll('.modal').forEach(modal => {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            });
        }
    </script>
</body>
</html>