<?php
// Cek jika ada permintaan POST untuk menambah akun baru
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $category = $_POST['category'];
    $name = $_POST['name'];
    $link = $_POST['link'];
    
    // Validasi input
    if (empty($category) || empty($name) || empty($link)) {
        $error = "Semua field harus diisi!";
    } else {
        // Baca data yang ada
        $jsonData = file_get_contents('data.json');
        $data = json_decode($jsonData, true);
        
        // Cari kategori yang dipilih
        $categoryFound = false;
        foreach ($data['categories'] as &$cat) {
            if ($cat['name'] === $category) {
                // Tambahkan akun baru ke kategori yang ada
                $cat['accounts'][] = [
                    'name' => $name,
                    'link' => $link
                ];
                $categoryFound = true;
                break;
            }
        }
        
        // Simpan data yang sudah diupdate
        if ($categoryFound) {
            file_put_contents('data.json', json_encode($data, JSON_PRETTY_PRINT));
            $success = "Akun Instagram berhasil ditambahkan!";
            
            // Redirect untuk menghindari resubmit form jika halaman di-refresh
            header("Location: " . $_SERVER['PHP_SELF'] . "?success=1");
            exit;
        } else {
            $error = "Kategori tidak ditemukan!";
        }
    }
}

// Baca data dari file JSON
$jsonData = file_get_contents('data.json');
$data = json_decode($jsonData, true);

// Ambil daftar kategori untuk dropdown
$categories = array_column($data['categories'], 'name');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Link Instagram</title>
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
        }
        .clicked {
            background-color: #d1fae5;
        }
        .unclicked {
            background-color: #ffffff;
        }
        .clicked::before {
            content: '•';
            color: #34d399;
            font-size: 24px;
            margin-right: 10px;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4">
        <h1 class="text-3xl font-bold text-center text-teal-600 mb-8">Link Instagram</h1>
        
        <!-- Alert Sukses -->
        <?php if (isset($_GET['success'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Berhasil!</strong>
            <span class="block sm:inline">Akun Instagram berhasil ditambahkan.</span>
        </div>
        <?php endif; ?>
        
        <!-- Alert Error -->
        <?php if (isset($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error!</strong>
            <span class="block sm:inline"><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <!-- Form untuk menambah akun baru -->
        <div class="bg-white p-6 rounded-lg shadow-md mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Tambah Akun Instagram Baru</h2>
            <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST">
                <input type="hidden" name="action" value="add">
                
                <div class="mb-4">
                    <label for="category" class="block text-gray-700 text-sm font-bold mb-2">Kategori:</label>
                    <select name="category" id="category" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        <?php foreach ($categories as $category): ?>
                        <option value="<?php echo $category; ?>"><?php echo $category; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="mb-4">
                    <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Nama Akun:</label>
                    <input type="text" name="name" id="name" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="Contoh: info.beasiswa">
                </div>
                
                <div class="mb-4">
                    <label for="link" class="block text-gray-700 text-sm font-bold mb-2">Link Instagram:</label>
                    <input type="text" name="link" id="link" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="https://www.instagram.com/nama_akun/">
                </div>
                
                <div class="flex items-center justify-between">
                    <button class="bg-teal-500 hover:bg-teal-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline" type="submit">
                        Tambah
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Kotak Pencarian -->
        <div class="mb-8">
            <input type="text" id="searchInput" placeholder="Cari akun Instagram..." class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" onkeyup="searchAccounts()">
        </div>
        
        <!-- Daftar Kategori dan Akun -->
        <?php foreach ($data['categories'] as $category): ?>
        <div class="mb-8">
            <h2 class="text-2xl font-semibold text-green-500 mb-4"><?php echo $category['name']; ?></h2>
            <ul class="space-y-2" id="<?php echo strtolower(str_replace(' ', '', $category['name'])); ?>List">
                <?php foreach ($category['accounts'] as $account): ?>
                <li class="p-4 bg-white border border-gray-200 rounded-lg shadow-md hover:shadow-lg transition-shadow unclicked">
                    <a href="<?php echo $account['link']; ?>" class="text-lg text-teal-700 hover:underline link" target="_blank"><?php echo $account['name']; ?></a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endforeach; ?>
    </div>
    
    <script>
        // Menandai link yang sudah diklik
        document.querySelectorAll('.link').forEach(link => {
            link.addEventListener('click', function() {
                this.parentElement.classList.remove('unclicked');
                this.parentElement.classList.add('clicked');
            });
        });

        // Fungsi pencarian
        function searchAccounts() {
            const input = document.getElementById('searchInput').value.toLowerCase();
            const lists = document.querySelectorAll('ul');
            
            lists.forEach(list => {
                const items = list.getElementsByTagName('li');
                for (let i = 0; i < items.length; i++) {
                    const text = items[i].textContent || items[i].innerText;
                    if (text.toLowerCase().indexOf(input) > -1) {
                        items[i].style.display = '';
                    } else {
                        items[i].style.display = 'none';
                    }
                }
            });
        }
    </script>
</body>
</html>