<?php
// Cek jika ada permintaan POST untuk menambah kategori baru
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add_category') {
    $categoryName = trim($_POST['category_name']);
    
    // Validasi input
    if (empty($categoryName)) {
        $error = "Nama kategori harus diisi!";
    } else {
        // Baca data yang ada
        $jsonData = file_get_contents('data.json');
        $data = json_decode($jsonData, true);
        
        // Cek apakah kategori sudah ada
        $categoryExists = false;
        foreach ($data['categories'] as $cat) {
            if ($cat['name'] === $categoryName) {
                $categoryExists = true;
                break;
            }
        }
        
        if ($categoryExists) {
            $error = "Kategori '$categoryName' sudah ada!";
        } else {
            // Tambahkan kategori baru
            $data['categories'][] = [
                'name' => $categoryName,
                'accounts' => []
            ];
            
            // Simpan data yang sudah diupdate
            file_put_contents('data.json', json_encode($data, JSON_PRETTY_PRINT));
            
            // Redirect ke halaman utama
            header("Location: index.php?category_added=1");
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Kategori Baru</title>
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto p-4 max-w-lg">
        <h1 class="text-3xl font-bold text-center text-teal-600 mb-8">Tambah Kategori Baru</h1>
        
        <!-- Alert Error -->
        <?php if (isset($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error!</strong>
            <span class="block sm:inline"><?php echo $error; ?></span>
        </div>
        <?php endif; ?>
        
        <!-- Form untuk menambah kategori baru -->
        <div class="bg-white p-6 rounded-lg shadow-md mb-8">
            <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST">
                <input type="hidden" name="action" value="add_category">
                
                <div class="mb-4">
                    <label for="category_name" class="block text-gray-700 text-sm font-bold mb-2">Nama Kategori:</label>
                    <input type="text" name="category_name" id="category_name" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="Contoh: Magang">
                </div>
                
                <div class="flex items-center justify-between">
                    <button class="bg-teal-500 hover:bg-teal-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline" type="submit">
                        Tambah Kategori
                    </button>
                    <a href="index.php" class="inline-block align-baseline font-bold text-sm text-teal-500 hover:text-teal-800">
                        Kembali
                    </a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>